/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.versions;

import com.intellij.framework.library.LibraryVersionProperties;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryPresentationProvider;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginUtil;
import org.jetbrains.kotlin.idea.framework.JSLibraryStdPresentationProvider;
import org.jetbrains.kotlin.idea.framework.JavaRuntimePresentationProvider;
import org.jetbrains.kotlin.idea.framework.KotlinLibraryUtilKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.idea.versions.KotlinRuntimeLibraryUtilKt;
import org.jetbrains.kotlin.idea.versions.OutdatedKotlinRuntimeCheckerKt;
import org.jetbrains.kotlin.idea.versions.VersionedLibrary;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u001a\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00042\u0006\u0010\n\u001a\u00020\u000b\u001a\u0018\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0010\u001a\u00020\u0001\u001a\u001c\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013\u001a\u001e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00150\u0013H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"OUTDATED_RUNTIME_GROUP_DISPLAY_ID", "", "SUPPRESSED_PROPERTY_NAME", "collectModulesWithOutdatedRuntime", "", "Lcom/intellij/openapi/module/Module;", "libraries", "Lorg/jetbrains/kotlin/idea/versions/VersionedLibrary;", "deleteKotlinJs", "", "project", "Lcom/intellij/openapi/project/Project;", "findOutdatedKotlinLibraries", "isRuntimeOutdated", "", "libraryVersion", "runtimeVersion", "notifyOutdatedKotlinRuntime", "outdatedLibraries", "", "suggestDeleteKotlinJsIfNeeded", "Lcom/intellij/openapi/roots/libraries/Library;", "idea"})
public final class OutdatedKotlinRuntimeCheckerKt {
    private static final String SUPPRESSED_PROPERTY_NAME = "oudtdated.runtime.suppressed.plugin.version";
    private static final String OUTDATED_RUNTIME_GROUP_DISPLAY_ID = "Outdated Kotlin Runtime";

    @NotNull
    public static final List<VersionedLibrary> findOutdatedKotlinLibraries(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        String pluginVersion = KotlinPluginUtil.getPluginVersion();
        if (Intrinsics.areEqual((Object)"@snapshot@", (Object)pluginVersion)) {
            return CollectionsKt.emptyList();
        }
        if (Intrinsics.areEqual((Object)pluginVersion, (Object)PropertiesComponent.getInstance((Project)project).getValue(SUPPRESSED_PROPERTY_NAME))) {
            return CollectionsKt.emptyList();
        }
        ArrayList outdatedLibraries = CollectionsKt.arrayListOf((Object[])new VersionedLibrary[0]);
        Iterator iterator2 = KotlinRuntimeLibraryUtilKt.findAllUsedLibraries(project).entrySet().iterator();
        while (iterator2.hasNext()) {
            String runtimeVersion;
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            Library library = (Library)entry2.getKey();
            Map.Entry entry3 = entry;
            Collection modules = (Collection)entry3.getValue();
            LibraryPresentationProvider libraryPresentationProvider = JavaRuntimePresentationProvider.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)libraryPresentationProvider, (String)"JavaRuntimePresentationProvider.getInstance()");
            Library library2 = library;
            Intrinsics.checkExpressionValueIsNotNull((Object)library2, (String)"library");
            LibraryVersionProperties libraryVersionProperties = (LibraryVersionProperties)KotlinLibraryUtilKt.getLibraryProperties(libraryPresentationProvider, library2);
            if (libraryVersionProperties == null) {
                LibraryPresentationProvider libraryPresentationProvider2 = JSLibraryStdPresentationProvider.getInstance();
                Intrinsics.checkExpressionValueIsNotNull((Object)libraryPresentationProvider2, (String)"JSLibraryStdPresentationProvider.getInstance()");
                Library library3 = library;
                Intrinsics.checkExpressionValueIsNotNull((Object)library3, (String)"library");
                libraryVersionProperties = (LibraryVersionProperties)KotlinLibraryUtilKt.getLibraryProperties(libraryPresentationProvider2, library3);
            }
            if (libraryVersionProperties == null) {
                continue;
            }
            LibraryVersionProperties libraryVersionProperties2 = libraryVersionProperties;
            String libraryVersion = libraryVersionProperties2.getVersionString();
            boolean isOutdated = OutdatedKotlinRuntimeCheckerKt.isRuntimeOutdated(libraryVersion, runtimeVersion = KotlinRuntimeLibraryUtilKt.bundledRuntimeVersion$default(null, 1, null));
            if (!isOutdated) continue;
            Library library4 = library;
            Intrinsics.checkExpressionValueIsNotNull((Object)library4, (String)"library");
            Collection collection = modules;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"modules");
            outdatedLibraries.add(new VersionedLibrary(library4, libraryVersion, collection));
        }
        return outdatedLibraries;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Module> collectModulesWithOutdatedRuntime(@NotNull List<VersionedLibrary> libraries) {
        void var3_3;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull(libraries, (String)"libraries");
        Iterable $receiver$iv = libraries;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            VersionedLibrary it = (VersionedLibrary)element$iv$iv;
            Iterable list$iv$iv = it.getUsedInModules();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)var3_3;
    }

    public static final void notifyOutdatedKotlinRuntime(@NotNull Project project, @NotNull Collection<VersionedLibrary> outdatedLibraries) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(outdatedLibraries, (String)"outdatedLibraries");
        String pluginVersion = KotlinPluginUtil.getPluginVersion();
        if (outdatedLibraries.size() == 1) {
            VersionedLibrary versionedLibrary = (VersionedLibrary)CollectionsKt.first((Iterable)outdatedLibraries);
            String version = versionedLibrary.getVersion();
            String string2 = version;
            if (string2 == null) {
                string2 = "unknown";
            }
            String readableVersion = string2;
            String libraryName = versionedLibrary.getLibrary().getName();
            string = "<p>Your version of Kotlin runtime in '" + libraryName + "' library is " + readableVersion + ", while plugin version is " + pluginVersion + ".</p>" + "<p>Runtime library should be updated to avoid compatibility problems.</p>" + "<p><a href=\"update\">Update Runtime</a> <a href=\"ignore\">Ignore</a></p>";
        } else {
            String libraryNames2 = CollectionsKt.joinToString$default((Iterable)outdatedLibraries, null, null, null, (int)0, null, (Function1)notifyOutdatedKotlinRuntime.message.libraryNames.1.INSTANCE, (int)31, null);
            string = "<p>Version of Kotlin runtime is outdated in several libraries (" + libraryNames2 + "). Plugin version is " + pluginVersion + ".</p>" + "<p>Runtime libraries should be updated to avoid compatibility problems.</p>" + "<p><a href=\"update\">Update All</a> <a href=\"ignore\">Ignore</a></p>";
        }
        String message2 = string;
        Notifications.Bus.notify((Notification)new Notification(OUTDATED_RUNTIME_GROUP_DISPLAY_ID, OUTDATED_RUNTIME_GROUP_DISPLAY_ID, message2, NotificationType.WARNING, new NotificationListener(project, pluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $pluginVersion;

            /*
             * WARNING - void declaration
             */
            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    if (Intrinsics.areEqual((Object)"update", (Object)event.getDescription())) {
                        void destination$iv$iv;
                        void $receiver$iv$iv;
                        void $receiver$iv;
                        Iterable iterable = OutdatedKotlinRuntimeCheckerKt.findOutdatedKotlinLibraries(this.$project);
                        void var5_4 = $receiver$iv;
                        Collection collection = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                        for (T item$iv$iv : $receiver$iv$iv) {
                            void it;
                            VersionedLibrary versionedLibrary = (VersionedLibrary)item$iv$iv;
                            void var13_9 = destination$iv$iv;
                            Library library = it.getLibrary();
                            var13_9.add(library);
                        }
                        List outdatedLibraries = (List)destination$iv$iv;
                        KotlinRuntimeLibraryUtilKt.updateLibraries(this.$project, outdatedLibraries);
                        OutdatedKotlinRuntimeCheckerKt.access$suggestDeleteKotlinJsIfNeeded(this.$project, outdatedLibraries);
                    } else if (Intrinsics.areEqual((Object)"ignore", (Object)event.getDescription())) {
                        PropertiesComponent.getInstance((Project)this.$project).setValue(OutdatedKotlinRuntimeCheckerKt.access$getSUPPRESSED_PROPERTY_NAME$p(), this.$pluginVersion);
                    } else {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    notification2.expire();
                }
            }
            {
                this.$project = project;
                this.$pluginVersion = string;
            }
        }), (Project)project);
    }

    public static final void deleteKotlinJs(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        ApplicationManager.getApplication().invokeLater(new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this){
                    final /* synthetic */ deleteKotlinJs.1 this$0;

                    public final void invoke() {
                        VirtualFile virtualFile2 = this.this$0.$project.getBaseDir().findFileByRelativePath("script/kotlin.js");
                        if (virtualFile2 == null) {
                            return;
                        }
                        VirtualFile kotlinJsFile = virtualFile2;
                        VirtualFile fileToDelete = PathUtil.getLocalFile((VirtualFile)kotlinJsFile);
                        try {
                            VirtualFile parent2 = fileToDelete.getParent();
                            fileToDelete.delete(null);
                            parent2.refresh(false, true);
                        }
                        catch (IOException ex) {
                            Notifications.Bus.notify((Notification)new Notification(OutdatedKotlinRuntimeCheckerKt.access$getOUTDATED_RUNTIME_GROUP_DISPLAY_ID$p(), "Error", "Could not delete 'script/kotlin.js': " + ex.getMessage(), NotificationType.ERROR));
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(0);
                    }
                });
            }
            {
                this.$project = project;
            }
        });
    }

    private static final void suggestDeleteKotlinJsIfNeeded(Project project, Collection<? extends Library> outdatedLibraries) {
        if (project.getBaseDir().findFileByRelativePath("script/kotlin.js") == null) {
            return;
        }
        boolean addNotification = false;
        for (Library library : outdatedLibraries) {
            Unit unit;
            LibraryPresentationProvider libraryPresentationProvider = JSLibraryStdPresentationProvider.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)libraryPresentationProvider, (String)"JSLibraryStdPresentationProvider.getInstance()");
            if (!KotlinLibraryUtilKt.isDetected(libraryPresentationProvider, library)) continue;
            VirtualFile jsStdlibJar = KotlinLibraryUtilKt.getJsStdLibJar(library);
            boolean bl = jsStdlibJar != null;
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "jslibFile should not be null";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            VirtualFile virtualFile2 = jsStdlibJar;
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
            if (virtualFile2.findFileByRelativePath("kotlin.js") != null) continue;
            addNotification = true;
            break;
        }
        if (!addNotification) {
            return;
        }
        String string = "<p>File 'script/kotlin.js' was probably created by an older version of the Kotlin plugin.</p><p>The new Kotlin plugin copies an up-to-date version of this file to the output directory automatically, so the old version of it can be deleted.</p><p><a href=\"delete\">Delete this file</a> <a href=\"ignore\">Ignore</a></p>";
        Notifications.Bus.notify((Notification)new Notification(OUTDATED_RUNTIME_GROUP_DISPLAY_ID, OUTDATED_RUNTIME_GROUP_DISPLAY_ID, string, NotificationType.WARNING, new NotificationListener(project){
            final /* synthetic */ Project $project;

            public final void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)notification2, (String)"notification");
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                    if (Intrinsics.areEqual((Object)"delete", (Object)event.getDescription())) {
                        OutdatedKotlinRuntimeCheckerKt.deleteKotlinJs(this.$project);
                    } else if (!Intrinsics.areEqual((Object)"ignore", (Object)event.getDescription())) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                    notification2.expire();
                }
            }
            {
                this.$project = project;
            }
        }), (Project)project);
    }

    public static final boolean isRuntimeOutdated(@Nullable String libraryVersion, @NotNull String runtimeVersion) {
        Intrinsics.checkParameterIsNotNull((Object)runtimeVersion, (String)"runtimeVersion");
        return libraryVersion == null || StringsKt.startsWith$default((String)libraryVersion, (String)"internal-", (boolean)false, (int)2, null) != StringsKt.startsWith$default((String)runtimeVersion, (String)"internal-", (boolean)false, (int)2, null) || VersionComparatorUtil.compare((String)StringsKt.substringBefore$default((String)runtimeVersion, (String)"-release-", null, (int)2, null), (String)libraryVersion) > 0;
    }

    static {
        SUPPRESSED_PROPERTY_NAME = SUPPRESSED_PROPERTY_NAME;
        OUTDATED_RUNTIME_GROUP_DISPLAY_ID = OUTDATED_RUNTIME_GROUP_DISPLAY_ID;
    }

    public static final /* synthetic */ void access$suggestDeleteKotlinJsIfNeeded(@NotNull Project project, @NotNull Collection outdatedLibraries) {
        OutdatedKotlinRuntimeCheckerKt.suggestDeleteKotlinJsIfNeeded(project, outdatedLibraries);
    }

    @NotNull
    public static final /* synthetic */ String access$getSUPPRESSED_PROPERTY_NAME$p() {
        return SUPPRESSED_PROPERTY_NAME;
    }

    @NotNull
    public static final /* synthetic */ String access$getOUTDATED_RUNTIME_GROUP_DISPLAY_ID$p() {
        return OUTDATED_RUNTIME_GROUP_DISPLAY_ID;
    }
}

