/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.CodeBuilder$WhenMappings;
import org.jetbrains.kotlin.j2k.DocCommentConverter;
import org.jetbrains.kotlin.j2k.ElementCreationStackTraceRequiredException;
import org.jetbrains.kotlin.j2k.ast.CommentsAndSpacesInheritance;
import org.jetbrains.kotlin.j2k.ast.Element;
import org.jetbrains.kotlin.j2k.ast.PrototypeInfo;
import org.jetbrains.kotlin.j2k.ast.SpacesInheritance;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u0003123B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0011J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u0017H\u0086\u0004J\u001a\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u00172\b\b\u0002\u0010\u001f\u001a\u00020\bH\u0002J\u0011\u0010\u001d\u001a\u00020\u00002\u0006\u0010 \u001a\u00020!H\u0086\u0004J\u001a\u0010\"\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00032\b\b\u0002\u0010#\u001a\u00020\u000eH\u0002J,\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00030%2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)H\u0002J&\u0010*\u001a\u00020+2\u0006\u0010 \u001a\u00020\u00032\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030)H\u0002J \u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030-*\b\u0012\u0004\u0012\u00020\u00030-2\u0006\u0010 \u001a\u00020\u0003H\u0002J \u0010.\u001a\b\u0012\u0004\u0012\u00020\u00030-*\b\u0012\u0004\u0012\u00020\u00030-2\u0006\u0010 \u001a\u00020\u0003H\u0002J \u0010/\u001a\b\u0012\u0004\u0012\u00020\u00030-*\b\u0012\u0004\u0012\u00020\u00030-2\u0006\u0010 \u001a\u00020\u0003H\u0002J \u00100\u001a\b\u0012\u0004\u0012\u00020\u00030-*\b\u0012\u0004\u0012\u00020\u00030-2\u0006\u0010 \u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder;", "", "topElement", "Lcom/intellij/psi/PsiElement;", "docConverter", "Lorg/jetbrains/kotlin/j2k/DocCommentConverter;", "(Lcom/intellij/psi/PsiElement;Lorg/jetbrains/kotlin/j2k/DocCommentConverter;)V", "NON_COMMENT_INFO", "Lorg/jetbrains/kotlin/j2k/CodeBuilder$CommentInfo;", "builder", "Ljava/lang/StringBuilder;", "commentsAndSpacesUsed", "Ljava/util/HashSet;", "endOfLineCommentAtEnd", "", "imports", "Ljava/util/LinkedHashSet;", "Lorg/jetbrains/kotlin/name/FqName;", "importsToAdd", "", "getImportsToAdd", "()Ljava/util/Set;", "resultText", "", "getResultText", "()Ljava/lang/String;", "addImport", "", "fqName", "append", "text", "commentInfo", "element", "Lorg/jetbrains/kotlin/j2k/ast/Element;", "appendCommentOrWhiteSpace", "postInsert", "collectPostfixElements", "", "inheritance", "Lorg/jetbrains/kotlin/j2k/ast/CommentsAndSpacesInheritance;", "notInsideElements", "", "collectPrefixElements", "Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "collectCommentsAndSpacesAfter", "", "collectCommentsAndSpacesAtEnd", "collectCommentsAndSpacesAtStart", "collectCommentsAndSpacesBefore", "CommentInfo", "Companion", "Prefix", "j2k"})
public final class CodeBuilder {
    private final StringBuilder builder;
    private boolean endOfLineCommentAtEnd;
    private final HashSet<PsiElement> commentsAndSpacesUsed;
    private final LinkedHashSet<FqName> imports;
    private final CommentInfo NON_COMMENT_INFO;
    private final PsiElement topElement;
    private DocCommentConverter docConverter;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final CodeBuilder append(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        return this.append(text2, this.NON_COMMENT_INFO);
    }

    public final void addImport(@NotNull FqName fqName2) {
        Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
        this.imports.add(fqName2);
    }

    private final void appendCommentOrWhiteSpace(PsiElement element2, boolean postInsert) {
        if (element2 instanceof PsiDocComment) {
            this.append(this.docConverter.convertDocComment((PsiDocComment)element2));
        } else {
            String string = element2.getText();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            this.append(string, new CommentInfo(element2, postInsert));
        }
    }

    static /* bridge */ /* synthetic */ void appendCommentOrWhiteSpace$default(CodeBuilder codeBuilder, PsiElement psiElement, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: appendCommentOrWhiteSpace");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        codeBuilder.appendCommentOrWhiteSpace(psiElement, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final CodeBuilder append(String text2, CommentInfo commentInfo) {
        Unit unit;
        CharSequence charSequence = text2;
        if (charSequence.length() == 0) {
            Unit unit2;
            boolean bl = !commentInfo.getEndOfLineComment();
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
            return this;
        }
        boolean bl = StringsKt.indexOf$default((CharSequence)text2, (char)'\r', (int)0, (boolean)false, (int)6, null) < 0;
        if (_Assertions.ENABLED) {
            if (!bl) {
                String string = "No '\\r' allowed";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        if (this.endOfLineCommentAtEnd) {
            if (text2.charAt(0) != '\n') {
                this.builder.append('\n');
            }
            this.endOfLineCommentAtEnd = false;
        }
        if (commentInfo.isComment()) {
            if (!commentInfo.isPostInsert() && commentInfo.isFirstNonWhitespaceElementInLine()) {
                CharSequence charSequence2;
                block16: {
                    CharSequence $receiver$iv = this.builder;
                    IntProgression intProgression = RangesKt.downTo((int)StringsKt.getLastIndex((CharSequence)$receiver$iv), (int)0);
                    int $i$a$1$assert = intProgression.getFirst();
                    int n = intProgression.getLast();
                    int n2 = intProgression.getStep();
                    int n3 = $i$a$1$assert;
                    int n4 = n;
                    if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
                        while (true) {
                            void index$iv;
                            char it;
                            if (!CharsKt.isWhitespace((char)(it = $receiver$iv.charAt((int)index$iv)))) {
                                charSequence2 = $receiver$iv.subSequence((int)(index$iv + true), $receiver$iv.length());
                                break block16;
                            }
                            if (index$iv == n) break;
                            index$iv += n2;
                        }
                    }
                    charSequence2 = $receiver$iv.subSequence(0, $receiver$iv.length());
                }
                if (!StringsKt.contains$default((CharSequence)charSequence2, (char)'\n', (boolean)false, (int)2, null)) {
                    this.builder.append('\n');
                }
            }
            if (!commentInfo.isCommentAtFirstColumn() && Intrinsics.areEqual((Object)StringsKt.lastOrNull((CharSequence)this.builder), (Object)Character.valueOf('\n'))) {
                this.builder.append(" ");
            }
        }
        this.builder.append(text2);
        this.endOfLineCommentAtEnd = commentInfo.getEndOfLineComment();
        return this;
    }

    static /* bridge */ /* synthetic */ CodeBuilder append$default(CodeBuilder codeBuilder, String string, CommentInfo commentInfo, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: append");
        }
        if ((n & 2) != 0) {
            commentInfo = codeBuilder.NON_COMMENT_INFO;
        }
        return codeBuilder.append(string, commentInfo);
    }

    @NotNull
    public final String getResultText() {
        String string = this.builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final Set<FqName> getImportsToAdd() {
        return this.imports;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CodeBuilder append(@NotNull Element element2) {
        PsiElement it;
        int n;
        int prototype22;
        int n2;
        CommentsAndSpacesInheritance inheritance;
        block22: {
            block21: {
                Intrinsics.checkParameterIsNotNull((Object)element2, (String)"element");
                if (element2.isEmpty()) {
                    return this;
                }
                if (element2.getPrototypes() == null && this.topElement != null) {
                    if (element2.getCreatedAt() == null) {
                        throw (Throwable)new ElementCreationStackTraceRequiredException();
                    }
                    String s = "Element " + element2 + " has no prototypes assigned." + "\n" + "Use Element.assignPrototype() or Element.assignNoPrototype().\n" + ("Element created at:" + "\n" + element2.getCreatedAt());
                    throw (Throwable)new RuntimeException(s);
                }
                if (this.topElement == null || this.topElement instanceof PsiCompiledElement) break block21;
                List<PrototypeInfo> list2 = element2.getPrototypes();
                if (list2 == null) {
                    Intrinsics.throwNpe();
                }
                if (!list2.isEmpty()) break block22;
            }
            element2.generateCode(this);
            element2.postGenerateCode(this);
            return this;
        }
        HashSet notInsideElements = new HashSet();
        Prefix prefix = Prefix.Companion.getEmpty();
        List<PsiElement> postfix = CollectionsKt.emptyList();
        List<PrototypeInfo> list3 = element2.getPrototypes();
        if (list3 == null) {
            Intrinsics.throwNpe();
        }
        for (PrototypeInfo prototypeInfo : list3) {
            Unit unit;
            Unit unit2;
            PsiElement prototype22 = prototypeInfo.component1();
            inheritance = prototypeInfo.component2();
            boolean bl = !(prototype22 instanceof PsiComment);
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit2 = Unit.INSTANCE;
            } else {
                unit2 = Unit.INSTANCE;
            }
            bl = !(prototype22 instanceof PsiWhiteSpace);
            if (_Assertions.ENABLED) {
                if (!bl) {
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            if (!PsiUtilsKt.isAncestor$default(this.topElement, prototype22, false, 2, null)) continue;
            prefix = prefix.plus(this.collectPrefixElements(prototype22, inheritance, notInsideElements));
            postfix = Companion.plus(postfix, this.collectPostfixElements(prototype22, inheritance, notInsideElements));
        }
        if (prefix.getLineBreaksBefore() > 0 && (n2 = 1) <= (prototype22 = (n = prefix.getLineBreaksBefore() - Companion.trailingLineBreakCount(this.builder)))) {
            while (true) {
                void it2;
                this.append("\n");
                if (it2 == prototype22) break;
                ++it2;
            }
        }
        Iterable iterable = prefix.getElements();
        for (PrototypeInfo element$iv : iterable) {
            it = (PsiElement)element$iv;
            CodeBuilder.appendCommentOrWhiteSpace$default(this, it, false, 2, null);
        }
        element2.generateCode(this);
        List<PrototypeInfo> list4 = element2.getPrototypes();
        if (list4 == null) {
            Intrinsics.throwNpe();
        }
        for (PrototypeInfo prototypeInfo : list4) {
            PsiElement prototype3 = prototypeInfo.component1();
            inheritance = prototypeInfo.component2();
            if (!inheritance.getCommentsInside()) continue;
            prototype3.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(this, notInsideElements){
                final /* synthetic */ CodeBuilder this$0;
                final /* synthetic */ HashSet $notInsideElements;

                public void visitComment(@NotNull PsiComment comment) {
                    Intrinsics.checkParameterIsNotNull((Object)comment, (String)"comment");
                    if (this.$notInsideElements.contains(comment) ^ true && CodeBuilder.access$getCommentsAndSpacesUsed$p(this.this$0).add(comment)) {
                        CodeBuilder.access$appendCommentOrWhiteSpace(this.this$0, (PsiElement)comment, true);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$notInsideElements = $captured_local_variable$1;
                }
            });
        }
        Iterable iterable2 = postfix;
        for (PrototypeInfo element$iv : iterable2) {
            it = (PsiElement)element$iv;
            CodeBuilder.appendCommentOrWhiteSpace$default(this, it, false, 2, null);
        }
        element2.postGenerateCode(this);
        return this;
    }

    private final Prefix collectPrefixElements(PsiElement element2, CommentsAndSpacesInheritance inheritance, Set<PsiElement> notInsideElements) {
        List<PsiElement> before = this.collectCommentsAndSpacesBefore((List)new SmartList(), element2);
        List<PsiElement> atStart = this.collectCommentsAndSpacesAtStart((List)new SmartList(), element2);
        notInsideElements.addAll((Collection<PsiElement>)atStart);
        if (Intrinsics.areEqual((Object)((Object)inheritance.getSpacesBefore()), (Object)((Object)SpacesInheritance.NONE)) && !inheritance.getCommentsBefore()) {
            return Prefix.Companion.getEmpty();
        }
        Object object = CollectionsKt.lastOrNull(before);
        if (!(object instanceof PsiWhiteSpace)) {
            object = null;
        }
        PsiWhiteSpace firstSpace = (PsiWhiteSpace)object;
        int lineBreaks = 0;
        if (firstSpace != null) {
            lineBreaks = Companion.lineBreakCount(firstSpace);
            switch (CodeBuilder$WhenMappings.$EnumSwitchMapping$0[inheritance.getSpacesBefore().ordinal()]) {
                case 1: {
                    lineBreaks = 0;
                    break;
                }
                case 2: {
                    this.commentsAndSpacesUsed.add((PsiElement)firstSpace);
                    break;
                }
                case 3: {
                    this.commentsAndSpacesUsed.add((PsiElement)firstSpace);
                    if (lineBreaks != 1) break;
                    lineBreaks = 0;
                }
            }
        }
        if (!inheritance.getCommentsBefore()) {
            return new Prefix(CollectionsKt.emptyList(), lineBreaks);
        }
        if (firstSpace != null) {
            before.remove(CollectionsKt.getLastIndex(before));
        }
        List<PsiElement> elements = Companion.plus(CollectionsKt.asReversedMutable(before), atStart);
        this.commentsAndSpacesUsed.addAll((Collection<PsiElement>)elements);
        return new Prefix(elements, lineBreaks);
    }

    private final List<PsiElement> collectPostfixElements(PsiElement element2, CommentsAndSpacesInheritance inheritance, Set<PsiElement> notInsideElements) {
        PsiElement last;
        List<PsiElement> atEnd = this.collectCommentsAndSpacesAtEnd((List)new SmartList(), element2);
        notInsideElements.addAll((Collection<PsiElement>)atEnd);
        if (!inheritance.getCommentsAfter()) {
            return CollectionsKt.emptyList();
        }
        List<PsiElement> after = this.collectCommentsAndSpacesAfter((List)new SmartList(), element2);
        Collection collection = after;
        if (!collection.isEmpty() && (last = (PsiElement)CollectionsKt.last(after)) instanceof PsiWhiteSpace) {
            after.remove(CollectionsKt.getLastIndex(after));
        }
        List<PsiElement> result2 = Companion.plus(CollectionsKt.asReversedMutable(atEnd), after);
        this.commentsAndSpacesUsed.addAll((Collection<PsiElement>)result2);
        return result2;
    }

    private final List<PsiElement> collectCommentsAndSpacesBefore(@NotNull List<PsiElement> $receiver, PsiElement element2) {
        if (Intrinsics.areEqual((Object)element2, (Object)this.topElement)) {
            return $receiver;
        }
        PsiElement prev2 = element2.getPrevSibling();
        if (prev2 != null) {
            if (Companion.isCommentOrSpace(prev2)) {
                if (this.commentsAndSpacesUsed.contains(prev2) ^ true) {
                    $receiver.add(prev2);
                    this.collectCommentsAndSpacesBefore($receiver, prev2);
                }
            } else if (Companion.isEmptyElement(prev2)) {
                this.collectCommentsAndSpacesBefore($receiver, prev2);
            }
        } else {
            PsiElement psiElement = element2.getParent();
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            this.collectCommentsAndSpacesBefore($receiver, psiElement);
        }
        return $receiver;
    }

    private final List<PsiElement> collectCommentsAndSpacesAfter(@NotNull List<PsiElement> $receiver, PsiElement element2) {
        if (Intrinsics.areEqual((Object)element2, (Object)this.topElement)) {
            return $receiver;
        }
        PsiElement next2 = element2.getNextSibling();
        if (next2 != null) {
            if (Companion.isCommentOrSpace(next2)) {
                if (next2 instanceof PsiWhiteSpace && Companion.hasLineBreaks((PsiWhiteSpace)next2)) {
                    return $receiver;
                }
                if (this.commentsAndSpacesUsed.contains(next2) ^ true) {
                    $receiver.add(next2);
                    this.collectCommentsAndSpacesAfter($receiver, next2);
                }
            } else if (Companion.isEmptyElement(next2)) {
                this.collectCommentsAndSpacesAfter($receiver, next2);
            }
        } else {
            PsiElement psiElement = element2.getParent();
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            this.collectCommentsAndSpacesAfter($receiver, psiElement);
        }
        return $receiver;
    }

    private final List<PsiElement> collectCommentsAndSpacesAtStart(@NotNull List<PsiElement> $receiver, PsiElement element2) {
        for (PsiElement child = element2.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (Companion.isCommentOrSpace(child)) {
                if (!(this.commentsAndSpacesUsed.contains(child) ^ true)) break;
                $receiver.add(child);
                continue;
            }
            if (Companion.isEmptyElement(child)) continue;
            this.collectCommentsAndSpacesAtStart($receiver, child);
            break;
        }
        return $receiver;
    }

    private final List<PsiElement> collectCommentsAndSpacesAtEnd(@NotNull List<PsiElement> $receiver, PsiElement element2) {
        for (PsiElement child = element2.getLastChild(); child != null; child = child.getPrevSibling()) {
            if (Companion.isCommentOrSpace(child)) {
                if (!(this.commentsAndSpacesUsed.contains(child) ^ true)) break;
                $receiver.add(child);
                continue;
            }
            if (Companion.isEmptyElement(child)) continue;
            this.collectCommentsAndSpacesAtEnd($receiver, child);
            break;
        }
        return $receiver;
    }

    public CodeBuilder(@Nullable PsiElement topElement, @NotNull DocCommentConverter docConverter) {
        Intrinsics.checkParameterIsNotNull((Object)docConverter, (String)"docConverter");
        this.topElement = topElement;
        this.docConverter = docConverter;
        this.builder = new StringBuilder();
        this.commentsAndSpacesUsed = new HashSet();
        this.imports = new LinkedHashSet();
        this.NON_COMMENT_INFO = new CommentInfo(null, false);
    }

    @NotNull
    public static final /* synthetic */ HashSet access$getCommentsAndSpacesUsed$p(CodeBuilder $this) {
        return $this.commentsAndSpacesUsed;
    }

    public static final /* synthetic */ void access$appendCommentOrWhiteSpace(CodeBuilder $this, @NotNull PsiElement element2, boolean postInsert) {
        $this.appendCommentOrWhiteSpace(element2, postInsert);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u000b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$CommentInfo;", "", "element", "Lcom/intellij/psi/PsiElement;", "isPostInsert", "", "(Lcom/intellij/psi/PsiElement;Z)V", "endOfLineComment", "getEndOfLineComment", "()Z", "isComment", "isCommentAtFirstColumn", "isFirstNonWhitespaceElementInLine", "j2k"})
    private static final class CommentInfo {
        private final boolean isComment;
        private final boolean endOfLineComment;
        private final boolean isCommentAtFirstColumn;
        private final boolean isFirstNonWhitespaceElementInLine;
        private final boolean isPostInsert;

        public final boolean isComment() {
            return this.isComment;
        }

        public final boolean getEndOfLineComment() {
            return this.endOfLineComment;
        }

        public final boolean isCommentAtFirstColumn() {
            return this.isCommentAtFirstColumn;
        }

        public final boolean isFirstNonWhitespaceElementInLine() {
            return this.isFirstNonWhitespaceElementInLine;
        }

        public final boolean isPostInsert() {
            return this.isPostInsert;
        }

        public CommentInfo(@Nullable PsiElement element2, boolean isPostInsert) {
            this.isPostInsert = isPostInsert;
            this.isComment = element2 instanceof PsiComment;
            PsiElement psiElement = element2;
            this.endOfLineComment = psiElement != null ? Companion.isEndOfLineComment(psiElement) : false;
            PsiElement psiElement2 = element2;
            this.isCommentAtFirstColumn = psiElement2 != null ? Companion.isCommentAtFirstColumn(psiElement2) : false;
            PsiElement psiElement3 = element2;
            this.isFirstNonWhitespaceElementInLine = psiElement3 != null ? Companion.isFirstNonWhitespaceElementInLine(psiElement3) : false;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0082\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "lineBreaksBefore", "", "(Ljava/util/List;I)V", "getElements", "()Ljava/util/List;", "getLineBreaksBefore", "()I", "component1", "component2", "copy", "isEmpty", "", "plus", "other", "Companion", "j2k"})
    private static final class Prefix {
        @NotNull
        private final List<PsiElement> elements;
        private final int lineBreaksBefore;
        @NotNull
        private static final Prefix Empty;
        public static final Companion Companion;

        @NotNull
        public final Prefix plus(@NotNull Prefix other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return this.isEmpty() ? other : (other.isEmpty() ? this : new Prefix(Companion.plus(this.elements, other.elements), Math.max(this.lineBreaksBefore, other.lineBreaksBefore)));
        }

        private final boolean isEmpty() {
            return this.elements.isEmpty() && this.lineBreaksBefore == 0;
        }

        @NotNull
        public final List<PsiElement> getElements() {
            return this.elements;
        }

        public final int getLineBreaksBefore() {
            return this.lineBreaksBefore;
        }

        public Prefix(@NotNull List<? extends PsiElement> elements, int lineBreaksBefore) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            this.elements = elements;
            this.lineBreaksBefore = lineBreaksBefore;
        }

        static {
            Companion = new Companion(null);
            Empty = new Prefix(CollectionsKt.emptyList(), 0);
        }

        @NotNull
        public final List<PsiElement> component1() {
            return this.elements;
        }

        public final int component2() {
            return this.lineBreaksBefore;
        }

        @NotNull
        public final Prefix copy(@NotNull List<? extends PsiElement> elements, int lineBreaksBefore) {
            Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
            return new Prefix(elements, lineBreaksBefore);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Prefix copy$default(Prefix prefix, List list2, int n, int n2, Object object) {
            if (object != null) {
                throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copy");
            }
            if ((n2 & 1) != 0) {
                list2 = prefix.elements;
            }
            if ((n2 & 2) != 0) {
                n = prefix.lineBreaksBefore;
            }
            return prefix.copy(list2, n);
        }

        public String toString() {
            return "Prefix(elements=" + this.elements + ", lineBreaksBefore=" + this.lineBreaksBefore + ")";
        }

        public int hashCode() {
            List<PsiElement> list2 = this.elements;
            return (list2 != null ? ((Object)list2).hashCode() : 0) * 31 + this.lineBreaksBefore;
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Prefix)) break block3;
                    Prefix prefix = (Prefix)object;
                    if (!Intrinsics.areEqual(this.elements, prefix.elements) || !(this.lineBreaksBefore == prefix.lineBreaksBefore)) break block3;
                }
                return true;
            }
            return false;
        }

        @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix$Companion;", "", "()V", "Empty", "Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "getEmpty", "()Lorg/jetbrains/kotlin/j2k/CodeBuilder$Prefix;", "j2k"})
        public static final class Companion {
            @NotNull
            public final Prefix getEmpty() {
                return Empty;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005J\n\u0010\u0006\u001a\u00020\u0004*\u00020\u0007J\n\u0010\b\u001a\u00020\u0004*\u00020\u0007J\n\u0010\t\u001a\u00020\u0004*\u00020\u0007J\n\u0010\n\u001a\u00020\u0004*\u00020\u0007J\n\u0010\u000b\u001a\u00020\u0004*\u00020\u0007J\n\u0010\f\u001a\u00020\r*\u00020\u0005J-\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000fH\u0086\u0002J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000f\"\u0004\b\u0000\u0010\u0010*\b\u0012\u0004\u0012\u0002H\u00100\u000fJ\n\u0010\u0013\u001a\u00020\r*\u00020\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/j2k/CodeBuilder$Companion;", "", "()V", "hasLineBreaks", "", "Lcom/intellij/psi/PsiWhiteSpace;", "isCommentAtFirstColumn", "Lcom/intellij/psi/PsiElement;", "isCommentOrSpace", "isEmptyElement", "isEndOfLineComment", "isFirstNonWhitespaceElementInLine", "lineBreakCount", "", "plus", "", "T", "other", "reversed", "trailingLineBreakCount", "", "j2k"})
    private static final class Companion {
        @NotNull
        public final <T> List<T> plus(@NotNull List<? extends T> $receiver, @NotNull List<? extends T> other) {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            Intrinsics.checkParameterIsNotNull(other, (String)"other");
            if ($receiver.isEmpty()) {
                return other;
            }
            if (other.isEmpty()) {
                return $receiver;
            }
            ArrayList result2 = new ArrayList($receiver.size() + other.size());
            result2.addAll($receiver);
            result2.addAll(other);
            return result2;
        }

        @NotNull
        public final <T> List<T> reversed(@NotNull List<? extends T> $receiver) {
            Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
            return $receiver.size() <= 1 ? $receiver : CollectionsKt.asReversed($receiver);
        }

        public final boolean isCommentOrSpace(@NotNull PsiElement $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver instanceof PsiComment || $receiver instanceof PsiWhiteSpace;
        }

        public final boolean isEndOfLineComment(@NotNull PsiElement $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver instanceof PsiComment && Intrinsics.areEqual((Object)((PsiComment)$receiver).getTokenType(), (Object)JavaTokenType.END_OF_LINE_COMMENT);
        }

        public final boolean isEmptyElement(@NotNull PsiElement $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return $receiver.getFirstChild() == null && $receiver.getTextLength() == 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isCommentAtFirstColumn(@NotNull PsiElement $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if (!($receiver instanceof PsiComment)) return false;
            PsiElement psiElement = ((PsiComment)$receiver).getPrevSibling();
            if (psiElement == null) return false;
            PsiElement psiElement2 = psiElement;
            PsiElement it = psiElement2;
            if (!(it instanceof PsiWhiteSpace)) return false;
            if (!StringsKt.endsWith$default((String)((PsiWhiteSpace)it).getText(), (String)"\\n", (boolean)false, (int)2, null)) return false;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isFirstNonWhitespaceElementInLine(@NotNull PsiElement $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if (!($receiver instanceof PsiComment)) return false;
            PsiElement psiElement = ((PsiComment)$receiver).getPrevSibling();
            if (psiElement == null) return false;
            PsiElement psiElement2 = psiElement;
            PsiElement it = psiElement2;
            if (!(it instanceof PsiWhiteSpace)) return false;
            if (!StringsKt.contains$default((CharSequence)((PsiWhiteSpace)it).getText(), (char)'\n', (boolean)false, (int)2, null)) return false;
            return true;
        }

        public final int lineBreakCount(@NotNull PsiWhiteSpace $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return StringUtil.getLineBreakCount((CharSequence)$receiver.getText());
        }

        public final boolean hasLineBreaks(@NotNull PsiWhiteSpace $receiver) {
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            return StringUtil.containsLineBreak((CharSequence)$receiver.getText());
        }

        public final int trailingLineBreakCount(@NotNull CharSequence $receiver) {
            int i;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            for (i = $receiver.length() - 1; i >= 0 && $receiver.charAt(i) == '\n'; --i) {
            }
            return $receiver.length() - i - 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

