/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.j2k;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.j2k.ConverterSettings;
import org.jetbrains.kotlin.j2k.EmptyJavaToKotlinServices;
import org.jetbrains.kotlin.j2k.JavaToKotlinConverter;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/j2k/JavaToKotlinTranslator;", "", "()V", "createFile", "Lcom/intellij/psi/PsiFile;", "text", "", "project", "Lcom/intellij/openapi/project/Project;", "generateKotlinCode", "javaCode", "prettify", "code", "j2k"})
public final class JavaToKotlinTranslator {
    public static final JavaToKotlinTranslator INSTANCE;

    private final PsiFile createFile(String text2, Project project) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText("test.java", (Language)JavaLanguage.INSTANCE, (CharSequence)text2);
    }

    @NotNull
    public final String prettify(@Nullable String code) {
        if (code == null) {
            return "";
        }
        CharSequence charSequence = code;
        String string = charSequence;
        if (string == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        charSequence = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (String)"\r\n", (String)"\n", (boolean)false, (int)4, null), (String)" \n", (String)"\n", (boolean)false, (int)4, null), (String)"\n ", (String)"\n", (boolean)false, (int)4, null);
        String string2 = "\n+";
        string2 = new Regex(string2);
        String string3 = "\n";
        charSequence = string2.replace(charSequence, string3);
        string2 = " +";
        string2 = new Regex(string2);
        string3 = " ";
        charSequence = string2.replace(charSequence, string3);
        CharSequence charSequence2 = charSequence;
        if (charSequence2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        return ((Object)StringsKt.trim((CharSequence)charSequence2)).toString();
    }

    @NotNull
    public final String generateKotlinCode(@NotNull String javaCode, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)javaCode, (String)"javaCode");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        PsiFile file = this.createFile(javaCode, project);
        if (file instanceof PsiJavaFile) {
            Project project2 = ((PsiJavaFile)file).getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"file.project");
            JavaToKotlinConverter converter = new JavaToKotlinConverter(project2, ConverterSettings.Companion.getDefaultSettings(), EmptyJavaToKotlinServices.INSTANCE);
            Object object = CollectionsKt.single(converter.elementsToKotlin(CollectionsKt.listOf((Object)file)).getResults());
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return this.prettify(((JavaToKotlinConverter.ElementResult)object).getText());
        }
        return "";
    }

    private JavaToKotlinTranslator() {
        INSTANCE = this;
    }

    static {
        new JavaToKotlinTranslator();
    }
}

