/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J \u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/PlatformStaticAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "checkDeclaration", "frontend.java"})
public final class PlatformStaticAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkParameterIsNotNull((Object)bindingContext2, (String)"bindingContext");
        if (org.jetbrains.kotlin.resolve.annotations.AnnotationUtilKt.hasJvmStaticAnnotation(descriptor2) && (declaration instanceof KtNamedFunction || declaration instanceof KtProperty || declaration instanceof KtPropertyAccessor || declaration instanceof KtParameter)) {
            this.checkDeclaration(declaration, descriptor2, diagnosticHolder);
        }
    }

    private final void checkDeclaration(KtDeclaration declaration, DeclarationDescriptor descriptor2, DiagnosticSink diagnosticHolder) {
        KtDeclaration checkDeclaration;
        KtDeclaration ktDeclaration;
        KtDeclaration ktDeclaration2;
        boolean insideCompanionObjectInClass;
        DeclarationDescriptor container2 = descriptor2.getContainingDeclaration();
        boolean insideObject = container2 != null && DescriptorUtils.isNonCompanionObject(container2);
        boolean bl = insideCompanionObjectInClass = container2 != null && DescriptorUtils.isCompanionObject(container2) && DescriptorUtils.isClassOrEnumClass(container2.getContainingDeclaration());
        if (!insideObject && !insideCompanionObjectInClass) {
            diagnosticHolder.report(ErrorsJvm.JVM_STATIC_NOT_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration)));
        }
        if ((ktDeclaration2 = declaration) instanceof KtPropertyAccessor) {
            PsiElement psiElement = declaration.getParent();
            if (psiElement == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtProperty");
            }
            ktDeclaration = (KtProperty)psiElement;
        } else {
            ktDeclaration = checkDeclaration = declaration;
        }
        if (insideObject) {
            KtModifierList ktModifierList = checkDeclaration.getModifierList();
            if (Intrinsics.areEqual((Object)(ktModifierList != null ? Boolean.valueOf(ktModifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD)) : null), (Object)true)) {
                diagnosticHolder.report(ErrorsJvm.OVERRIDE_CANNOT_BE_STATIC.on((KtDeclaration)((PsiElement)declaration)));
            }
        }
        if (descriptor2 instanceof PropertyDescriptor && (((PropertyDescriptor)descriptor2).isConst() || AnnotationUtilKt.hasJvmFieldAnnotation(descriptor2))) {
            diagnosticHolder.report(ErrorsJvm.JVM_STATIC_ON_CONST_OR_JVM_FIELD.on((KtDeclaration)((PsiElement)declaration)));
        }
    }
}

