/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageViewDescriptor;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.scopes.MemberScope;
import org.jetbrains.kotlin.serialization.deserialization.FindClassInModuleKt;
import org.jetbrains.kotlin.serialization.deserialization.NotFoundClasses;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"findClassAcrossModuleDependencies", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findNonGenericClassAcrossDependencies", "notFoundClasses", "Lorg/jetbrains/kotlin/serialization/deserialization/NotFoundClasses;", "deserialization"})
public final class FindClassInModuleKt {
    @Nullable
    public static final ClassDescriptor findClassAcrossModuleDependencies(@NotNull ModuleDescriptor $receiver, @NotNull ClassId classId) {
        ClassDescriptor topLevelClass;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"classId.packageFqName");
        PackageViewDescriptor packageViewDescriptor = $receiver.getPackage(fqName2);
        List<Name> segments = classId.getRelativeClassName().pathSegments();
        MemberScope memberScope2 = packageViewDescriptor.getMemberScope();
        Name name2 = (Name)CollectionsKt.first(segments);
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"segments.first()");
        ClassifierDescriptor classifierDescriptor = memberScope2.getContributedClassifier(name2, NoLookupLocation.FROM_DESERIALIZATION);
        if (!(classifierDescriptor instanceof ClassDescriptor)) {
            classifierDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)classifierDescriptor;
        if (classDescriptor == null) {
            return null;
        }
        ClassDescriptor result2 = topLevelClass = classDescriptor;
        for (Name name3 : segments.subList(1, segments.size())) {
            MemberScope memberScope3 = result2.getUnsubstitutedInnerClassesScope();
            Name name4 = name3;
            Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"name");
            ClassifierDescriptor classifierDescriptor2 = memberScope3.getContributedClassifier(name4, NoLookupLocation.FROM_DESERIALIZATION);
            if (!(classifierDescriptor2 instanceof ClassDescriptor)) {
                classifierDescriptor2 = null;
            }
            if ((ClassDescriptor)classifierDescriptor2 != null) continue;
            return null;
        }
        return result2;
    }

    @NotNull
    public static final ClassDescriptor findNonGenericClassAcrossDependencies(@NotNull ModuleDescriptor $receiver, @NotNull ClassId classId, @NotNull NotFoundClasses notFoundClasses) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)classId, (String)"classId");
        Intrinsics.checkParameterIsNotNull((Object)notFoundClasses, (String)"notFoundClasses");
        ClassDescriptor existingClass = FindClassInModuleKt.findClassAcrossModuleDependencies($receiver, classId);
        if (existingClass != null) {
            return existingClass;
        }
        List typeParametersCount2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)classId, (Function1)findNonGenericClassAcrossDependencies.typeParametersCount.1.INSTANCE), (Function1)findNonGenericClassAcrossDependencies.typeParametersCount.2.INSTANCE));
        ClassifierDescriptor classifierDescriptor = notFoundClasses.get(classId, typeParametersCount2).getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        return (ClassDescriptor)classifierDescriptor;
    }
}

