/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class InstanceOfExpr
extends Expr {
    final String mTypeStr;
    ModelClass mType;

    InstanceOfExpr(Expr left, String type) {
        super(left);
        this.mTypeStr = type;
    }

    @Override
    protected String computeUniqueKey() {
        return InstanceOfExpr.join("instanceof", super.computeUniqueKey(), this.mTypeStr);
    }

    @Override
    protected KCode generateCode(boolean expand) {
        return new KCode().app("", this.getExpr().toCode(expand)).app(" instanceof ").app(this.getType().toJavaCode());
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        this.mType = modelAnalyzer.findClass(this.mTypeStr, this.getModel().getImports());
        return modelAnalyzer.loadPrimitive("boolean");
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    public Expr getExpr() {
        return this.getChildren().get(0);
    }

    public ModelClass getType() {
        return this.mType;
    }

    @Override
    public String getInvertibleError() {
        return "two-way binding can't target a value with the 'instanceof' operator";
    }
}

