/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.ArrayTerminalDataStream;
import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.TtyConnector;
import java.awt.Dimension;
import java.io.IOException;

public class TtyChannel
extends ArrayTerminalDataStream {
    private TtyConnector myTtyConnector;

    public TtyChannel(TtyConnector ttyConnector) {
        super(new char[1024], 0, 0);
        this.myTtyConnector = ttyConnector;
    }

    private void fillBuf() throws IOException {
        this.myOffset = 0;
        this.myLength = this.myTtyConnector.read(this.myBuf, this.myOffset, this.myBuf.length);
        if (this.myLength <= 0) {
            this.myLength = 0;
            throw new TerminalDataStream.EOF();
        }
    }

    public char getChar() throws IOException {
        if (this.myLength == 0) {
            this.fillBuf();
        }
        return super.getChar();
    }

    public String readNonControlCharacters(int maxChars) throws IOException {
        if (this.myLength == 0) {
            this.fillBuf();
        }
        return super.readNonControlCharacters(maxChars);
    }

    public void sendBytes(byte[] bytes) throws IOException {
        this.myTtyConnector.write(bytes);
    }

    public void postResize(Dimension termSize, Dimension pixelSize) {
        this.myTtyConnector.resize(termSize, pixelSize);
    }

    public boolean isConnected() {
        return this.myTtyConnector.isConnected();
    }

    public void sendString(String string) throws IOException {
        this.myTtyConnector.write(string);
    }
}

