/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitReference;
import git4idea.commands.GitCommand;
import git4idea.commands.GitSimpleHandler;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitTag
extends GitReference {
    public static final String REFS_TAGS_PREFIX = "refs/tags/";

    public GitTag(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/GitTag", "<init>"));
        }
        super(name);
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = REFS_TAGS_PREFIX + this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitTag", "getFullName"));
        }
        return string;
    }

    @Deprecated
    public static void listAsStrings(Project project, VirtualFile root, Collection<String> tags, @Nullable String containingCommit) throws VcsException {
        GitSimpleHandler handler = new GitSimpleHandler(project, root, GitCommand.TAG);
        handler.setSilent(true);
        handler.addParameters("-l");
        if (containingCommit != null) {
            handler.addParameters("--contains");
            handler.addParameters(containingCommit);
        }
        for (String line : handler.run().split("\n")) {
            if (line.length() == 0) continue;
            tags.add(new String(line));
        }
    }

    @Deprecated
    public static void list(Project project, VirtualFile root, Collection<? super GitTag> tags) throws VcsException {
        ArrayList<String> temp = new ArrayList<String>();
        GitTag.listAsStrings(project, root, temp, null);
        for (String t : temp) {
            tags.add(new GitTag(t));
        }
    }
}

