/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.DialogManager;
import git4idea.GitCommit;
import git4idea.GitUtil;
import git4idea.branch.GitBranchIsNotFullyMergedDialog;
import git4idea.branch.GitBranchUiHandler;
import git4idea.branch.GitSmartOperationDialog;
import git4idea.commands.Git;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.ui.ChangesBrowserWithRollback;
import git4idea.util.GitSimplePathsBrowser;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitBranchUiHandlerImpl
implements GitBranchUiHandler {
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ProgressIndicator myProgressIndicator;

    public GitBranchUiHandlerImpl(@NotNull Project project, @NotNull Git git, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitBranchUiHandlerImpl", "<init>"));
        }
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/branch/GitBranchUiHandlerImpl", "<init>"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/branch/GitBranchUiHandlerImpl", "<init>"));
        }
        this.myProject = project;
        this.myGit = git;
        this.myProgressIndicator = indicator;
    }

    @Override
    public boolean notifyErrorWithRollbackProposal(final @NotNull String title, final @NotNull String message, final @NotNull String rollbackProposal) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/branch/GitBranchUiHandlerImpl", "notifyErrorWithRollbackProposal"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "git4idea/branch/GitBranchUiHandlerImpl", "notifyErrorWithRollbackProposal"));
        }
        if (rollbackProposal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rollbackProposal", "git4idea/branch/GitBranchUiHandlerImpl", "notifyErrorWithRollbackProposal"));
        }
        final AtomicBoolean ok = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                StringBuilder description = new StringBuilder();
                if (!StringUtil.isEmptyOrSpaces((String)message)) {
                    description.append(message).append("<br/>");
                }
                description.append(rollbackProposal);
                ok.set(0 == DialogManager.showOkCancelDialog(GitBranchUiHandlerImpl.this.myProject, XmlStringUtil.wrapInHtml((CharSequence)description), title, "Rollback", "Don't rollback", Messages.getErrorIcon()));
            }
        });
        return ok.get();
    }

    @Override
    public void showUnmergedFilesNotification(final @NotNull String operationName, final @NotNull Collection<GitRepository> repositories) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "git4idea/branch/GitBranchUiHandlerImpl", "showUnmergedFilesNotification"));
        }
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/branch/GitBranchUiHandlerImpl", "showUnmergedFilesNotification"));
        }
        String title = GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName);
        String description = GitBranchUiHandlerImpl.unmergedFilesErrorNotificationDescription(operationName);
        VcsNotifier.getInstance((Project)this.myProject).notifyError(title, description, new NotificationListener(){

            public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                if (notification == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "git4idea/branch/GitBranchUiHandlerImpl$2", "hyperlinkUpdate"));
                }
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "git4idea/branch/GitBranchUiHandlerImpl$2", "hyperlinkUpdate"));
                }
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event.getDescription().equals("resolve")) {
                    GitConflictResolver.Params params = new GitConflictResolver.Params().setMergeDescription(String.format("The following files have unresolved conflicts. You need to resolve them before %s.", operationName)).setErrorNotificationTitle("Unresolved files remain.");
                    new GitConflictResolver(GitBranchUiHandlerImpl.this.myProject, GitBranchUiHandlerImpl.this.myGit, GitUtil.getRootsFromRepositories(repositories), params).merge();
                }
            }
        });
    }

    @Override
    public boolean showUnmergedFilesMessageWithRollback(final @NotNull String operationName, final @NotNull String rollbackProposal) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "git4idea/branch/GitBranchUiHandlerImpl", "showUnmergedFilesMessageWithRollback"));
        }
        if (rollbackProposal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rollbackProposal", "git4idea/branch/GitBranchUiHandlerImpl", "showUnmergedFilesMessageWithRollback"));
        }
        final AtomicBoolean ok = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                String description = String.format("<html>You have to resolve all merge conflicts before %s.<br/>%s</html>", operationName, rollbackProposal);
                ok.set(0 == DialogManager.showOkCancelDialog(GitBranchUiHandlerImpl.this.myProject, description, GitBranchUiHandlerImpl.unmergedFilesErrorTitle(operationName), "Rollback", "Don't rollback", Messages.getErrorIcon()));
            }
        });
        return ok.get();
    }

    @Override
    public void showUntrackedFilesNotification(@NotNull String operationName, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesNotification"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesNotification"));
        }
        if (relativePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePaths", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesNotification"));
        }
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, root, relativePaths, operationName, null);
    }

    @Override
    public boolean showUntrackedFilesDialogWithRollback(@NotNull String operationName, @NotNull String rollbackProposal, @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesDialogWithRollback"));
        }
        if (rollbackProposal == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rollbackProposal", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesDialogWithRollback"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesDialogWithRollback"));
        }
        if (relativePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePaths", "git4idea/branch/GitBranchUiHandlerImpl", "showUntrackedFilesDialogWithRollback"));
        }
        return GitUntrackedFilesHelper.showUntrackedFilesDialogWithRollback(this.myProject, operationName, rollbackProposal, root, relativePaths);
    }

    @Override
    @NotNull
    public ProgressIndicator getProgressIndicator() {
        ProgressIndicator progressIndicator = this.myProgressIndicator;
        if (progressIndicator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUiHandlerImpl", "getProgressIndicator"));
        }
        return progressIndicator;
    }

    @Override
    public int showSmartOperationDialog(@NotNull Project project, @NotNull List<Change> changes, @NotNull Collection<String> paths, @NotNull String operation, @Nullable String forceButtonTitle) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitBranchUiHandlerImpl", "showSmartOperationDialog"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/branch/GitBranchUiHandlerImpl", "showSmartOperationDialog"));
        }
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "git4idea/branch/GitBranchUiHandlerImpl", "showSmartOperationDialog"));
        }
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "git4idea/branch/GitBranchUiHandlerImpl", "showSmartOperationDialog"));
        }
        Object fileBrowser = !changes.isEmpty() ? new ChangesBrowserWithRollback(project, changes) : new GitSimplePathsBrowser(project, paths);
        return GitSmartOperationDialog.showAndGetAnswer(this.myProject, (JComponent)fileBrowser, operation, forceButtonTitle);
    }

    @Override
    public boolean showBranchIsNotFullyMergedDialog(@NotNull Project project, final @NotNull Map<GitRepository, List<GitCommit>> history, final @NotNull String unmergedBranch, final @NotNull List<String> mergedToBranches, final @NotNull String baseBranch) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/branch/GitBranchUiHandlerImpl", "showBranchIsNotFullyMergedDialog"));
        }
        if (history == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "history", "git4idea/branch/GitBranchUiHandlerImpl", "showBranchIsNotFullyMergedDialog"));
        }
        if (unmergedBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unmergedBranch", "git4idea/branch/GitBranchUiHandlerImpl", "showBranchIsNotFullyMergedDialog"));
        }
        if (mergedToBranches == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedToBranches", "git4idea/branch/GitBranchUiHandlerImpl", "showBranchIsNotFullyMergedDialog"));
        }
        if (baseBranch == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranch", "git4idea/branch/GitBranchUiHandlerImpl", "showBranchIsNotFullyMergedDialog"));
        }
        final AtomicBoolean forceDelete = new AtomicBoolean();
        UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                forceDelete.set(GitBranchIsNotFullyMergedDialog.showAndGetAnswer(GitBranchUiHandlerImpl.this.myProject, history, unmergedBranch, mergedToBranches, baseBranch));
            }
        });
        return forceDelete.get();
    }

    @NotNull
    private static String unmergedFilesErrorTitle(@NotNull String operationName) {
        if (operationName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationName", "git4idea/branch/GitBranchUiHandlerImpl", "unmergedFilesErrorTitle"));
        }
        String string = "Can't " + operationName + " because of unmerged files";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUiHandlerImpl", "unmergedFilesErrorTitle"));
        }
        return string;
    }

    @NotNull
    private static String unmergedFilesErrorNotificationDescription(String operationName) {
        String string = "You have to <a href='resolve'>resolve</a> all merge conflicts before " + operationName + ".<br/>" + "After resolving conflicts you also probably would want to commit your files to the current branch.";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/branch/GitBranchUiHandlerImpl", "unmergedFilesErrorNotificationDescription"));
        }
        return string;
    }
}

