/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.components.ServiceManager;
import git4idea.commands.GitLineHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorMain;
import gnu.trove.THashMap;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.util.ScriptGenerator;
import org.jetbrains.ide.BuiltInServerManager;

public class GitRebaseEditorService {
    private String myEditorCommand;
    private final Object myScriptLock = new Object();
    private final Map<Integer, GitRebaseEditorHandler> myHandlers = new THashMap();
    private final Object myHandlersLock = new Object();
    private static final Random oursRandom = new SecureRandom();
    @NonNls
    private static final String GIT_REBASE_EDITOR_PREFIX = "git-rebase-editor-";

    @NotNull
    public static GitRebaseEditorService getInstance() {
        GitRebaseEditorService service = (GitRebaseEditorService)ServiceManager.getService(GitRebaseEditorService.class);
        if (service == null) {
            throw new IllegalStateException("The service " + GitRebaseEditorService.class.getName() + " cannot be located");
        }
        GitRebaseEditorService gitRebaseEditorService = service;
        if (gitRebaseEditorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseEditorService", "getInstance"));
        }
        return gitRebaseEditorService;
    }

    private void addInternalHandler() {
        XmlRpcServer xmlRpcServer = XmlRpcServer.SERVICE.getInstance();
        if (!xmlRpcServer.hasHandler("Git4ideaRebaseEditorHandler")) {
            xmlRpcServer.addHandler("Git4ideaRebaseEditorHandler", (Object)new InternalHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public synchronized String getEditorCommand() {
        Object object = this.myScriptLock;
        // MONITORENTER : object
        if (this.myEditorCommand == null) {
            ScriptGenerator generator = new ScriptGenerator(GIT_REBASE_EDITOR_PREFIX, GitRebaseEditorMain.class);
            generator.addInternal(Integer.toString(BuiltInServerManager.getInstance().getPort()));
            generator.addClasses(XmlRpcClientLite.class, DecoderException.class);
            this.myEditorCommand = generator.commandLine();
        }
        String string = this.myEditorCommand;
        // MONITOREXIT : object
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseEditorService", "getEditorCommand"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerHandler(GitRebaseEditorHandler handler) {
        this.addInternalHandler();
        Integer rc = null;
        Object object = this.myHandlersLock;
        synchronized (object) {
            for (int i = Integer.MAX_VALUE; i > 0; --i) {
                int code = Math.abs(oursRandom.nextInt());
                if (code <= 0 || this.myHandlers.containsKey(code)) continue;
                rc = code;
                break;
            }
            if (rc == null) {
                throw new IllegalStateException("There is a problem with random number allocation");
            }
            this.myHandlers.put(rc, handler);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(int handlerNo) {
        Object object = this.myHandlersLock;
        synchronized (object) {
            if (this.myHandlers.remove(handlerNo) == null) {
                throw new IllegalStateException("The handler " + handlerNo + " has been already removed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    GitRebaseEditorHandler getHandler(int handlerNo) {
        Object object = this.myHandlersLock;
        // MONITORENTER : object
        GitRebaseEditorHandler h = this.myHandlers.get(handlerNo);
        if (h == null) {
            throw new IllegalStateException("The handler " + handlerNo + " is not registered");
        }
        GitRebaseEditorHandler gitRebaseEditorHandler = h;
        // MONITOREXIT : object
        if (gitRebaseEditorHandler != null) return gitRebaseEditorHandler;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseEditorService", "getHandler"));
    }

    public void configureHandler(GitLineHandler h, int editorNo) {
        h.setEnvironment("GIT_EDITOR", this.getEditorCommand());
        h.setEnvironment("IDEA_REBASE_HANDER_NO", Integer.toString(editorNo));
    }

    public class InternalHandler {
        public int editCommits(int handlerNo, String path) {
            GitRebaseEditorHandler editor = GitRebaseEditorService.this.getHandler(handlerNo);
            return editor.editCommits(path);
        }
    }
}

