/*
 * Decompiled with CFR 0.152.
 */
package git4idea.reset;

import org.jetbrains.annotations.NotNull;

public enum GitResetMode {
    SOFT("Soft", "--soft", "Files won't change, differences will be staged for commit."),
    MIXED("Mixed", "--mixed", "Files won't change, differences won't be staged."),
    HARD("Hard", "--hard", "Files will be reverted to the state of the selected commit.<br/>Warning: any local changes will be lost."),
    KEEP("Keep", "--keep", "Files will be reverted to the state of the selected commit,<br/>but local changes will be kept intact.");

    @NotNull
    private final String myName;
    @NotNull
    private final String myArgument;
    @NotNull
    private final String myDescription;

    private GitResetMode(@NotNull String name, String argument, String description) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/reset/GitResetMode", "<init>"));
        }
        if (argument == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argument", "git4idea/reset/GitResetMode", "<init>"));
        }
        if (description == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "git4idea/reset/GitResetMode", "<init>"));
        }
        this.myName = name;
        this.myArgument = argument;
        this.myDescription = description;
    }

    @NotNull
    public static GitResetMode getDefault() {
        GitResetMode gitResetMode = MIXED;
        if (gitResetMode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitResetMode", "getDefault"));
        }
        return gitResetMode;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitResetMode", "getName"));
        }
        return string;
    }

    @NotNull
    public String getArgument() {
        String string = this.myArgument;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitResetMode", "getArgument"));
        }
        return string;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/reset/GitResetMode", "getDescription"));
        }
        return string;
    }
}

