/*
 * Decompiled with CFR 0.152.
 */
package git4idea.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import git4idea.GitCommit;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class GitCommitCompareInfo {
    private static final Logger LOG = Logger.getInstance(GitCommitCompareInfo.class);
    private final Map<GitRepository, Pair<List<GitCommit>, List<GitCommit>>> myInfo;
    private final Map<GitRepository, Collection<Change>> myTotalDiff;
    private final InfoType myInfoType;

    public GitCommitCompareInfo() {
        this(InfoType.BOTH);
    }

    public GitCommitCompareInfo(@NotNull InfoType infoType) {
        if (infoType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "infoType", "git4idea/util/GitCommitCompareInfo", "<init>"));
        }
        this.myInfo = new HashMap<GitRepository, Pair<List<GitCommit>, List<GitCommit>>>();
        this.myTotalDiff = new HashMap<GitRepository, Collection<Change>>();
        this.myInfoType = infoType;
    }

    public void put(@NotNull GitRepository repository, @NotNull Pair<List<GitCommit>, List<GitCommit>> commits) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/util/GitCommitCompareInfo", "put"));
        }
        if (commits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commits", "git4idea/util/GitCommitCompareInfo", "put"));
        }
        this.myInfo.put(repository, commits);
    }

    public void put(@NotNull GitRepository repository, @NotNull Collection<Change> totalDiff) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/util/GitCommitCompareInfo", "put"));
        }
        if (totalDiff == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "totalDiff", "git4idea/util/GitCommitCompareInfo", "put"));
        }
        this.myTotalDiff.put(repository, totalDiff);
    }

    @NotNull
    public List<GitCommit> getHeadToBranchCommits(@NotNull GitRepository repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "git4idea/util/GitCommitCompareInfo", "getHeadToBranchCommits"));
        }
        List list = (List)this.getCompareInfo(repo).getFirst();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitCommitCompareInfo", "getHeadToBranchCommits"));
        }
        return list;
    }

    @NotNull
    public List<GitCommit> getBranchToHeadCommits(@NotNull GitRepository repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "git4idea/util/GitCommitCompareInfo", "getBranchToHeadCommits"));
        }
        List list = (List)this.getCompareInfo(repo).getSecond();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitCommitCompareInfo", "getBranchToHeadCommits"));
        }
        return list;
    }

    @NotNull
    private Pair<List<GitCommit>, List<GitCommit>> getCompareInfo(@NotNull GitRepository repo) {
        if (repo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repo", "git4idea/util/GitCommitCompareInfo", "getCompareInfo"));
        }
        Pair<List<GitCommit>, List<GitCommit>> pair = this.myInfo.get(repo);
        if (pair == null) {
            LOG.error("Compare info not found for repository " + repo);
            Pair pair2 = Pair.create(Collections.emptyList(), Collections.emptyList());
            if (pair2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitCommitCompareInfo", "getCompareInfo"));
            }
            return pair2;
        }
        Pair<List<GitCommit>, List<GitCommit>> pair3 = pair;
        if (pair3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitCommitCompareInfo", "getCompareInfo"));
        }
        return pair3;
    }

    @NotNull
    public Collection<GitRepository> getRepositories() {
        Set<GitRepository> set = this.myInfo.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitCommitCompareInfo", "getRepositories"));
        }
        return set;
    }

    public boolean isEmpty() {
        return this.myInfo.isEmpty();
    }

    public InfoType getInfoType() {
        return this.myInfoType;
    }

    @NotNull
    public List<Change> getTotalDiff() {
        ArrayList<Change> changes = new ArrayList<Change>();
        for (Collection<Change> changeCollection : this.myTotalDiff.values()) {
            changes.addAll(changeCollection);
        }
        ArrayList<Change> arrayList = changes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/util/GitCommitCompareInfo", "getTotalDiff"));
        }
        return arrayList;
    }

    public static enum InfoType {
        BOTH,
        HEAD_TO_BRANCH,
        BRANCH_TO_HEAD;

    }
}

