/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.BC;

public class MessagePackReader {
    private GenericBinaryDocument doc;
    private boolean isHomo;
    private static final int POSITIVEFIXINT_x80 = 128;
    private static final int FIXMAP_xF0 = 128;
    private static final int FIXSTR_xE0 = 160;
    private static final int NEGATIVEFIXINT_xE0 = 224;
    private static final int DEFINITE_xE0 = 192;
    private static final int NIL = 192;
    private static final int FALSE = 194;
    private static final int TRUE = 195;
    private static final int BIN8 = 196;
    private static final int BIN16 = 197;
    private static final int BIN32 = 198;
    private static final int EXT8 = 199;
    private static final int EXT16 = 200;
    private static final int EXT32 = 201;
    private static final int FLOAT32 = 202;
    private static final int FLOAT64 = 203;
    private static final int UINT8 = 204;
    private static final int UINT16 = 205;
    private static final int UINT32 = 206;
    private static final int UINT64 = 207;
    private static final int INT8 = 208;
    private static final int INT16 = 209;
    private static final int INT32 = 210;
    private static final int INT64 = 211;
    private static final int FIXEXT1 = 212;
    private static final int FIXEXT2 = 213;
    private static final int FIXEXT4 = 214;
    private static final int FIXEXT8 = 215;
    private static final int FIXEXT16 = 216;
    private static final int STR8 = 217;
    private static final int STR16 = 218;
    private static final int STR32 = 219;
    private static final int ARRAY16 = 220;
    private static final int ARRAY32 = 221;
    private static final int MAP16 = 222;
    private static final int MAP32 = 223;

    public MessagePackReader(GenericBinaryDocument binaryDoc, boolean isHomogeneousArrays) {
        this.isHomo = isHomogeneousArrays;
        this.doc = binaryDoc;
    }

    public Map<String, Object> readMap() throws Exception {
        return (Map)this.getNext(null, 0);
    }

    public Object getNext(Object array, int pt) throws Exception {
        int b = this.doc.readByte() & 0xFF;
        int be0 = b & 0xE0;
        if ((b & 0x80) == 0) {
            if (array != null) {
                ((int[])array)[pt] = b;
                return null;
            }
            return b;
        }
        block0 : switch (be0) {
            case 224: {
                b = BC.intToSignedInt((int)(b | 0xFFFFFF00));
                if (array != null) {
                    ((int[])array)[pt] = b;
                    return null;
                }
                return b;
            }
            case 160: {
                String s = this.doc.readString(b & 0x1F);
                if (array != null) {
                    ((String[])array)[pt] = s;
                    return null;
                }
                return s;
            }
            case 128: {
                return (b & 0xF0) == 128 ? this.getMap(b & 0xF) : this.getArray(b & 0xF);
            }
            case 192: {
                switch (b) {
                    case 192: {
                        return null;
                    }
                    case 194: {
                        return Boolean.FALSE;
                    }
                    case 195: {
                        return Boolean.TRUE;
                    }
                    case 199: {
                        int n = this.doc.readUInt8();
                        return new Object[]{this.doc.readUInt8(), this.doc.readBytes(n)};
                    }
                    case 200: {
                        int n = this.doc.readUnsignedShort();
                        return new Object[]{this.doc.readUInt8(), this.doc.readBytes(n)};
                    }
                    case 201: {
                        int n = this.doc.readInt();
                        return new Object[]{this.doc.readUInt8(), this.doc.readBytes(n)};
                    }
                    case 212: {
                        return new Object[]{this.doc.readUInt8(), this.doc.readBytes(1)};
                    }
                    case 213: {
                        return new Object[]{this.doc.readUInt8(), this.doc.readBytes(2)};
                    }
                    case 214: {
                        return new Object[]{this.doc.readUInt8(), this.doc.readBytes(4)};
                    }
                    case 215: {
                        return new Object[]{this.doc.readUInt8(), this.doc.readBytes(8)};
                    }
                    case 216: {
                        return new Object[]{this.doc.readUInt8(), this.doc.readBytes(16)};
                    }
                    case 220: {
                        return this.getArray(this.doc.readUnsignedShort());
                    }
                    case 221: {
                        return this.getArray(this.doc.readInt());
                    }
                    case 222: {
                        return this.getMap(this.doc.readUnsignedShort());
                    }
                    case 223: {
                        return this.getMap(this.doc.readInt());
                    }
                    case 196: {
                        return this.doc.readBytes(this.doc.readUInt8());
                    }
                    case 197: {
                        return this.doc.readBytes(this.doc.readUnsignedShort());
                    }
                    case 198: {
                        return this.doc.readBytes(this.doc.readInt());
                    }
                }
                if (array == null) {
                    switch (b) {
                        case 202: {
                            return Float.valueOf(this.doc.readFloat());
                        }
                        case 203: {
                            return Float.valueOf((float)this.doc.readDouble());
                        }
                        case 204: {
                            return this.doc.readUInt8();
                        }
                        case 205: {
                            return this.doc.readUnsignedShort();
                        }
                        case 206: {
                            return this.doc.readInt();
                        }
                        case 207: {
                            return this.doc.readLong();
                        }
                        case 208: {
                            return (int)this.doc.readByte();
                        }
                        case 209: {
                            return (int)this.doc.readShort();
                        }
                        case 210: {
                            return this.doc.readInt();
                        }
                        case 211: {
                            return this.doc.readLong();
                        }
                        case 217: {
                            return this.doc.readString(this.doc.readUInt8());
                        }
                        case 218: {
                            return this.doc.readString((int)this.doc.readShort());
                        }
                        case 219: {
                            return this.doc.readString(this.doc.readInt());
                        }
                    }
                    break;
                }
                switch (b) {
                    case 202: {
                        ((float[])array)[pt] = this.doc.readFloat();
                        break block0;
                    }
                    case 203: {
                        ((float[])array)[pt] = (float)this.doc.readDouble();
                        break block0;
                    }
                    case 204: {
                        ((int[])array)[pt] = this.doc.readUInt8();
                        break block0;
                    }
                    case 205: {
                        ((int[])array)[pt] = this.doc.readUnsignedShort();
                        break block0;
                    }
                    case 206: {
                        ((int[])array)[pt] = this.doc.readInt();
                        break block0;
                    }
                    case 207: {
                        ((int[])array)[pt] = (int)this.doc.readLong();
                        break block0;
                    }
                    case 208: {
                        ((int[])array)[pt] = this.doc.readByte();
                        break block0;
                    }
                    case 209: {
                        ((int[])array)[pt] = this.doc.readShort();
                        break block0;
                    }
                    case 210: {
                        ((int[])array)[pt] = this.doc.readInt();
                        break block0;
                    }
                    case 211: {
                        ((int[])array)[pt] = (int)this.doc.readLong();
                        break block0;
                    }
                    case 217: {
                        ((String[])array)[pt] = this.doc.readString(this.doc.readUInt8());
                        break block0;
                    }
                    case 218: {
                        ((String[])array)[pt] = this.doc.readString((int)this.doc.readShort());
                        break block0;
                    }
                    case 219: {
                        ((String[])array)[pt] = this.doc.readString(this.doc.readInt());
                    }
                }
            }
        }
        return null;
    }

    private Object getArray(int n) throws Exception {
        if (this.isHomo) {
            Object[] a;
            if (n == 0) {
                return null;
            }
            Object v = this.getNext(null, 0);
            if (v instanceof Integer) {
                a = new int[n];
                a[0] = (Integer)v;
                v = a;
            } else if (v instanceof Float) {
                a = new float[n];
                a[0] = (int)((Float)v).floatValue();
                v = a;
            } else if (v instanceof String) {
                a = new String[n];
                a[0] = (int)((String)v);
                v = a;
            } else {
                Object[] o = new Object[n];
                o[0] = v;
                for (int i = 1; i < n; ++i) {
                    o[i] = this.getNext(null, 0);
                }
                return o;
            }
            for (int i = 1; i < n; ++i) {
                this.getNext(v, i);
            }
            return v;
        }
        Object[] o = new Object[n];
        for (int i = 0; i < n; ++i) {
            o[i] = this.getNext(null, 0);
        }
        return o;
    }

    private Object getMap(int n) throws Exception {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        for (int i = 0; i < n; ++i) {
            String key = this.getNext(null, 0).toString();
            Object value = this.getNext(null, 0);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }
}

