/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyModule(name={"GC"})
public class RubyGC {
    private static volatile boolean gcDisabled = false;
    private static volatile boolean stress = false;

    public static RubyModule createGCModule(Ruby runtime) {
        RubyModule result2 = runtime.defineModule("GC");
        runtime.setGC(result2);
        result2.defineAnnotatedMethods(RubyGC.class);
        return result2;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject start(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getNil();
    }

    @JRubyMethod
    public static IRubyObject garbage_collect(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getNil();
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject enable(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        RubyGC.emptyImplementationWarning(runtime, IRubyWarnings.ID.GC_ENABLE_UNIMPLEMENTED, "GC.enable");
        boolean old = gcDisabled;
        gcDisabled = false;
        return runtime.newBoolean(old);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject disable(ThreadContext context, IRubyObject recv2) {
        Ruby runtime = context.runtime;
        RubyGC.emptyImplementationWarning(runtime, IRubyWarnings.ID.GC_DISABLE_UNIMPLEMENTED, "GC.disable");
        boolean old = gcDisabled;
        gcDisabled = true;
        return runtime.newBoolean(old);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject stress(ThreadContext context, IRubyObject recv2) {
        return context.runtime.newBoolean(stress);
    }

    @JRubyMethod(name={"stress="}, module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject stress_set(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        RubyGC.emptyImplementationWarning(runtime, IRubyWarnings.ID.GC_STRESS_UNIMPLEMENTED, "GC.stress=");
        stress = arg2.isTrue();
        return runtime.newBoolean(stress);
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject count(ThreadContext context, IRubyObject recv2) {
        try {
            int count2 = RubyGC.getCollectionCount();
            return context.runtime.newFixnum(count2);
        }
        catch (Throwable t) {
            return RubyFixnum.minus_one(context.runtime);
        }
    }

    private static void emptyImplementationWarning(Ruby runtime, IRubyWarnings.ID id2, String name2) {
        runtime.getWarnings().warnOnce(id2, name2 + " does nothing on JRuby");
    }

    public static int getCollectionCount() {
        int count2 = 0;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            count2 = (int)((long)count2 + bean.getCollectionCount());
        }
        return count2;
    }

    public static long getCollectionTime() {
        long time = 0L;
        for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
            time += bean.getCollectionTime();
        }
        return time;
    }
}

