/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.ext.rbconfig.RbConfigLibrary;
import org.jruby.truffle.builtins.CoreClass;
import org.jruby.truffle.builtins.CoreMethod;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.builtins.YieldingCoreMethodNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.util.unsafe.UnsafeHolder;

@CoreClass(value="Truffle::System")
public abstract class TruffleSystemNodes {

    @CoreMethod(names={"full_memory_barrier"}, isModuleFunction=true)
    public static abstract class FullMemoryBarrierPrimitiveNode
    extends CoreMethodNode {
        @Specialization
        public Object fullMemoryBarrier() {
            if (!UnsafeHolder.SUPPORTS_FENCES) {
                throw new UnsupportedOperationException();
            }
            UnsafeHolder.fullFence();
            return this.nil();
        }
    }

    @CoreMethod(names={"synchronized"}, isModuleFunction=true, required=1, needsBlock=true)
    public static abstract class SynchronizedPrimitiveNode
    extends YieldingCoreMethodNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object synchronize(VirtualFrame frame, DynamicObject self, DynamicObject block) {
            DynamicObject dynamicObject = self;
            synchronized (dynamicObject) {
                return this.yield(frame, block, new Object[0]);
            }
        }
    }

    @CoreMethod(names={"host_os"}, onSingleton=true)
    public static abstract class HostOSNode
    extends CoreMethodNode {
        @Specialization
        public DynamicObject hostOS() {
            return this.createString(StringOperations.encodeRope(RbConfigLibrary.getOSName(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }

    @CoreMethod(names={"host_cpu"}, onSingleton=true)
    public static abstract class HostCPUNode
    extends CoreMethodNode {
        @Specialization
        public DynamicObject hostCPU() {
            return this.createString(StringOperations.encodeRope(RbConfigLibrary.getArchitecture(), (Encoding)UTF8Encoding.INSTANCE));
        }
    }
}

