/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.language.RubyGuards;

public abstract class StringCachingGuards {
    public static Rope privatizeRope(DynamicObject string) {
        if (RubyGuards.isRubyString(string)) {
            return StringOperations.rope(string);
        }
        return null;
    }

    public static boolean ropesEqual(DynamicObject string, Rope rope) {
        if (RubyGuards.isRubyString(string)) {
            Rope stringRope = StringOperations.rope(string);
            if (stringRope.getEncoding() != rope.getEncoding()) {
                return false;
            }
            return stringRope.equals(rope);
        }
        return false;
    }

    public static int ropeLength(Rope rope) {
        return rope.byteLength();
    }
}

