/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.elementnew.plot.parser;

import com.baselet.gui.AutocompletionText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PlotConstants {
    public static final String VALUE_LIST_SEPARATOR = ",";
    public static final String KEY_VALUE_SEP = "=";
    public static final String DEFAULT_VALUE = "auto";
    public static final String PLOT = "plot";
    public static final String DATA = "data";
    public static final String REGEX_COMMENT = "(//.*)";
    public static final String REGEX_KEY = "([(\\w)\\.]+)";
    public static final String REGEX_VALUE = "([-(\\w)#\\.,]*)";
    public static final String REGEX_VALUE_ASSIGNMENT = "(([(\\w)\\.]+)=([-(\\w)#\\.,]*))";
    public static final String REGEX_PLOT = "((plot ?)|(plot ((([(\\w)\\.]+)=([-(\\w)#\\.,]*)) )*(([(\\w)\\.]+)=([-(\\w)#\\.,]*))))";
    public static final String REGEX_PLOT_ADD = "(\\+((plot ?)|(plot ((([(\\w)\\.]+)=([-(\\w)#\\.,]*)) )*(([(\\w)\\.]+)=([-(\\w)#\\.,]*)))))";
    public static final String REGEX_DATA = "((data ?)|(data (\\w)+))";
    public static final String REGEX_DATA_SEPARATOR = "([\t ]+)";
    public static final String REGEX_DATA_GUESS = "((?!((//.*)))(([^=]+)|(.*([\t ]+).*)))";
    public static final String KEY_INT_GRID_WIDTH = "grid.width";
    public static final String GRID_WIDTH_DEFAULT = "3";
    public static final String KEY_BOOL_DATA_INVERT = "data.invert";
    public static final Boolean DATA_INVERT_DEFAULT = false;
    public static final String KEY_BOOL_PLOT_TILT = "tilt";
    public static final Boolean PLOT_TILT_DEFAULT = false;
    public static final String KEY_INT_X_POSITION = "pos.x";
    public static final String KEY_INT_Y_POSITION = "pos.y";
    public static final String KEY_INT_MIN_VALUE = "value.min";
    public static final String MIN_VALUE_ALL = "all";
    public static final String KEY_INT_MAX_VALUE = "value.max";
    public static final String MAX_VALUE_ALL = "all";
    public static final String KEY_LIST_COLORS = "colors";
    public static final List<String> COLORS_DEFAULT = Collections.unmodifiableList(Arrays.asList("red", "blue", "green", "orange", "cyan", "magenta", "pink"));
    public static final List<AutocompletionText> AUTOCOMPLETION_LIST = Collections.unmodifiableList(Arrays.asList(new AutocompletionText("plot", "draws the configured plot"), new AutocompletionText("data", "marks everything until the next empty line as dataset"), new AutocompletionText("data=<name>", "as data but with explicit name"), new AutocompletionText("grid.width=3", "sets the amount of plots per line"), new AutocompletionText("data.invert=" + DATA_INVERT_DEFAULT, "inverts the dataset"), new AutocompletionText("tilt=" + PLOT_TILT_DEFAULT, "tilts the plot"), new AutocompletionText("pos.x=<integer>", "places the next plot at specific horizontal grid position"), new AutocompletionText("pos.y=<integer>", "places the next plot at specific vertical grid position"), new AutocompletionText("value.min=all", "restrict the highest value shown in the plot"), new AutocompletionText("value.max=all", "restrict the lowest value shown in the plot"), new AutocompletionText("colors=" + COLORS_DEFAULT.get(0) + "," + COLORS_DEFAULT.get(1), "sets a list of colors which will be cycled by the plot"), new AutocompletionText(String.valueOf(PlotType.getKey()) + "=" + PlotType.Bar.getValue(), "sets the plot type to Bar plot"), new AutocompletionText(String.valueOf(PlotType.getKey()) + "=" + PlotType.Line.getValue(), "sets the plot type to Line plot"), new AutocompletionText(String.valueOf(PlotType.getKey()) + "=" + PlotType.Pie.getValue(), "sets the plot type to Pie plot"), new AutocompletionText(String.valueOf(PlotType.getKey()) + "=" + PlotType.Scatter.getValue(), "sets the plot type to Scatter plot"), new AutocompletionText(String.valueOf(AxisShow.getKeyValueAxis()) + AxisShow.getValueList(), "a list of elements to show at the value axis"), new AutocompletionText(String.valueOf(AxisShow.getKeyDescAxis()) + AxisShow.getValueList(), "a list of elements to show at the description axis"), new AutocompletionText(String.valueOf(AxisList.getKey()) + "=" + AxisList.Relevant.getValue(), "restricts shown values to occurring ones")));

    public static List<String> toStringList(PlotSetting[] input) {
        return PlotConstants.toStringList(Arrays.asList(input));
    }

    public static List<String> toStringList(List<? extends PlotSetting> input) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (PlotSetting plotSetting : input) {
            returnList.add(plotSetting.getValue());
        }
        return returnList;
    }

    public static enum AxisList implements PlotSetting
    {
        Relevant,
        Nothing("");

        private final String value;

        private AxisList() {
            this.value = this.toString().toLowerCase();
        }

        private AxisList(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static String getKey() {
            return "axis.value.list";
        }
    }

    public static enum AxisShow implements PlotSetting
    {
        Axis,
        Line,
        Marker,
        Text,
        Nothing("");

        private final String value;

        private AxisShow() {
            this.value = this.toString().toLowerCase();
        }

        public static String getValueList() {
            return PlotConstants.KEY_VALUE_SEP + Axis.getValue() + PlotConstants.VALUE_LIST_SEPARATOR + Line.getValue() + PlotConstants.VALUE_LIST_SEPARATOR + Marker.getValue() + PlotConstants.VALUE_LIST_SEPARATOR + Text.getValue();
        }

        private AxisShow(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public static String getKeyValueAxis() {
            return "axis.value.show";
        }

        public static String getKeyDescAxis() {
            return "axis.desc.show";
        }
    }

    public static interface PlotSetting {
        public String getValue();
    }

    public static enum PlotType implements PlotSetting
    {
        Bar,
        Line,
        Pie,
        Scatter;


        @Override
        public String getValue() {
            return this.toString().toLowerCase();
        }

        public static String getKey() {
            return "type";
        }
    }
}

