/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.fuzz.ui;

import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;
import org.owasp.jbrofuzz.fuzz.ui.TransformsRow;

public class TransformsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 8133287501650660903L;
    private static final String[] COLUMNNAMES = new String[]{"Encoder", "Prefix/Match", "Suffix/Replace"};
    private final ArrayList<TransformsRow> dataVector = new ArrayList();

    public void addRow(String encoding, String matchOrPrefix, String replaceOrSuffix) {
        this.addRow(new TransformsRow(encoding, matchOrPrefix, replaceOrSuffix));
    }

    public void addRow(TransformsRow row) {
        this.dataVector.add(row);
        this.dataVector.trimToSize();
        this.fireTableRowsInserted(this.dataVector.size(), this.dataVector.size());
    }

    @Override
    public int getColumnCount() {
        return COLUMNNAMES.length;
    }

    @Override
    public String getColumnName(int column) {
        return COLUMNNAMES[column];
    }

    public TransformsRow getRow(int row) {
        return this.dataVector.get(row);
    }

    @Override
    public int getRowCount() {
        return this.dataVector.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        TransformsRow record = this.dataVector.get(row);
        switch (column) {
            case 0: {
                return record.getEncoder();
            }
            case 1: {
                return record.getPrefixOrMatch();
            }
            case 2: {
                return record.getSuffixOrReplace();
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public void removeRow(int row) {
        if (row > -1 && row < this.dataVector.size()) {
            this.dataVector.remove(row);
            this.dataVector.trimToSize();
            this.fireTableDataChanged();
        }
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        TransformsRow record = this.dataVector.get(row);
        if (column == 0) {
            record.setEncoder((String)value);
        }
        if (column == 1) {
            record.setPrefixOrMatch((String)value);
        }
        if (column == 2) {
            record.setSuffixOrReplace((String)value);
        }
        this.fireTableCellUpdated(row, column);
    }

    public void moveRowUpOne(int row) {
        if (row >= 1) {
            TransformsRow rowToMove = this.dataVector.get(row);
            TransformsRow rowToReplace = this.dataVector.get(row - 1);
            this.dataVector.set(row - 1, rowToMove);
            this.dataVector.set(row, rowToReplace);
            this.fireTableDataChanged();
        }
    }

    public void moveRowUpAll(int row) {
        if (row >= 1) {
            TransformsRow rowToMove = this.dataVector.get(row);
            this.dataVector.remove(row);
            this.dataVector.add(0, rowToMove);
            this.fireTableDataChanged();
        }
    }

    public void moveRowDownOne(int row) {
        if (row != -1 && row < this.getRowCount()) {
            TransformsRow rowToMove = this.dataVector.get(row);
            TransformsRow rowToReplace = this.dataVector.get(row + 1);
            this.dataVector.set(row + 1, rowToMove);
            this.dataVector.set(row, rowToReplace);
            this.fireTableDataChanged();
        }
    }

    public void moveRowDownAll(int row) {
        if (row != -1 || row < this.getRowCount()) {
            TransformsRow rowToMove = this.dataVector.get(row);
            this.dataVector.remove(row);
            this.dataVector.add(this.dataVector.size(), rowToMove);
            this.fireTableDataChanged();
        }
    }
}

