/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.log4j.Logger;
import org.zaproxy.zap.network.ZapHttpParser;

public class GenericMethod
extends EntityEnclosingMethod {
    private static final Logger log = Logger.getLogger(GenericMethod.class);
    public static final String FORM_URL_ENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private Vector<NameValuePair> params = new Vector();
    private String method = null;

    public GenericMethod(String string) {
        this.method = string;
    }

    public GenericMethod(String string, String string2) {
        super(string2);
        this.method = string;
    }

    public String getName() {
        return this.method;
    }

    protected boolean hasRequestContent() {
        log.trace((Object)"enter GenericMethod.hasRequestContent()");
        if (!this.params.isEmpty()) {
            return true;
        }
        return super.hasRequestContent();
    }

    protected void clearRequestBody() {
        log.trace((Object)"enter GenericMethod.clearRequestBody()");
        this.params.clear();
        super.clearRequestBody();
    }

    protected RequestEntity generateRequestEntity() {
        if (!this.params.isEmpty()) {
            String string = EncodingUtil.formUrlEncode((NameValuePair[])this.getParameters(), (String)this.getRequestCharSet());
            ByteArrayRequestEntity byteArrayRequestEntity = new ByteArrayRequestEntity(EncodingUtil.getAsciiBytes((String)string), FORM_URL_ENCODED_CONTENT_TYPE);
            return byteArrayRequestEntity;
        }
        return super.generateRequestEntity();
    }

    public void setParameter(String string, String string2) {
        log.trace((Object)"enter PostMethod.setParameter(String, String)");
        this.removeParameter(string);
        this.addParameter(string, string2);
    }

    public NameValuePair getParameter(String string) {
        log.trace((Object)"enter PostMethod.getParameter(String)");
        if (string == null) {
            return null;
        }
        for (NameValuePair nameValuePair : this.params) {
            if (!string.equals(nameValuePair.getName())) continue;
            return nameValuePair;
        }
        return null;
    }

    public NameValuePair[] getParameters() {
        log.trace((Object)"enter PostMethod.getParameters()");
        int n = this.params.size();
        Object[] objectArray = this.params.toArray();
        NameValuePair[] nameValuePairArray = new NameValuePair[n];
        for (int i = 0; i < n; ++i) {
            nameValuePairArray[i] = (NameValuePair)objectArray[i];
        }
        return nameValuePairArray;
    }

    public void addParameter(String string, String string2) throws IllegalArgumentException {
        log.trace((Object)"enter PostMethod.addParameter(String, String)");
        if (string == null || string2 == null) {
            throw new IllegalArgumentException("Arguments to addParameter(String, String) cannot be null");
        }
        super.clearRequestBody();
        this.params.add(new NameValuePair(string, string2));
    }

    public void addParameter(NameValuePair nameValuePair) throws IllegalArgumentException {
        log.trace((Object)"enter PostMethod.addParameter(NameValuePair)");
        if (nameValuePair == null) {
            throw new IllegalArgumentException("NameValuePair may not be null");
        }
        this.addParameter(nameValuePair.getName(), nameValuePair.getValue());
    }

    public void addParameters(NameValuePair[] nameValuePairArray) {
        log.trace((Object)"enter PostMethod.addParameters(NameValuePair[])");
        if (nameValuePairArray == null) {
            log.warn((Object)"Attempt to addParameters(null) ignored");
        } else {
            super.clearRequestBody();
            for (int i = 0; i < nameValuePairArray.length; ++i) {
                this.params.add(nameValuePairArray[i]);
            }
        }
    }

    public boolean removeParameter(String string) throws IllegalArgumentException {
        log.trace((Object)"enter PostMethod.removeParameter(String)");
        if (string == null) {
            throw new IllegalArgumentException("Argument passed to removeParameter(String) cannot be null");
        }
        boolean bl = false;
        Iterator<NameValuePair> iterator = this.params.iterator();
        while (iterator.hasNext()) {
            NameValuePair nameValuePair = iterator.next();
            if (!string.equals(nameValuePair.getName())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public boolean removeParameter(String string, String string2) throws IllegalArgumentException {
        log.trace((Object)"enter PostMethod.removeParameter(String, String)");
        if (string == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Parameter value may not be null");
        }
        Iterator<NameValuePair> iterator = this.params.iterator();
        while (iterator.hasNext()) {
            NameValuePair nameValuePair = iterator.next();
            if (!string.equals(nameValuePair.getName()) || !string2.equals(nameValuePair.getValue())) continue;
            iterator.remove();
            return true;
        }
        return false;
    }

    public void setRequestBody(NameValuePair[] nameValuePairArray) throws IllegalArgumentException {
        log.trace((Object)"enter PostMethod.setRequestBody(NameValuePair[])");
        if (nameValuePairArray == null) {
            throw new IllegalArgumentException("Array of parameters may not be null");
        }
        this.clearRequestBody();
        this.addParameters(nameValuePairArray);
    }

    protected void readResponseHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        this.getResponseHeaderGroup().clear();
        Header[] headerArray = ZapHttpParser.parseHeaders(httpConnection.getResponseInputStream(), this.getParams().getHttpElementCharset());
        this.getResponseHeaderGroup().setHeaders(headerArray);
    }
}

