/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.termvectors.TermVectorsRequest;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParseFieldMatcher;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.query.BoostableQueryBuilder;
import org.elasticsearch.index.query.MoreLikeThisQueryParser;
import org.elasticsearch.index.query.QueryBuilder;

public class MoreLikeThisQueryBuilder
extends QueryBuilder
implements BoostableQueryBuilder<MoreLikeThisQueryBuilder> {
    private List<String> likeTexts = new ArrayList<String>();
    private List<String> unlikeTexts = new ArrayList<String>();
    private List<Item> likeItems = new ArrayList<Item>();
    private List<Item> unlikeItems = new ArrayList<Item>();
    private final String[] fields;
    private int maxQueryTerms = -1;
    private int minTermFreq = -1;
    private int minDocFreq = -1;
    private int maxDocFreq = -1;
    private int minWordLength = -1;
    private int maxWordLength = -1;
    private String[] stopWords = null;
    private String analyzer;
    private String minimumShouldMatch = null;
    private float boostTerms = -1.0f;
    private Boolean include = null;
    private Boolean failOnUnsupportedField;
    private float boost = -1.0f;
    private String queryName;

    public MoreLikeThisQueryBuilder() {
        this.fields = null;
    }

    public MoreLikeThisQueryBuilder(String ... fields) {
        this.fields = fields;
    }

    public MoreLikeThisQueryBuilder like(String ... likeTexts) {
        this.likeTexts = new ArrayList<String>();
        return this.addLikeText(likeTexts);
    }

    public MoreLikeThisQueryBuilder like(Item ... likeItems) {
        this.likeItems = new ArrayList<Item>();
        return this.addLikeItem(likeItems);
    }

    public MoreLikeThisQueryBuilder addLikeText(String ... likeTexts) {
        Collections.addAll(this.likeTexts, likeTexts);
        return this;
    }

    public MoreLikeThisQueryBuilder addLikeItem(Item ... likeItems) {
        Collections.addAll(this.likeItems, likeItems);
        return this;
    }

    public MoreLikeThisQueryBuilder unlike(String ... unlikeTexts) {
        this.unlikeTexts = new ArrayList<String>();
        return this.addUnlikeText(unlikeTexts);
    }

    public MoreLikeThisQueryBuilder unlike(Item ... unlikeItems) {
        this.unlikeItems = new ArrayList<Item>();
        return this.addUnlikeItem(unlikeItems);
    }

    public MoreLikeThisQueryBuilder addUnlikeText(String ... unlikeTexts) {
        Collections.addAll(this.unlikeTexts, unlikeTexts);
        return this;
    }

    public MoreLikeThisQueryBuilder addUnlikeItem(Item ... unlikeItems) {
        Collections.addAll(this.unlikeItems, unlikeItems);
        return this;
    }

    public MoreLikeThisQueryBuilder maxQueryTerms(int maxQueryTerms) {
        this.maxQueryTerms = maxQueryTerms;
        return this;
    }

    public MoreLikeThisQueryBuilder minTermFreq(int minTermFreq) {
        this.minTermFreq = minTermFreq;
        return this;
    }

    public MoreLikeThisQueryBuilder minDocFreq(int minDocFreq) {
        this.minDocFreq = minDocFreq;
        return this;
    }

    public MoreLikeThisQueryBuilder maxDocFreq(int maxDocFreq) {
        this.maxDocFreq = maxDocFreq;
        return this;
    }

    public MoreLikeThisQueryBuilder minWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
        return this;
    }

    public MoreLikeThisQueryBuilder maxWordLength(int maxWordLength) {
        this.maxWordLength = maxWordLength;
        return this;
    }

    public MoreLikeThisQueryBuilder stopWords(String ... stopWords) {
        this.stopWords = stopWords;
        return this;
    }

    public MoreLikeThisQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public MoreLikeThisQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public MoreLikeThisQueryBuilder boostTerms(float boostTerms) {
        this.boostTerms = boostTerms;
        return this;
    }

    public MoreLikeThisQueryBuilder include(boolean include) {
        this.include = include;
        return this;
    }

    public MoreLikeThisQueryBuilder failOnUnsupportedField(boolean fail) {
        this.failOnUnsupportedField = fail;
        return this;
    }

    @Override
    public MoreLikeThisQueryBuilder boost(float boost) {
        this.boost = boost;
        return this;
    }

    public MoreLikeThisQueryBuilder queryName(String queryName) {
        this.queryName = queryName;
        return this;
    }

    @Deprecated
    public MoreLikeThisQueryBuilder likeText(String likeText) {
        return this.like(likeText);
    }

    @Deprecated
    public MoreLikeThisQueryBuilder ids(String ... ids) {
        Item[] items = new Item[ids.length];
        for (int i = 0; i < items.length; ++i) {
            items[i] = new Item(null, null, ids[i]);
        }
        return this.like(items);
    }

    @Deprecated
    public MoreLikeThisQueryBuilder docs(Item ... docs) {
        return this.like(docs);
    }

    @Deprecated
    public MoreLikeThisQueryBuilder ignoreLike(Item ... docs) {
        return this.unlike(docs);
    }

    @Deprecated
    public MoreLikeThisQueryBuilder ignoreLike(String ... likeText) {
        return this.unlike(likeText);
    }

    @Deprecated
    public MoreLikeThisQueryBuilder addItem(Item ... likeItems) {
        return this.addLikeItem(likeItems);
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("mlt");
        if (this.fields != null) {
            builder.field(MoreLikeThisQueryParser.Field.FIELDS.getPreferredName(), this.fields);
        }
        if (this.likeTexts.isEmpty() && this.likeItems.isEmpty()) {
            throw new IllegalArgumentException("more_like_this requires '" + MoreLikeThisQueryParser.Field.LIKE.getPreferredName() + "' to be provided");
        }
        MoreLikeThisQueryBuilder.buildLikeField(builder, MoreLikeThisQueryParser.Field.LIKE.getPreferredName(), this.likeTexts, this.likeItems);
        if (!this.unlikeTexts.isEmpty() || !this.unlikeItems.isEmpty()) {
            MoreLikeThisQueryBuilder.buildLikeField(builder, MoreLikeThisQueryParser.Field.UNLIKE.getPreferredName(), this.unlikeTexts, this.unlikeItems);
        }
        if (this.maxQueryTerms != -1) {
            builder.field(MoreLikeThisQueryParser.Field.MAX_QUERY_TERMS.getPreferredName(), this.maxQueryTerms);
        }
        if (this.minTermFreq != -1) {
            builder.field(MoreLikeThisQueryParser.Field.MIN_TERM_FREQ.getPreferredName(), this.minTermFreq);
        }
        if (this.minDocFreq != -1) {
            builder.field(MoreLikeThisQueryParser.Field.MIN_DOC_FREQ.getPreferredName(), this.minDocFreq);
        }
        if (this.maxDocFreq != -1) {
            builder.field(MoreLikeThisQueryParser.Field.MAX_DOC_FREQ.getPreferredName(), this.maxDocFreq);
        }
        if (this.minWordLength != -1) {
            builder.field(MoreLikeThisQueryParser.Field.MIN_WORD_LENGTH.getPreferredName(), this.minWordLength);
        }
        if (this.maxWordLength != -1) {
            builder.field(MoreLikeThisQueryParser.Field.MAX_WORD_LENGTH.getPreferredName(), this.maxWordLength);
        }
        if (this.stopWords != null && this.stopWords.length > 0) {
            builder.field(MoreLikeThisQueryParser.Field.STOP_WORDS.getPreferredName(), this.stopWords);
        }
        if (this.analyzer != null) {
            builder.field(MoreLikeThisQueryParser.Field.ANALYZER.getPreferredName(), this.analyzer);
        }
        if (this.minimumShouldMatch != null) {
            builder.field(MoreLikeThisQueryParser.Field.MINIMUM_SHOULD_MATCH.getPreferredName(), this.minimumShouldMatch);
        }
        if (this.boostTerms != -1.0f) {
            builder.field(MoreLikeThisQueryParser.Field.BOOST_TERMS.getPreferredName(), this.boostTerms);
        }
        if (this.include != null) {
            builder.field(MoreLikeThisQueryParser.Field.INCLUDE.getPreferredName(), (Object)this.include);
        }
        if (this.failOnUnsupportedField != null) {
            builder.field(MoreLikeThisQueryParser.Field.FAIL_ON_UNSUPPORTED_FIELD.getPreferredName(), (Object)this.failOnUnsupportedField);
        }
        if (this.boost != -1.0f) {
            builder.field("boost", this.boost);
        }
        if (this.queryName != null) {
            builder.field("_name", this.queryName);
        }
        builder.endObject();
    }

    private static void buildLikeField(XContentBuilder builder, String fieldName, List<String> texts, List<Item> items) throws IOException {
        builder.startArray(fieldName);
        for (String text : texts) {
            builder.value(text);
        }
        for (Item item : items) {
            builder.value(item);
        }
        builder.endArray();
    }

    public static final class Item
    implements ToXContent {
        public static final Item[] EMPTY_ARRAY = new Item[0];
        private String index;
        private String type;
        private String id;
        private BytesReference doc;
        private String[] fields;
        private Map<String, String> perFieldAnalyzer;
        private String routing;
        private long version = -3L;
        private VersionType versionType = VersionType.INTERNAL;

        public Item() {
        }

        public Item(String index, @Nullable String type, String id) {
            this.index = index;
            this.type = type;
            this.id = id;
        }

        public Item(String index, String type, XContentBuilder doc) {
            this.index = index;
            this.type = type;
            this.doc(doc);
        }

        public String index() {
            return this.index;
        }

        public Item index(String index) {
            this.index = index;
            return this;
        }

        public String type() {
            return this.type;
        }

        public Item type(String type) {
            this.type = type;
            return this;
        }

        public String id() {
            return this.id;
        }

        public Item id(String id) {
            this.id = id;
            return this;
        }

        public BytesReference doc() {
            return this.doc;
        }

        public Item doc(BytesReference doc) {
            this.doc = doc;
            return this;
        }

        public Item doc(XContentBuilder doc) {
            return this.doc(doc.bytes());
        }

        public String[] fields() {
            return this.fields;
        }

        public Item fields(String ... fields) {
            this.fields = fields;
            return this;
        }

        public Map<String, String> perFieldAnalyzer() {
            return this.perFieldAnalyzer;
        }

        public Item perFieldAnalyzer(Map<String, String> perFieldAnalyzer) {
            this.perFieldAnalyzer = perFieldAnalyzer;
            return this;
        }

        public String routing() {
            return this.routing;
        }

        public Item routing(String routing) {
            this.routing = routing;
            return this;
        }

        public long version() {
            return this.version;
        }

        public Item version(long version) {
            this.version = version;
            return this;
        }

        public VersionType versionType() {
            return this.versionType;
        }

        public Item versionType(VersionType versionType) {
            this.versionType = versionType;
            return this;
        }

        public TermVectorsRequest toTermVectorsRequest() {
            TermVectorsRequest termVectorsRequest = new TermVectorsRequest(this.index, this.type, this.id).selectedFields(this.fields).routing(this.routing).version(this.version).versionType(this.versionType).perFieldAnalyzer(this.perFieldAnalyzer).positions(false).offsets(false).payloads(false).fieldStatistics(false).termStatistics(false).dfs(false);
            if (this.doc != null) {
                termVectorsRequest.doc(this.doc, true);
                this.id(termVectorsRequest.id());
            }
            return termVectorsRequest;
        }

        public static Item parse(XContentParser parser, ParseFieldMatcher parseFieldMatcher, Item item) throws IOException {
            XContentParser.Token token;
            String currentFieldName = null;
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (currentFieldName == null) continue;
                if (parseFieldMatcher.match(currentFieldName, Field.INDEX)) {
                    item.index = parser.text();
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Field.TYPE)) {
                    item.type = parser.text();
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Field.ID)) {
                    item.id = parser.text();
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Field.DOC)) {
                    item.doc(XContentFactory.jsonBuilder().copyCurrentStructure(parser));
                    continue;
                }
                if (parseFieldMatcher.match(currentFieldName, Field.FIELDS)) {
                    if (token == XContentParser.Token.START_ARRAY) {
                        ArrayList<String> fields = new ArrayList<String>();
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            fields.add(parser.text());
                        }
                        item.fields(fields.toArray(new String[fields.size()]));
                        continue;
                    }
                    throw new ElasticsearchParseException("failed to parse More Like This item. field [fields] must be an array", new Object[0]);
                }
                if (parseFieldMatcher.match(currentFieldName, Field.PER_FIELD_ANALYZER)) {
                    item.perFieldAnalyzer(TermVectorsRequest.readPerFieldAnalyzer(parser.map()));
                    continue;
                }
                if ("_routing".equals(currentFieldName) || "routing".equals(currentFieldName)) {
                    item.routing = parser.text();
                    continue;
                }
                if ("_version".equals(currentFieldName) || "version".equals(currentFieldName)) {
                    item.version = parser.longValue();
                    continue;
                }
                if ("_version_type".equals(currentFieldName) || "_versionType".equals(currentFieldName) || "version_type".equals(currentFieldName) || "versionType".equals(currentFieldName)) {
                    item.versionType = VersionType.fromString(parser.text());
                    continue;
                }
                throw new ElasticsearchParseException("failed to parse More Like This item. unknown field [{}]", currentFieldName);
            }
            if (item.id != null && item.doc != null) {
                throw new ElasticsearchParseException("failed to parse More Like This item. either [id] or [doc] can be specified, but not both!", new Object[0]);
            }
            return item;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.index != null) {
                builder.field(Field.INDEX.getPreferredName(), this.index);
            }
            if (this.type != null) {
                builder.field(Field.TYPE.getPreferredName(), this.type);
            }
            if (this.id != null && this.doc == null) {
                builder.field(Field.ID.getPreferredName(), this.id);
            }
            if (this.doc != null) {
                XContentType contentType = XContentFactory.xContentType(this.doc);
                if (contentType == builder.contentType()) {
                    builder.rawField(Field.DOC.getPreferredName(), this.doc);
                } else {
                    XContentParser parser = XContentFactory.xContent(contentType).createParser(this.doc);
                    parser.nextToken();
                    builder.field(Field.DOC.getPreferredName());
                    builder.copyCurrentStructure(parser);
                }
            }
            if (this.fields != null) {
                builder.array(Field.FIELDS.getPreferredName(), this.fields);
            }
            if (this.perFieldAnalyzer != null) {
                builder.field(Field.PER_FIELD_ANALYZER.getPreferredName(), (Object)this.perFieldAnalyzer);
            }
            if (this.routing != null) {
                builder.field(Field.ROUTING.getPreferredName(), this.routing);
            }
            if (this.version != -3L) {
                builder.field(Field.VERSION.getPreferredName(), this.version);
            }
            if (this.versionType != VersionType.INTERNAL) {
                builder.field(Field.VERSION_TYPE.getPreferredName(), this.versionType.toString().toLowerCase(Locale.ROOT));
            }
            return builder.endObject();
        }

        public final String toString() {
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.prettyPrint();
                this.toXContent(builder, EMPTY_PARAMS);
                return builder.string();
            }
            catch (Exception e) {
                return "{ \"error\" : \"" + ExceptionsHelper.detailedMessage(e) + "\"}";
            }
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.index, this.type, this.id, this.doc, Arrays.hashCode(this.fields), this.perFieldAnalyzer, this.routing, this.version, this.versionType});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Item)) {
                return false;
            }
            Item other = (Item)o;
            return Objects.equals(this.index, other.index) && Objects.equals(this.type, other.type) && Objects.equals(this.id, other.id) && Objects.equals(this.doc, other.doc) && Arrays.equals(this.fields, other.fields) && Objects.equals(this.perFieldAnalyzer, other.perFieldAnalyzer) && Objects.equals(this.routing, other.routing) && Objects.equals(this.version, other.version) && Objects.equals((Object)this.versionType, (Object)other.versionType);
        }

        public static interface Field {
            public static final ParseField INDEX = new ParseField("_index", new String[0]);
            public static final ParseField TYPE = new ParseField("_type", new String[0]);
            public static final ParseField ID = new ParseField("_id", new String[0]);
            public static final ParseField DOC = new ParseField("doc", new String[0]);
            public static final ParseField FIELDS = new ParseField("fields", new String[0]);
            public static final ParseField PER_FIELD_ANALYZER = new ParseField("per_field_analyzer", new String[0]);
            public static final ParseField ROUTING = new ParseField("_routing", new String[0]);
            public static final ParseField VERSION = new ParseField("_version", new String[0]);
            public static final ParseField VERSION_TYPE = new ParseField("_version_type", new String[0]);
        }
    }
}

