/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.translog;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.elasticsearch.common.io.Channels;
import org.elasticsearch.index.translog.ChannelReference;
import org.elasticsearch.index.translog.Checkpoint;
import org.elasticsearch.index.translog.TranslogReader;

public class ImmutableTranslogReader
extends TranslogReader {
    private final int totalOperations;
    protected final long length;

    public ImmutableTranslogReader(long generation, ChannelReference channelReference, long firstOperationOffset, long length, int totalOperations) {
        super(generation, channelReference, firstOperationOffset);
        this.length = length;
        this.totalOperations = totalOperations;
    }

    public final TranslogReader clone() {
        if (this.channelReference.tryIncRef()) {
            try {
                ImmutableTranslogReader reader = this.newReader(this.generation, this.channelReference, this.firstOperationOffset, this.length, this.totalOperations);
                this.channelReference.incRef();
                ImmutableTranslogReader immutableTranslogReader = reader;
                return immutableTranslogReader;
            }
            finally {
                this.channelReference.decRef();
            }
        }
        throw new IllegalStateException("can't increment translog [" + this.generation + "] channel ref count");
    }

    protected ImmutableTranslogReader newReader(long generation, ChannelReference channelReference, long offset, long length, int totalOperations) {
        return new ImmutableTranslogReader(generation, channelReference, offset, length, totalOperations);
    }

    @Override
    public long sizeInBytes() {
        return this.length;
    }

    @Override
    public int totalOperations() {
        return this.totalOperations;
    }

    @Override
    protected void readBytes(ByteBuffer buffer, long position) throws IOException {
        if (position >= this.length) {
            throw new EOFException("read requested past EOF. pos [" + position + "] end: [" + this.length + "]");
        }
        if (position < this.firstOperationOffset) {
            throw new IOException("read requested before position of first ops. pos [" + position + "] first op on: [" + this.firstOperationOffset + "]");
        }
        Channels.readFromFileChannelWithEofException(this.channel, position, buffer);
    }

    public Checkpoint getInfo() {
        return new Checkpoint(this.length, this.totalOperations, this.getGeneration());
    }
}

