/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import org.elasticsearch.action.admin.cluster.node.tasks.list.TaskInfo;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.tasks.TaskId;

public class Task {
    private final long id;
    private final String type;
    private final String action;
    private final String description;
    private final TaskId parentTask;
    private final long startTime;
    private final long startTimeNanos;

    public Task(long id, String type, String action, String description) {
        this(id, type, action, description, TaskId.EMPTY_TASK_ID);
    }

    public Task(long id, String type, String action, String description, TaskId parentTask) {
        this(id, type, action, description, parentTask, System.currentTimeMillis(), System.nanoTime());
    }

    public Task(long id, String type, String action, String description, TaskId parentTask, long startTime, long startTimeNanos) {
        this.id = id;
        this.type = type;
        this.action = action;
        this.description = description;
        this.parentTask = parentTask;
        this.startTime = startTime;
        this.startTimeNanos = startTimeNanos;
    }

    public TaskInfo taskInfo(DiscoveryNode node, boolean detailed) {
        String description = null;
        Status status = null;
        if (detailed) {
            description = this.getDescription();
            status = this.getStatus();
        }
        return new TaskInfo(node, this.getId(), this.getType(), this.getAction(), description, status, this.startTime, System.nanoTime() - this.startTimeNanos, this.parentTask);
    }

    public long getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getAction() {
        return this.action;
    }

    public String getDescription() {
        return this.description;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public TaskId getParentTaskId() {
        return this.parentTask;
    }

    public Status getStatus() {
        return null;
    }

    public static interface Status
    extends ToXContent,
    NamedWriteable<Status> {
    }
}

