#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: dbus
version: 0.10.12
id: dbus-0.10.12-4KcrgRWGGQj466WNHaVgvW
key: dbus-0.10.12-4KcrgRWGGQj466WNHaVgvW
license: GPL-3
maintainer: John Millikin <john@john-millikin.com>
stability: experimental
homepage: https://john-millikin.com/software/haskell-dbus/
synopsis: A client library for the D-Bus IPC system.
description:
    D-Bus is a simple, message-based protocol for inter-process
    communication, which allows applications to interact with other parts of
    the machine and the user'\''s session using remote procedure calls.
    .
    D-Bus is a essential part of the modern Linux desktop, where it replaces
    earlier protocols such as CORBA and DCOP.
    .
    This library is an implementation of the D-Bus protocol in Haskell. It
    can be used to add D-Bus support to Haskell applications, without the
    awkward interfaces common to foreign bindings.
    .
    Example: connect to the session bus, and get a list of active names.
    .
    @
    &#x7b;-\# LANGUAGE OverloadedStrings \#-&#x7d;
    .
    import Data.List (sort)
    import DBus
    import DBus.Client
    .
    main = do
    &#x20;   client <- connectSession
    &#x20;   //
    &#x20;   \-- Request a list of connected clients from the bus
    &#x20;   reply <- call_ client (methodCall \"\/org\/freedesktop\/DBus\" \"org.freedesktop.DBus\" \"ListNames\")
    &#x20;       &#x7b; methodCallDestination = Just \"org.freedesktop.DBus\"
    &#x20;       &#x7d;
    &#x20;   //
    &#x20;   \-- org.freedesktop.DBus.ListNames() returns a single value, which is
    &#x20;   \-- a list of names (here represented as [String])
    &#x20;   let Just names = fromVariant (methodReturnBody reply !! 0)
    &#x20;   //
    &#x20;   \-- Print each name on a line, sorted so reserved names are below
    &#x20;   \-- temporary names.
    &#x20;   mapM_ putStrLn (sort names)
    @
    .
    >$ ghc --make list-names.hs
    >$ ./list-names
    >:1.0
    >:1.1
    >:1.10
    >:1.106
    >:1.109
    >:1.110
    >ca.desrt.dconf
    >org.freedesktop.DBus
    >org.freedesktop.Notifications
    >org.freedesktop.secrets
    >org.gnome.ScreenSaver
category: Network, Desktop
author: John Millikin <john@john-millikin.com>
exposed: True
exposed-modules:
    DBus DBus.Client DBus.Introspection DBus.Socket DBus.Transport
hidden-modules: DBus.Address DBus.Message DBus.Types DBus.Wire
abi: 8f27941737be140942254f5bd34db2d4
trusted: False
import-dirs: /usr/lib/ghc-8.0.1/site-local/dbus-0.10.12
library-dirs: /usr/lib/ghc-8.0.1/site-local/dbus-0.10.12
data-dir: /usr/share/arm-linux-ghc-8.0.1/dbus-0.10.12
hs-libraries: HSdbus-0.10.12-4KcrgRWGGQj466WNHaVgvW
depends:
    base-4.9.0.0 bytestring-0.10.8.1
    cereal-0.5.3.0-JHJQkHEuvBGFx8XwIB7eX0 containers-0.5.7.1
    libxml-sax-0.7.5-CtJUDI4WTPP2DP64axVp1V
    network-2.6.2.1-Li0aefQhyJzUSpQ0fLiXL
    parsec-3.1.11-IYEP8Lv1S9x5FeUQxGPDBY
    random-1.1-54KmMHXjttlERYcr1mvsAe
    text-1.2.2.1-FgcR4Xf0VlEHD9HLxzq9WJ transformers-0.5.2.0
    unix-2.7.2.0 vector-0.11.0.0-BEDZb5o2QOhGbIm6ky7rl6
    xml-types-0.3.6-KjWhtX04gsiBko21cGwOxT
haddock-interfaces: /usr/share/doc/haskell-dbus/html/dbus.haddock
haddock-html: /usr/share/doc/haskell-dbus/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"
