/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Logger;

public abstract class ProteinStructure
implements Structure {
    STR type;
    STR subtype;
    String structureID;
    int strucNo;
    int serialID;
    int strandCount = 1;
    public int nRes;
    protected AlphaPolymer apolymer;
    protected int monomerIndexFirst;
    int monomerIndexLast;
    protected P3 axisA;
    protected P3 axisB;
    protected V3 axisUnitVector;
    protected V3 vectorProjection;
    private static int globalStrucNo = 1000;
    private P3[] segments;
    private Map<Monomer, Integer> resMap;

    protected void setupPS(AlphaPolymer apolymer, STR type, int monomerIndex, int monomerCount) {
        this.strucNo = ++globalStrucNo;
        this.apolymer = apolymer;
        this.type = type;
        this.vectorProjection = new V3();
        this.monomerIndexFirst = monomerIndex;
        this.addMonomer(monomerIndex + monomerCount - 1);
        if (Logger.debugging) {
            Logger.info((String)("Creating ProteinStructure " + this.strucNo + " " + type.getBioStructureTypeName(false) + " from " + this.monomerIndexFirst + " through " + this.monomerIndexLast + " in polymer " + apolymer));
        }
    }

    void addMonomer(int index) {
        this.resMap = null;
        this.resetAxes();
        this.monomerIndexFirst = Math.min(this.monomerIndexFirst, index);
        this.monomerIndexLast = Math.max(this.monomerIndexLast, index);
        this.nRes = this.monomerIndexLast - this.monomerIndexFirst + 1;
    }

    void removeMonomer(int index) {
        this.resMap = null;
        this.resetAxes();
        if (index > this.monomerIndexLast || index < this.monomerIndexFirst) {
            return;
        }
        if (index == this.monomerIndexFirst) {
            ++this.monomerIndexFirst;
            --this.nRes;
        } else if (index == this.monomerIndexLast) {
            --this.monomerIndexLast;
            --this.nRes;
        } else {
            int n = this.monomerIndexLast - index;
            this.monomerIndexLast = index - 1;
            this.nRes = index - this.monomerIndexFirst;
            Monomer[] monomers = this.apolymer.monomers;
            STR type = monomers[++index].getProteinStructureType();
            int mLast = -1;
            int i = 0;
            int pt = index;
            while (i < n) {
                ((AlphaMonomer)monomers[pt]).setStructure(null);
                mLast = monomers[pt].setProteinStructureType(type, mLast);
                ++i;
                ++pt;
            }
        }
    }

    public void calcAxis() {
    }

    public boolean isWithin(int monomerIndex) {
        return monomerIndex > this.monomerIndexFirst && monomerIndex < this.monomerIndexLast;
    }

    public int getIndex(Monomer monomer) {
        Integer ii;
        if (this.resMap == null) {
            this.resMap = new Hashtable<Monomer, Integer>();
            int i = this.nRes;
            while (--i >= 0) {
                this.resMap.put(this.apolymer.monomers[this.monomerIndexFirst + i], i);
            }
        }
        return (ii = this.resMap.get((Object)monomer)) == null ? -1 : ii;
    }

    public P3[] getSegments() {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments;
    }

    P3 getStructureMidPoint(int index) {
        if (this.segments == null) {
            this.calcSegments();
        }
        return this.segments[index];
    }

    private void calcSegments() {
        if (this.segments != null) {
            return;
        }
        this.calcAxis();
        this.segments = new P3[this.nRes + 1];
        this.segments[this.nRes] = this.axisB;
        this.segments[0] = this.axisA;
        V3 axis = V3.newV((T3)this.axisUnitVector);
        axis.scale(this.axisB.distance((T3)this.axisA) / (float)this.nRes);
        for (int i = 1; i < this.nRes; ++i) {
            P3 point = this.segments[i] = new P3();
            point.add2((T3)this.segments[i - 1], (T3)axis);
        }
    }

    public P3 getAxisStartPoint() {
        this.calcAxis();
        return this.axisA;
    }

    public P3 getAxisEndPoint() {
        this.calcAxis();
        return this.axisB;
    }

    void resetAxes() {
        this.axisA = null;
        this.segments = null;
    }

    public void setAtomBits(BS bs) {
        Monomer[] ms = this.apolymer.monomers;
        for (int i = this.monomerIndexFirst; i <= this.monomerIndexLast; ++i) {
            ms[i].setAtomBits(bs);
        }
    }

    public void setAtomBitsAndClear(BS bs, BS bsOut) {
        Monomer[] ms = this.apolymer.monomers;
        for (int i = this.monomerIndexFirst; i <= this.monomerIndexLast; ++i) {
            ms[i].setAtomBitsAndClear(bs, bsOut);
        }
    }

    public Monomer findMonomer(BS bsAtoms, boolean isFirst) {
        Monomer[] ms = this.apolymer.monomers;
        if (isFirst) {
            for (int i = this.monomerIndexFirst; i <= this.monomerIndexLast; ++i) {
                if (bsAtoms != null && !bsAtoms.get(ms[i].leadAtomIndex)) continue;
                return ms[i];
            }
        } else {
            for (int i = this.monomerIndexLast; i >= this.monomerIndexFirst; --i) {
                if (bsAtoms != null && !bsAtoms.get(ms[i].leadAtomIndex)) continue;
                return ms[i];
            }
        }
        return null;
    }
}

