/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import gnu.trove.Equality;
import java.io.File;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrayUtil
extends ArrayUtilRt {
    public static final short[] EMPTY_SHORT_ARRAY = ArrayUtilRt.EMPTY_SHORT_ARRAY;
    public static final char[] EMPTY_CHAR_ARRAY = ArrayUtilRt.EMPTY_CHAR_ARRAY;
    public static final byte[] EMPTY_BYTE_ARRAY = ArrayUtilRt.EMPTY_BYTE_ARRAY;
    public static final int[] EMPTY_INT_ARRAY = ArrayUtilRt.EMPTY_INT_ARRAY;
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = ArrayUtilRt.EMPTY_BOOLEAN_ARRAY;
    public static final Object[] EMPTY_OBJECT_ARRAY = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY = ArrayUtilRt.EMPTY_STRING_ARRAY;
    public static final Class[] EMPTY_CLASS_ARRAY = ArrayUtilRt.EMPTY_CLASS_ARRAY;
    public static final long[] EMPTY_LONG_ARRAY = ArrayUtilRt.EMPTY_LONG_ARRAY;
    public static final Collection[] EMPTY_COLLECTION_ARRAY = ArrayUtilRt.EMPTY_COLLECTION_ARRAY;
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtilRt.EMPTY_FILE_ARRAY;
    public static final Runnable[] EMPTY_RUNNABLE_ARRAY = ArrayUtilRt.EMPTY_RUNNABLE_ARRAY;
    public static final CharSequence EMPTY_CHAR_SEQUENCE = new CharArrayCharSequence(EMPTY_CHAR_ARRAY);
    public static final ArrayFactory<String> STRING_ARRAY_FACTORY = new ArrayFactory<String>(){

        @NotNull
        public String[] create(int count) {
            String[] stringArray = ArrayUtil.newStringArray(count);
            if (stringArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil$1", "create"));
            }
            return stringArray;
        }
    };
    public static final ArrayFactory<Object> OBJECT_ARRAY_FACTORY = new ArrayFactory<Object>(){

        @Override
        @NotNull
        public Object[] create(int count) {
            Object[] objectArray = ArrayUtil.newObjectArray(count);
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil$2", "create"));
            }
            return objectArray;
        }
    };

    private ArrayUtil() {
    }

    @NotNull
    @Contract(pure=true)
    public static int[] realloc(@NotNull int[] array, int newSize) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "realloc"));
        }
        if (newSize == 0) {
            if (EMPTY_INT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return EMPTY_INT_ARRAY;
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return array;
        }
        int[] result2 = new int[newSize];
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] realloc(@NotNull T[] array, int newSize, @NotNull ArrayFactory<T> factory) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "realloc"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "realloc"));
        }
        int oldSize = array.length;
        if (oldSize == newSize) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return array;
        }
        T[] result2 = factory.create(newSize);
        if (newSize == 0) {
            if (result2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
            }
            return result2;
        }
        System.arraycopy(array, 0, result2, 0, Math.min(oldSize, newSize));
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "realloc"));
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] append(@NotNull int[] array, int value) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "append"));
        }
        array = ArrayUtil.realloc(array, array.length + 1);
        array[array.length - 1] = value;
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return array;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toObjectArray(@NotNull Collection<T> collection, @NotNull Class<T> aClass2) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        Object[] array = (Object[])Array.newInstance(aClass2, collection.size());
        Object[] objectArray = collection.toArray(array);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static Object[] toObjectArray(@NotNull Collection<?> collection) {
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        if (collection.isEmpty()) {
            if (EMPTY_OBJECT_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toObjectArray"));
            }
            return EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = collection.toArray(new Object[collection.size()]);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toObjectArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeArrays(@NotNull T[] a1, @NotNull T[] a2) {
        Class<?> class2;
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        if (a1.length == 0) {
            if (a2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
            }
            return a2;
        }
        if (a2.length == 0) {
            if (a1 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
            }
            return a1;
        }
        Class<?> class1 = a1.getClass().getComponentType();
        Class<?> aClass2 = class1.isAssignableFrom(class2 = a2.getClass().getComponentType()) ? class1 : class2;
        Object[] result2 = (Object[])Array.newInstance(aClass2, a1.length + a2.length);
        System.arraycopy(a1, 0, result2, 0, a1.length);
        System.arraycopy(a2, 0, result2, a1.length, a2.length);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrays"));
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeCollections(@NotNull Collection<? extends T> c1, @NotNull Collection<? extends T> c2, @NotNull ArrayFactory<T> factory) {
        if (c1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c1", "com/intellij/util/ArrayUtil", "mergeCollections"));
        }
        if (c2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c2", "com/intellij/util/ArrayUtil", "mergeCollections"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "mergeCollections"));
        }
        T[] res = factory.create(c1.size() + c2.size());
        int i = 0;
        for (T t : c1) {
            res[i++] = t;
        }
        for (T t : c2) {
            res[i++] = t;
        }
        if (res == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeCollections"));
        }
        return res;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] mergeArrayAndCollection(@NotNull T[] array, @NotNull Collection<T> collection, @NotNull ArrayFactory<T> factory) {
        T[] array2;
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
        }
        if (collection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "collection", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
        }
        if (collection.isEmpty()) {
            if (array == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
            }
            return array;
        }
        try {
            array2 = collection.toArray(factory.create(collection.size()));
        }
        catch (ArrayStoreException e) {
            throw new RuntimeException("Bad elements in collection: " + collection, e);
        }
        if (array.length == 0) {
            if (array2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
            }
            return array2;
        }
        T[] result2 = factory.create(array.length + collection.size());
        System.arraycopy(array, 0, result2, 0, array.length);
        System.arraycopy(array2, 0, result2, array.length, array2.length);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "mergeArrayAndCollection"));
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, @Nullable T element) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "append"));
        }
        T[] TArray = ArrayUtil.append(src, element, src.getClass().getComponentType());
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "prepend"));
        }
        T[] TArray = ArrayUtil.prepend(element, array, array.getClass().getComponentType());
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "prepend"));
        }
        return TArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] prepend(T element, @NotNull T[] array, @NotNull Class<T> type2) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "prepend"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/util/ArrayUtil", "prepend"));
        }
        int length = array.length;
        Object[] result2 = (Object[])Array.newInstance(type2, length + 1);
        System.arraycopy(array, 0, result2, 1, length);
        result2[0] = element;
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "prepend"));
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, T element, @NotNull ArrayFactory<T> factory) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "append"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "append"));
        }
        int length = src.length;
        T[] result2 = factory.create(length + 1);
        System.arraycopy(src, 0, result2, 0, length);
        result2[length] = element;
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] append(@NotNull T[] src, @Nullable T element, @NotNull Class<T> componentType) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "append"));
        }
        if (componentType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentType", "com/intellij/util/ArrayUtil", "append"));
        }
        int length = src.length;
        Object[] result2 = (Object[])Array.newInstance(componentType, length + 1);
        System.arraycopy(src, 0, result2, 0, length);
        result2[length] = element;
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "append"));
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        Object[] result2 = (Object[])Array.newInstance(src.getClass().getComponentType(), length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] remove(@NotNull T[] src, int idx, @NotNull ArrayFactory<T> factory) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "com/intellij/util/ArrayUtil", "remove"));
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        T[] result2 = factory.create(length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return result2;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] remove(@NotNull int[] src, int idx) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "remove"));
        }
        int length = src.length;
        if (idx < 0 || idx >= length) {
            throw new IllegalArgumentException("invalid index: " + idx);
        }
        int[] result2 = ArrayUtil.newIntArray(src.length - 1);
        System.arraycopy(src, 0, result2, 0, idx);
        System.arraycopy(src, idx + 1, result2, idx, length - idx - 1);
        if (result2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "remove"));
        }
        return result2;
    }

    @Contract(pure=true)
    public static <T> int find(@NotNull T[] src, T obj) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "find"));
        }
        return ArrayUtilRt.find(src, obj);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull byte[] array, @NotNull byte[] prefix) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "startsWith"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "com/intellij/util/ArrayUtil", "startsWith"));
        }
        if (array == prefix) {
            return true;
        }
        int length = prefix.length;
        if (array.length < length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull Object[] objects, @Nullable Object object) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        return ArrayUtil.indexOf(objects, object, 0, objects.length);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull Object[] objects, Object object, int start, int end) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        if (object == null) {
            for (int i = start; i < end; ++i) {
                if (objects[i] != null) continue;
                return i;
            }
        } else {
            for (int i = start; i < end; ++i) {
                if (!object.equals(objects[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int indexOf(@NotNull List<T> objects, T object, @NotNull Equality<T> comparator) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        for (int i = 0; i < objects.size(); ++i) {
            if (!comparator.equals(objects.get(i), object)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull int[] ints, int value) {
        if (ints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ints", "com/intellij/util/ArrayUtil", "indexOf"));
        }
        for (int i = 0; i < ints.length; ++i) {
            if (ints[i] != value) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static <T> int lastIndexOf(@NotNull List<T> src, T obj, @NotNull Equality<? super T> comparator) {
        if (src == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "src", "com/intellij/util/ArrayUtil", "lastIndexOf"));
        }
        if (comparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comparator", "com/intellij/util/ArrayUtil", "lastIndexOf"));
        }
        for (int i = src.size() - 1; i >= 0; --i) {
            T o = src.get(i);
            if (!comparator.equals(obj, o)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean contains(@Nullable Object o, Object ... objects) {
        if (objects == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objects", "com/intellij/util/ArrayUtil", "contains"));
        }
        return ArrayUtil.indexOf(objects, o) >= 0;
    }

    @Contract(pure=true)
    public static boolean contains(@Nullable String s, String ... strings) {
        if (strings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "strings", "com/intellij/util/ArrayUtil", "contains"));
        }
        if (s == null) {
            for (String str : strings) {
                if (str != null) continue;
                return true;
            }
        } else {
            for (String str : strings) {
                if (!s.equals(str)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static int[] newIntArray(int count) {
        int[] nArray = count == 0 ? EMPTY_INT_ARRAY : new int[count];
        if (nArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "newIntArray"));
        }
        return nArray;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] newStringArray(int count) {
        String[] stringArray = count == 0 ? EMPTY_STRING_ARRAY : new String[count];
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "newStringArray"));
        }
        return stringArray;
    }

    @NotNull
    @Contract(pure=true)
    public static Object[] newObjectArray(int count) {
        Object[] objectArray = count == 0 ? EMPTY_OBJECT_ARRAY : new Object[count];
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "newObjectArray"));
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> E[] ensureExactSize(int count, @NotNull E[] sample) {
        if (sample == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sample", "com/intellij/util/ArrayUtil", "ensureExactSize"));
        }
        if (count == sample.length) {
            if (sample == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "ensureExactSize"));
            }
            return sample;
        }
        Object[] array = (Object[])Array.newInstance(sample.getClass().getComponentType(), count);
        if (array == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "ensureExactSize"));
        }
        return array;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getLastElement(@Nullable T[] array) {
        return array != null && array.length > 0 ? (T)array[array.length - 1] : null;
    }

    @NotNull
    @Contract(pure=true)
    public static String[] toStringArray(@Nullable Collection<String> collection) {
        String[] stringArray = ArrayUtilRt.toStringArray(collection);
        if (stringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "toStringArray"));
        }
        return stringArray;
    }

    @NotNull
    public static <T> T[] stripTrailingNulls(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "stripTrailingNulls"));
        }
        T[] TArray = array.length != 0 && array[array.length - 1] == null ? Arrays.copyOf(array, ArrayUtil.trailingNullsIndex(array)) : array;
        if (TArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ArrayUtil", "stripTrailingNulls"));
        }
        return TArray;
    }

    private static <T> int trailingNullsIndex(@NotNull T[] array) {
        if (array == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "com/intellij/util/ArrayUtil", "trailingNullsIndex"));
        }
        for (int i = array.length - 1; i >= 0; --i) {
            if (array[i] == null) continue;
            return i + 1;
        }
        return 0;
    }
}

