/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.RawTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeSystem;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.util.Util;

public class AnnotatableTypeSystem
extends TypeSystem {
    private LookupEnvironment environment;
    private boolean isAnnotationBasedNullAnalysisEnabled;

    public AnnotatableTypeSystem(LookupEnvironment lookupEnvironment) {
        super(lookupEnvironment);
        this.environment = lookupEnvironment;
        this.isAnnotationBasedNullAnalysisEnabled = lookupEnvironment.globalOptions.isAnnotationBasedNullAnalysisEnabled;
    }

    @Override
    public TypeBinding[] getAnnotatedTypes(TypeBinding typeBinding) {
        TypeBinding typeBinding2;
        TypeBinding[] typeBindingArray = this.getDerivedTypes(typeBinding);
        int n = typeBindingArray.length;
        TypeBinding[] typeBindingArray2 = new TypeBinding[n];
        int n2 = 0;
        for (int i = 0; i < n && (typeBinding2 = typeBindingArray[i]) != null; ++i) {
            if (!typeBinding2.hasTypeAnnotations() || typeBinding2.id != typeBinding.id) continue;
            typeBindingArray2[n2++] = typeBinding2;
        }
        if (n2 != n) {
            TypeBinding[] typeBindingArray3 = typeBindingArray2;
            typeBindingArray2 = new TypeBinding[n2];
            System.arraycopy(typeBindingArray3, 0, typeBindingArray2, 0, n2);
        }
        return typeBindingArray2;
    }

    @Override
    public ArrayBinding getArrayType(TypeBinding typeBinding, int n, AnnotationBinding[] annotationBindingArray) {
        ArrayBinding arrayBinding = null;
        for (TypeBinding typeBinding2 : this.getDerivedTypes(typeBinding)) {
            if (typeBinding2 == null) break;
            if (!typeBinding2.isArrayType() || typeBinding2.dimensions() != n || typeBinding2.leafComponentType() != typeBinding) continue;
            if (Util.effectivelyEqual(typeBinding2.getTypeAnnotations(), annotationBindingArray)) {
                return (ArrayBinding)typeBinding2;
            }
            if (typeBinding2.hasTypeAnnotations()) continue;
            arrayBinding = (ArrayBinding)typeBinding2;
        }
        if (arrayBinding == null) {
            arrayBinding = super.getArrayType(typeBinding, n);
        }
        if (!this.haveTypeAnnotations(typeBinding, annotationBindingArray)) {
            return arrayBinding;
        }
        ArrayBinding arrayBinding2 = new ArrayBinding(typeBinding, n, this.environment);
        arrayBinding2.id = arrayBinding.id;
        arrayBinding2.setTypeAnnotations(annotationBindingArray, this.isAnnotationBasedNullAnalysisEnabled);
        return (ArrayBinding)this.cacheDerivedType(typeBinding, arrayBinding, arrayBinding2);
    }

    @Override
    public ArrayBinding getArrayType(TypeBinding typeBinding, int n) {
        return this.getArrayType(typeBinding, n, Binding.NO_ANNOTATIONS);
    }

    @Override
    public ReferenceBinding getMemberType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        if (!this.haveTypeAnnotations((TypeBinding)referenceBinding, referenceBinding2)) {
            return super.getMemberType(referenceBinding, referenceBinding2);
        }
        return (ReferenceBinding)this.getAnnotatedType(referenceBinding, referenceBinding2, referenceBinding.getTypeAnnotations());
    }

    @Override
    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        if (referenceBinding.hasTypeAnnotations()) {
            throw new IllegalStateException();
        }
        ParameterizedTypeBinding parameterizedTypeBinding = null;
        for (TypeBinding typeBinding : this.getDerivedTypes(referenceBinding)) {
            if (typeBinding == null) break;
            if (!typeBinding.isParameterizedType() || typeBinding.actualType() != referenceBinding || typeBinding.enclosingType() != referenceBinding2 || !Util.effectivelyEqual(typeBinding.typeArguments(), typeBindingArray)) continue;
            if (Util.effectivelyEqual(annotationBindingArray, typeBinding.getTypeAnnotations())) {
                return (ParameterizedTypeBinding)typeBinding;
            }
            if (typeBinding.hasTypeAnnotations()) continue;
            parameterizedTypeBinding = (ParameterizedTypeBinding)typeBinding;
        }
        if (parameterizedTypeBinding == null) {
            parameterizedTypeBinding = super.getParameterizedType(referenceBinding, typeBindingArray, referenceBinding2);
        }
        if (!this.haveTypeAnnotations(referenceBinding, referenceBinding2, typeBindingArray, annotationBindingArray)) {
            return parameterizedTypeBinding;
        }
        ParameterizedTypeBinding parameterizedTypeBinding2 = new ParameterizedTypeBinding(referenceBinding, typeBindingArray, referenceBinding2, this.environment);
        parameterizedTypeBinding2.id = parameterizedTypeBinding.id;
        parameterizedTypeBinding2.setTypeAnnotations(annotationBindingArray, this.isAnnotationBasedNullAnalysisEnabled);
        return (ParameterizedTypeBinding)this.cacheDerivedType(referenceBinding, parameterizedTypeBinding, parameterizedTypeBinding2);
    }

    @Override
    public ParameterizedTypeBinding getParameterizedType(ReferenceBinding referenceBinding, TypeBinding[] typeBindingArray, ReferenceBinding referenceBinding2) {
        return this.getParameterizedType(referenceBinding, typeBindingArray, referenceBinding2, Binding.NO_ANNOTATIONS);
    }

    @Override
    public RawTypeBinding getRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2, AnnotationBinding[] annotationBindingArray) {
        if (referenceBinding.hasTypeAnnotations()) {
            throw new IllegalStateException();
        }
        RawTypeBinding rawTypeBinding = null;
        for (TypeBinding typeBinding : this.getDerivedTypes(referenceBinding)) {
            if (typeBinding == null) break;
            if (!typeBinding.isRawType() || typeBinding.actualType() != referenceBinding || typeBinding.enclosingType() != referenceBinding2) continue;
            if (Util.effectivelyEqual(typeBinding.getTypeAnnotations(), annotationBindingArray)) {
                return (RawTypeBinding)typeBinding;
            }
            if (typeBinding.hasTypeAnnotations()) continue;
            rawTypeBinding = (RawTypeBinding)typeBinding;
        }
        if (rawTypeBinding == null) {
            rawTypeBinding = super.getRawType(referenceBinding, referenceBinding2);
        }
        if (!this.haveTypeAnnotations(referenceBinding, referenceBinding2, null, annotationBindingArray)) {
            return rawTypeBinding;
        }
        RawTypeBinding rawTypeBinding2 = new RawTypeBinding(referenceBinding, referenceBinding2, this.environment);
        rawTypeBinding2.id = rawTypeBinding.id;
        rawTypeBinding2.setTypeAnnotations(annotationBindingArray, this.isAnnotationBasedNullAnalysisEnabled);
        return (RawTypeBinding)this.cacheDerivedType(referenceBinding, rawTypeBinding, rawTypeBinding2);
    }

    @Override
    public RawTypeBinding getRawType(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        return this.getRawType(referenceBinding, referenceBinding2, Binding.NO_ANNOTATIONS);
    }

    @Override
    public WildcardBinding getWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2, AnnotationBinding[] annotationBindingArray) {
        if (referenceBinding == null) {
            referenceBinding = ReferenceBinding.LUB_GENERIC;
        }
        if (referenceBinding.hasTypeAnnotations()) {
            throw new IllegalStateException();
        }
        WildcardBinding wildcardBinding = null;
        for (TypeBinding typeBinding2 : this.getDerivedTypes(referenceBinding)) {
            if (typeBinding2 == null) break;
            if (!typeBinding2.isWildcard() || typeBinding2.actualType() != referenceBinding || typeBinding2.rank() != n || typeBinding2.boundKind() != n2 || typeBinding2.bound() != typeBinding || !Util.effectivelyEqual(typeBinding2.additionalBounds(), typeBindingArray)) continue;
            if (Util.effectivelyEqual(typeBinding2.getTypeAnnotations(), annotationBindingArray)) {
                return (WildcardBinding)typeBinding2;
            }
            if (typeBinding2.hasTypeAnnotations()) continue;
            wildcardBinding = (WildcardBinding)typeBinding2;
        }
        if (wildcardBinding == null) {
            wildcardBinding = super.getWildcard(referenceBinding, n, typeBinding, typeBindingArray, n2);
        }
        if (!this.haveTypeAnnotations(referenceBinding, typeBinding, typeBindingArray, annotationBindingArray)) {
            return wildcardBinding;
        }
        WildcardBinding wildcardBinding2 = new WildcardBinding(referenceBinding, n, typeBinding, typeBindingArray, n2, this.environment);
        wildcardBinding2.id = wildcardBinding.id;
        wildcardBinding2.setTypeAnnotations(annotationBindingArray, this.isAnnotationBasedNullAnalysisEnabled);
        return (WildcardBinding)this.cacheDerivedType(referenceBinding, wildcardBinding, wildcardBinding2);
    }

    @Override
    public WildcardBinding getWildcard(ReferenceBinding referenceBinding, int n, TypeBinding typeBinding, TypeBinding[] typeBindingArray, int n2) {
        return this.getWildcard(referenceBinding, n, typeBinding, typeBindingArray, n2, Binding.NO_ANNOTATIONS);
    }

    @Override
    public TypeBinding getAnnotatedType(TypeBinding typeBinding, AnnotationBinding[][] annotationBindingArray) {
        if (typeBinding == null || !typeBinding.isValidBinding() || annotationBindingArray == null || annotationBindingArray.length == 0) {
            return typeBinding;
        }
        TypeBinding typeBinding2 = null;
        switch (typeBinding.kind()) {
            case 68: {
                ArrayBinding arrayBinding = (ArrayBinding)typeBinding;
                typeBinding2 = this.getArrayType(arrayBinding.leafComponentType, arrayBinding.dimensions, AnnotatableTypeSystem.flattenedAnnotations(annotationBindingArray));
                break;
            }
            case 4: 
            case 132: 
            case 260: 
            case 516: 
            case 1028: 
            case 2052: 
            case 4100: 
            case 8196: 
            case 32772: {
                TypeBinding typeBinding3;
                if (typeBinding.isUnresolvedType() && CharOperation.indexOf('$', typeBinding.sourceName()) > 0) {
                    typeBinding = BinaryTypeBinding.resolveType(typeBinding, this.environment, true);
                }
                int n = typeBinding.depth() + 1;
                TypeBinding[] typeBindingArray = new TypeBinding[n];
                typeBindingArray[--n] = typeBinding;
                for (typeBinding3 = typeBinding.enclosingType(); typeBinding3 != null; typeBinding3 = typeBinding3.enclosingType()) {
                    typeBindingArray[--n] = typeBinding3;
                }
                n = annotationBindingArray.length;
                int n2 = typeBindingArray.length - n;
                int n3 = 0;
                while (n3 < n && (annotationBindingArray[n3] == null || annotationBindingArray[n3].length <= 0)) {
                    ++n3;
                    ++n2;
                }
                if (n3 == n) {
                    return typeBinding;
                }
                if (n2 < 0) {
                    return typeBinding;
                }
                TypeBinding typeBinding4 = typeBinding3 = n2 == 0 ? null : typeBindingArray[n2 - 1];
                while (n3 < n) {
                    TypeBinding typeBinding5 = typeBindingArray[n2];
                    AnnotationBinding[] annotationBindingArray2 = annotationBindingArray[n3] != null && annotationBindingArray[n3].length > 0 ? annotationBindingArray[n3] : typeBinding5.getTypeAnnotations();
                    typeBinding2 = this.getAnnotatedType(typeBinding5, typeBinding3, annotationBindingArray2);
                    typeBinding3 = typeBinding2;
                    ++n3;
                    ++n2;
                }
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return typeBinding2;
    }

    /*
     * Exception decompiling
     */
    private TypeBinding getAnnotatedType(TypeBinding var1_1, TypeBinding var2_2, AnnotationBinding[] var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[SWITCH], 5[CASE]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean haveTypeAnnotations(TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding[] typeBindingArray, AnnotationBinding[] annotationBindingArray) {
        int n;
        int n2;
        if (typeBinding != null && typeBinding.hasTypeAnnotations()) {
            return true;
        }
        if (typeBinding2 != null && typeBinding2.hasTypeAnnotations()) {
            return true;
        }
        int n3 = n2 = annotationBindingArray == null ? 0 : annotationBindingArray.length;
        for (n = 0; n < n2; ++n) {
            if (annotationBindingArray[n] == null) continue;
            return true;
        }
        int n4 = n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
        for (n = 0; n < n2; ++n) {
            if (!typeBindingArray[n].hasTypeAnnotations()) continue;
            return true;
        }
        return false;
    }

    private boolean haveTypeAnnotations(TypeBinding typeBinding, AnnotationBinding[] annotationBindingArray) {
        return this.haveTypeAnnotations(typeBinding, null, null, annotationBindingArray);
    }

    private boolean haveTypeAnnotations(TypeBinding typeBinding, TypeBinding typeBinding2) {
        return this.haveTypeAnnotations(typeBinding, typeBinding2, null, null);
    }

    static AnnotationBinding[] flattenedAnnotations(AnnotationBinding[][] annotationBindingArray) {
        int n;
        if (annotationBindingArray == null || annotationBindingArray.length == 0) {
            return Binding.NO_ANNOTATIONS;
        }
        int n2 = n = annotationBindingArray.length;
        for (int i = 0; i < n; ++i) {
            n2 += annotationBindingArray[i] == null ? 0 : annotationBindingArray[i].length;
        }
        if (n2 == 0) {
            return Binding.NO_ANNOTATIONS;
        }
        AnnotationBinding[] annotationBindingArray2 = new AnnotationBinding[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            int n4;
            int n5 = n4 = annotationBindingArray[i] == null ? 0 : annotationBindingArray[i].length;
            if (n4 > 0) {
                System.arraycopy(annotationBindingArray[i], 0, annotationBindingArray2, n3, n4);
                n3 += n4;
            }
            annotationBindingArray2[n3++] = null;
        }
        if (n3 != n2) {
            throw new IllegalStateException();
        }
        return annotationBindingArray2;
    }

    @Override
    public boolean isAnnotatedTypeSystem() {
        return true;
    }
}

