/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Set;
import org.eclipse.jdt.internal.compiler.lookup.InferenceVariable;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class IntersectionCastTypeBinding
extends ReferenceBinding {
    public ReferenceBinding[] intersectingTypes;
    private ReferenceBinding javaLangObject;
    int length;

    public IntersectionCastTypeBinding(ReferenceBinding[] referenceBindingArray, LookupEnvironment lookupEnvironment) {
        this.intersectingTypes = referenceBindingArray;
        this.length = referenceBindingArray.length;
        if (!referenceBindingArray[0].isClass()) {
            this.javaLangObject = lookupEnvironment.getResolvedType(TypeConstants.JAVA_LANG_OBJECT, null);
            this.modifiers |= 0x200;
        }
    }

    @Override
    public MethodBinding getSingleAbstractMethod(Scope scope, boolean bl) {
        int n;
        int n2 = n = bl ? 0 : 1;
        if (this.singleAbstractMethod != null) {
            if (this.singleAbstractMethod[n] != null) {
                return this.singleAbstractMethod[n];
            }
        } else {
            this.singleAbstractMethod = new MethodBinding[2];
        }
        MethodBinding methodBinding = samProblemBinding;
        for (int i = 0; i < this.length; ++i) {
            MethodBinding methodBinding2 = this.intersectingTypes[i].getSingleAbstractMethod(scope, bl);
            if (methodBinding2 == null || !methodBinding2.isValidBinding()) continue;
            if (methodBinding.isValidBinding()) {
                this.singleAbstractMethod[n] = new ProblemMethodBinding(TypeConstants.ANONYMOUS_METHOD, null, 19);
                return this.singleAbstractMethod[n];
            }
            methodBinding = methodBinding2;
        }
        this.singleAbstractMethod[n] = methodBinding;
        return this.singleAbstractMethod[n];
    }

    @Override
    public boolean hasTypeBit(int n) {
        for (int i = 0; i < this.length; ++i) {
            if (!this.intersectingTypes[i].hasTypeBit(n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeInstantiated() {
        return false;
    }

    @Override
    public boolean canBeSeenBy(PackageBinding packageBinding) {
        for (int i = 0; i < this.length; ++i) {
            if (this.intersectingTypes[i].canBeSeenBy(packageBinding)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeSeenBy(Scope scope) {
        for (int i = 0; i < this.length; ++i) {
            if (this.intersectingTypes[i].canBeSeenBy(scope)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean canBeSeenBy(ReferenceBinding referenceBinding, ReferenceBinding referenceBinding2) {
        for (int i = 0; i < this.length; ++i) {
            if (this.intersectingTypes[i].canBeSeenBy(referenceBinding, referenceBinding2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public char[] constantPoolName() {
        return this.intersectingTypes[0].constantPoolName();
    }

    @Override
    public PackageBinding getPackage() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceBinding[] getIntersectingTypes() {
        return this.intersectingTypes;
    }

    @Override
    public ReferenceBinding superclass() {
        return this.intersectingTypes[0].isClass() ? this.intersectingTypes[0] : this.javaLangObject;
    }

    @Override
    public ReferenceBinding[] superInterfaces() {
        if (this.intersectingTypes[0].isClass()) {
            ReferenceBinding[] referenceBindingArray = new ReferenceBinding[this.length - 1];
            System.arraycopy(this.intersectingTypes, 1, referenceBindingArray, 0, this.length - 1);
            return referenceBindingArray;
        }
        return this.intersectingTypes;
    }

    @Override
    public boolean isBoxedPrimitiveType() {
        return this.intersectingTypes[0].isBoxedPrimitiveType();
    }

    @Override
    public boolean isCompatibleWith(TypeBinding typeBinding, Scope scope) {
        if (TypeBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        int n = typeBinding.kind();
        ReferenceBinding[] referenceBindingArray = null;
        if (n == 8196 && typeBinding.boundKind() == 1) {
            TypeBinding typeBinding2 = ((WildcardBinding)typeBinding).allBounds();
            if (typeBinding2 instanceof IntersectionCastTypeBinding) {
                referenceBindingArray = ((IntersectionCastTypeBinding)typeBinding2).intersectingTypes;
            }
        } else if (n == 32772) {
            referenceBindingArray = ((IntersectionCastTypeBinding)typeBinding).intersectingTypes;
        }
        if (referenceBindingArray != null) {
            int n2 = referenceBindingArray.length;
            TypeBinding[] typeBindingArray = new TypeBinding[n2];
            System.arraycopy(referenceBindingArray, 0, typeBindingArray, 0, n2);
            block0: for (int i = 0; i < this.length; ++i) {
                ReferenceBinding referenceBinding = this.intersectingTypes[i];
                for (int j = 0; j < typeBindingArray.length; ++j) {
                    if (typeBindingArray[j] == null || !((TypeBinding)referenceBinding).isCompatibleWith(typeBindingArray[j], scope)) continue;
                    typeBindingArray[j] = null;
                    if (--n2 != 0) continue block0;
                    return true;
                }
            }
            return false;
        }
        for (int i = 0; i < this.length; ++i) {
            if (!this.intersectingTypes[i].isCompatibleWith(typeBinding, scope)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSubtypeOf(TypeBinding typeBinding) {
        if (TypeBinding.equalsEquals(this, typeBinding)) {
            return true;
        }
        for (int i = 0; i < this.intersectingTypes.length; ++i) {
            if (!this.intersectingTypes[i].isSubtypeOf(typeBinding)) continue;
            return true;
        }
        return false;
    }

    @Override
    public char[] qualifiedSourceName() {
        StringBuffer stringBuffer = new StringBuffer(16);
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.intersectingTypes[i].qualifiedSourceName());
            if (i == this.length - 1) continue;
            stringBuffer.append(" & ");
        }
        return stringBuffer.toString().toCharArray();
    }

    @Override
    public char[] sourceName() {
        StringBuffer stringBuffer = new StringBuffer(16);
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.intersectingTypes[i].sourceName());
            if (i == this.length - 1) continue;
            stringBuffer.append(" & ");
        }
        return stringBuffer.toString().toCharArray();
    }

    @Override
    public char[] readableName() {
        StringBuffer stringBuffer = new StringBuffer(16);
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.intersectingTypes[i].readableName());
            if (i == this.length - 1) continue;
            stringBuffer.append(" & ");
        }
        return stringBuffer.toString().toCharArray();
    }

    @Override
    public char[] shortReadableName() {
        StringBuffer stringBuffer = new StringBuffer(16);
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.intersectingTypes[i].shortReadableName());
            if (i == this.length - 1) continue;
            stringBuffer.append(" & ");
        }
        return stringBuffer.toString().toCharArray();
    }

    @Override
    public boolean isIntersectionCastType() {
        return true;
    }

    @Override
    public int kind() {
        return 32772;
    }

    @Override
    public String debugName() {
        StringBuffer stringBuffer = new StringBuffer(16);
        for (int i = 0; i < this.length; ++i) {
            stringBuffer.append(this.intersectingTypes[i].debugName());
            if (i == this.length - 1) continue;
            stringBuffer.append(" & ");
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.debugName();
    }

    public TypeBinding getSAMType(Scope scope) {
        ReferenceBinding referenceBinding = null;
        for (ReferenceBinding referenceBinding2 : this.intersectingTypes) {
            MethodBinding methodBinding = ((TypeBinding)referenceBinding2).getSingleAbstractMethod(scope, true);
            if (methodBinding instanceof ProblemMethodBinding && ((ProblemMethodBinding)methodBinding).problemId() == 17) continue;
            if (referenceBinding != null) {
                return null;
            }
            referenceBinding = referenceBinding2;
        }
        return referenceBinding;
    }

    @Override
    void collectInferenceVariables(Set<InferenceVariable> set) {
        for (int i = 0; i < this.intersectingTypes.length; ++i) {
            this.intersectingTypes[i].collectInferenceVariables(set);
        }
    }

    @Override
    public boolean mentionsAny(TypeBinding[] typeBindingArray, int n) {
        if (super.mentionsAny(typeBindingArray, n)) {
            return true;
        }
        for (int i = 0; i < this.intersectingTypes.length; ++i) {
            if (!this.intersectingTypes[i].mentionsAny(typeBindingArray, -1)) continue;
            return true;
        }
        return false;
    }
}

