/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.event;

import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomModelEvent
extends EventObject {
    private Map<PomModelAspect, PomChangeSet> myChangeSets;

    public PomModelEvent(PomModel source) {
        super(source);
    }

    public void registerChangeSet(PomModelAspect aspect, PomChangeSet set) {
        if (this.myChangeSets == null) {
            this.myChangeSets = new HashMap<PomModelAspect, PomChangeSet>();
        }
        if (set == null) {
            this.myChangeSets.remove(aspect);
        } else {
            this.myChangeSets.put(aspect, set);
        }
    }

    @Nullable
    public PomChangeSet getChangeSet(PomModelAspect aspect) {
        if (this.myChangeSets == null) {
            return null;
        }
        return this.myChangeSets.get(aspect);
    }

    public void merge(@NotNull PomModelEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/pom/event/PomModelEvent", "merge"));
        }
        if (event.myChangeSets == null) {
            return;
        }
        if (this.myChangeSets == null) {
            this.myChangeSets = new HashMap<PomModelAspect, PomChangeSet>(event.myChangeSets);
            return;
        }
        for (Map.Entry<PomModelAspect, PomChangeSet> entry : event.myChangeSets.entrySet()) {
            PomModelAspect aspect = entry.getKey();
            PomChangeSet pomChangeSet = this.myChangeSets.get(aspect);
            if (pomChangeSet != null) {
                pomChangeSet.merge(entry.getValue());
                continue;
            }
            this.myChangeSets.put(aspect, entry.getValue());
        }
    }

    @Override
    public PomModel getSource() {
        return (PomModel)super.getSource();
    }
}

