/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.filter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URI;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.filter.FilterAdaptor;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;

public class FilterLogGetQuery
extends FilterAdaptor {
    private static final String delim = "\t";
    private static final String CRLF = "\r\n";
    private File outFile;
    private Pattern pSeparator = Pattern.compile("([^=&]+)[=]([^=&]*)");
    private Matcher matcher2;
    private BufferedWriter writer = null;
    private long lastWriteTime = System.currentTimeMillis();
    private static final Logger logger = Logger.getLogger(FilterLogGetQuery.class);

    @Override
    public int getId() {
        return 20;
    }

    @Override
    public String getName() {
        return Constant.messages.getString("filter.loggets.name") + this.getLogFileName();
    }

    @Override
    public void init(Model model) {
        this.outFile = new File(this.getLogFileName());
    }

    protected String getLogFileName() {
        return "filter/get.xls";
    }

    @Override
    public void onHttpRequestSend(HttpMessage httpMessage) {
        HttpRequestHeader httpRequestHeader = httpMessage.getRequestHeader();
        if (httpRequestHeader != null && httpRequestHeader.isText() && !httpRequestHeader.isImage() && httpRequestHeader.getMethod().equalsIgnoreCase("GET")) {
            try {
                URI uRI = httpRequestHeader.getURI();
                URI uRI2 = (URI)uRI.clone();
                String string = uRI2.getQuery();
                if (string != null) {
                    uRI2.setQuery(null);
                    String string2 = uRI2.toString();
                    Hashtable<String, String> hashtable = this.parseParameter(string);
                    this.writeLogFile(string2, hashtable);
                } else {
                    String string3 = uRI.toString();
                    this.writeLogFile(string3, null);
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    @Override
    public void onHttpResponseReceive(HttpMessage httpMessage) {
    }

    protected synchronized void writeLogFile(String string, Hashtable<String, String> hashtable) {
        try {
            if (this.getWriter() != null) {
                this.getWriter().write(string + CRLF);
            }
            if (hashtable != null) {
                Enumeration<String> enumeration = hashtable.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = enumeration.nextElement();
                    String string3 = hashtable.get(string2);
                    this.getWriter().write(delim + string2 + delim + string3 + CRLF);
                }
            }
            this.lastWriteTime = System.currentTimeMillis();
        }
        catch (IOException iOException) {
            logger.error((Object)iOException.getMessage(), (Throwable)iOException);
        }
    }

    protected Hashtable<String, String> parseParameter(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            this.matcher2 = this.pSeparator.matcher(string);
            while (this.matcher2.find()) {
                hashtable.put(this.matcher2.group(1), this.matcher2.group(2));
            }
        }
        catch (Exception exception) {
            logger.error((Object)exception.getMessage(), (Throwable)exception);
        }
        return hashtable;
    }

    @Override
    public synchronized void timer() {
        if (this.writer != null && System.currentTimeMillis() > this.lastWriteTime + 5000L) {
            try {
                this.writer.close();
                this.writer = null;
            }
            catch (IOException iOException) {
                logger.error((Object)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    private synchronized BufferedWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new FileWriter(this.outFile, true));
        }
        return this.writer;
    }
}

