/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.changeset;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.downloadtasks.AbstractChangesetDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetContentDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetHeaderDownloadTask;
import org.openstreetmap.josm.actions.downloadtasks.ChangesetQueryTask;
import org.openstreetmap.josm.actions.downloadtasks.PostDownloadHandler;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.ChangesetCache;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.JosmUserIdentityManager;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheManagerModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetCacheTableColumnModel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetContentPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDetailPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetDiscussionPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.ChangesetTagsPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.SingleChangesetDownloadPanel;
import org.openstreetmap.josm.gui.dialogs.changeset.query.ChangesetQueryDialog;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.io.CloseChangesetTask;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.io.ChangesetQuery;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class ChangesetCacheManager
extends JFrame {
    private static volatile ChangesetCacheManager instance;
    private JTabbedPane pnlChangesetDetailTabs;
    private ChangesetCacheManagerModel model;
    private JSplitPane spContent;
    private boolean needsSplitPaneAdjustment;
    private RemoveFromCacheAction actRemoveFromCacheAction;
    private CloseSelectedChangesetsAction actCloseSelectedChangesetsAction;
    private DownloadSelectedChangesetsAction actDownloadSelectedChangesets;
    private DownloadSelectedChangesetContentAction actDownloadSelectedContent;
    private JTable tblChangesets;

    public static ChangesetCacheManager getInstance() {
        if (instance == null) {
            instance = new ChangesetCacheManager();
        }
        return instance;
    }

    public static void destroyInstance() {
        if (instance != null) {
            instance.setVisible(true);
            instance.dispose();
            instance = null;
        }
    }

    static ChangesetCacheManagerModel buildModel() {
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        defaultListSelectionModel.setSelectionMode(2);
        return new ChangesetCacheManagerModel(defaultListSelectionModel);
    }

    static JPanel buildToolbarPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(0));
        JButton jButton = new JButton(new QueryAction());
        jPanel.add(jButton);
        jPanel.add(new SingleChangesetDownloadPanel());
        jPanel.add(new JButton(new DownloadMyChangesets()));
        return jPanel;
    }

    static JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel(new FlowLayout(1));
        jPanel.add(new JButton(new CancelAction()));
        jPanel.add(new JButton(new ContextSensitiveHelpAction(HelpUtil.ht("/Dialog/ChangesetManager"))));
        return jPanel;
    }

    protected JPanel buildChangesetDetailPanel() {
        JTabbedPane jTabbedPane;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.pnlChangesetDetailTabs = jTabbedPane = new JTabbedPane();
        ChangesetDetailPanel changesetDetailPanel = new ChangesetDetailPanel();
        jTabbedPane.add(changesetDetailPanel);
        this.model.addPropertyChangeListener(changesetDetailPanel);
        ChangesetTagsPanel changesetTagsPanel = new ChangesetTagsPanel();
        jTabbedPane.add(changesetTagsPanel);
        this.model.addPropertyChangeListener(changesetTagsPanel);
        ChangesetContentPanel changesetContentPanel = new ChangesetContentPanel();
        jTabbedPane.add(changesetContentPanel);
        this.model.addPropertyChangeListener(changesetContentPanel);
        ChangesetDiscussionPanel changesetDiscussionPanel = new ChangesetDiscussionPanel();
        jTabbedPane.add(changesetDiscussionPanel);
        this.model.addPropertyChangeListener(changesetDiscussionPanel);
        jTabbedPane.setTitleAt(0, I18n.tr("Properties", new Object[0]));
        jTabbedPane.setToolTipTextAt(0, I18n.tr("Display the basic properties of the changeset", new Object[0]));
        jTabbedPane.setTitleAt(1, I18n.tr("Tags", new Object[0]));
        jTabbedPane.setToolTipTextAt(1, I18n.tr("Display the tags of the changeset", new Object[0]));
        jTabbedPane.setTitleAt(2, I18n.tr("Content", new Object[0]));
        jTabbedPane.setToolTipTextAt(2, I18n.tr("Display the objects created, updated, and deleted by the changeset", new Object[0]));
        jTabbedPane.setTitleAt(3, I18n.tr("Discussion", new Object[0]));
        jTabbedPane.setToolTipTextAt(3, I18n.tr("Display the public discussion around this changeset", new Object[0]));
        jPanel.add((Component)jTabbedPane, "Center");
        return jPanel;
    }

    protected JPanel buildContentPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.spContent = new JSplitPane(0);
        this.spContent.setLeftComponent(this.buildChangesetTablePanel());
        this.spContent.setRightComponent(this.buildChangesetDetailPanel());
        this.spContent.setOneTouchExpandable(true);
        this.spContent.setDividerLocation(0.5);
        jPanel.add((Component)this.spContent, "Center");
        return jPanel;
    }

    protected JPanel buildChangesetTableActionPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        this.model.getSelectionModel().addListSelectionListener(this.actRemoveFromCacheAction);
        jToolBar.add(this.actRemoveFromCacheAction);
        this.model.getSelectionModel().addListSelectionListener(this.actCloseSelectedChangesetsAction);
        jToolBar.add(this.actCloseSelectedChangesetsAction);
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadSelectedChangesets);
        jToolBar.add(this.actDownloadSelectedChangesets);
        this.model.getSelectionModel().addListSelectionListener(this.actDownloadSelectedContent);
        jToolBar.add(this.actDownloadSelectedContent);
        jPanel.add((Component)jToolBar, "Center");
        return jPanel;
    }

    protected JPanel buildChangesetTablePanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tblChangesets = new JTable(this.model, new ChangesetCacheTableColumnModel(), this.model.getSelectionModel());
        this.tblChangesets.addMouseListener(new MouseEventHandler());
        this.tblChangesets.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "showDetails");
        this.tblChangesets.getActionMap().put("showDetails", new ShowDetailAction(this.model));
        this.model.getSelectionModel().addListSelectionListener(new ChangesetDetailViewSynchronizer(this.model));
        this.tblChangesets.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "removeFromCache");
        this.tblChangesets.getActionMap().put("removeFromCache", this.actRemoveFromCacheAction);
        jPanel.add((Component)new JScrollPane(this.tblChangesets), "Center");
        jPanel.add((Component)this.buildChangesetTableActionPanel(), "West");
        return jPanel;
    }

    protected void build() {
        this.setTitle(I18n.tr("Changeset Management Dialog", new Object[0]));
        this.setIconImage(ImageProvider.get("dialogs/changeset", "changesetmanager").getImage());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.model = ChangesetCacheManager.buildModel();
        this.actRemoveFromCacheAction = new RemoveFromCacheAction(this.model);
        this.actCloseSelectedChangesetsAction = new CloseSelectedChangesetsAction(this.model);
        this.actDownloadSelectedChangesets = new DownloadSelectedChangesetsAction(this.model);
        this.actDownloadSelectedContent = new DownloadSelectedChangesetContentAction(this.model);
        container.add((Component)ChangesetCacheManager.buildToolbarPanel(), "North");
        container.add((Component)this.buildContentPanel(), "Center");
        container.add((Component)ChangesetCacheManager.buildButtonPanel(), "South");
        HelpUtil.setHelpContext(this.getRootPane(), HelpUtil.ht("/Dialog/ChangesetManager"));
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancelAndClose");
        this.getRootPane().getActionMap().put("cancelAndClose", new CancelAction());
        this.addWindowListener(new WindowEventHandler());
    }

    public ChangesetCacheManager() {
        this.build();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            new WindowGeometry(this.getClass().getName() + ".geometry", WindowGeometry.centerInWindow(this.getParent(), new Dimension(1000, 600))).applySafe(this);
            this.needsSplitPaneAdjustment = true;
            this.model.init();
        } else if (this.isShowing()) {
            this.model.tearDown();
            new WindowGeometry(this).remember(this.getClass().getName() + ".geometry");
        }
        super.setVisible(bl);
    }

    public void setSelectedChangesets(Collection<Changeset> collection) {
        this.model.setSelectedChangesets(collection);
        final int n = this.model.getSelectionModel().getMinSelectionIndex();
        if (n < 0) {
            return;
        }
        GuiHelper.runInEDTAndWait(new Runnable(){

            @Override
            public void run() {
                ChangesetCacheManager.this.tblChangesets.scrollRectToVisible(ChangesetCacheManager.this.tblChangesets.getCellRect(n, 0, true));
            }
        });
        this.repaint();
    }

    public void setSelectedChangesetsById(Collection<Integer> collection) {
        if (collection == null) {
            this.setSelectedChangesets(null);
            return;
        }
        HashSet<Changeset> hashSet = new HashSet<Changeset>();
        ChangesetCache changesetCache = ChangesetCache.getInstance();
        for (int n : collection) {
            if (!changesetCache.contains(n)) continue;
            hashSet.add(changesetCache.get(n));
        }
        this.setSelectedChangesets(hashSet);
    }

    public void setSelectedComponentInDetailPanel(Class<? extends JComponent> clazz) {
        for (Component component : this.pnlChangesetDetailTabs.getComponents()) {
            if (!component.getClass().equals(clazz)) continue;
            this.pnlChangesetDetailTabs.setSelectedComponent(component);
            break;
        }
    }

    public void runDownloadTask(final AbstractChangesetDownloadTask abstractChangesetDownloadTask) {
        Main.worker.submit(new PostDownloadHandler(abstractChangesetDownloadTask, abstractChangesetDownloadTask.download()));
        Main.worker.submit(new Runnable(){

            @Override
            public void run() {
                if (abstractChangesetDownloadTask.isCanceled() || abstractChangesetDownloadTask.isFailed()) {
                    return;
                }
                ChangesetCacheManager.this.setSelectedChangesets((Collection)abstractChangesetDownloadTask.getDownloadedData());
            }
        });
    }

    static class ChangesetDetailViewSynchronizer
    implements ListSelectionListener {
        private final ChangesetCacheManagerModel model;

        ChangesetDetailViewSynchronizer(ChangesetCacheManagerModel changesetCacheManagerModel) {
            this.model = changesetCacheManagerModel;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            List<Changeset> list = this.model.getSelectedChangesets();
            if (list.size() == 1) {
                this.model.setChangesetInDetailView(list.get(0));
            } else {
                this.model.setChangesetInDetailView(null);
            }
        }
    }

    class ChangesetTablePopupMenu
    extends JPopupMenu {
        ChangesetTablePopupMenu() {
            this.add(ChangesetCacheManager.this.actRemoveFromCacheAction);
            this.add(ChangesetCacheManager.this.actCloseSelectedChangesetsAction);
            this.add(ChangesetCacheManager.this.actDownloadSelectedChangesets);
            this.add(ChangesetCacheManager.this.actDownloadSelectedContent);
        }
    }

    class MouseEventHandler
    extends PopupMenuLauncher {
        MouseEventHandler() {
            super(new ChangesetTablePopupMenu());
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (MouseEventHandler.isDoubleClick(mouseEvent)) {
                new ShowDetailAction(ChangesetCacheManager.this.model).showDetails();
            }
        }
    }

    static class DownloadMyChangesets
    extends AbstractAction {
        DownloadMyChangesets() {
            this.putValue("Name", I18n.tr("My changesets", new Object[0]));
            new ImageProvider("dialogs/changeset", "downloadchangeset").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Download my changesets from the OSM server (max. 100 changesets)", new Object[0]));
            this.setEnabled(!Main.isOffline(OnlineResource.OSM_API));
        }

        protected void alertAnonymousUser(Component component) {
            HelpAwareOptionPane.showOptionDialog(component, I18n.tr("<html>JOSM is currently running with an anonymous user. It cannot download<br>your changesets from the OSM server unless you enter your OSM user name<br>in the JOSM preferences.</html>", new Object[0]), I18n.tr("Warning", new Object[0]), 2, HelpUtil.ht("/Dialog/ChangesetManager#CanDownloadMyChangesets"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Window window = GuiHelper.getWindowAncestorFor(actionEvent);
            JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
            if (josmUserIdentityManager.isAnonymous()) {
                this.alertAnonymousUser(window);
                return;
            }
            ChangesetQuery changesetQuery = new ChangesetQuery();
            changesetQuery = josmUserIdentityManager.isFullyIdentified() ? changesetQuery.forUser(josmUserIdentityManager.getUserId()) : changesetQuery.forUser(josmUserIdentityManager.getUserName());
            if (!GraphicsEnvironment.isHeadless()) {
                ChangesetCacheManager.getInstance().runDownloadTask(new ChangesetQueryTask(window, changesetQuery));
            }
        }
    }

    static class ShowDetailAction
    extends AbstractAction {
        private final ChangesetCacheManagerModel model;

        ShowDetailAction(ChangesetCacheManagerModel changesetCacheManagerModel) {
            this.model = changesetCacheManagerModel;
        }

        protected void showDetails() {
            List<Changeset> list = this.model.getSelectedChangesets();
            if (list.size() == 1) {
                this.model.setChangesetInDetailView(list.get(0));
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.showDetails();
        }
    }

    static class DownloadSelectedChangesetContentAction
    extends AbstractAction
    implements ListSelectionListener {
        private final ChangesetCacheManagerModel model;

        DownloadSelectedChangesetContentAction(ChangesetCacheManagerModel changesetCacheManagerModel) {
            this.putValue("Name", I18n.tr("Download changeset content", new Object[0]));
            new ImageProvider("dialogs/changeset", "downloadchangesetcontent").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Download the content of the selected changesets from the server", new Object[0]));
            this.model = changesetCacheManagerModel;
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!GraphicsEnvironment.isHeadless()) {
                ChangesetCacheManager.getInstance().runDownloadTask(new ChangesetContentDownloadTask((Component)GuiHelper.getWindowAncestorFor(actionEvent), this.model.getSelectedChangesetIds()));
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(this.model.hasSelectedChangesets() && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class DownloadSelectedChangesetsAction
    extends AbstractAction
    implements ListSelectionListener {
        private final ChangesetCacheManagerModel model;

        DownloadSelectedChangesetsAction(ChangesetCacheManagerModel changesetCacheManagerModel) {
            this.putValue("Name", I18n.tr("Update changeset", new Object[0]));
            new ImageProvider("dialogs/changeset", "updatechangeset").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Updates the selected changesets with current data from the OSM server", new Object[0]));
            this.model = changesetCacheManagerModel;
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!GraphicsEnvironment.isHeadless()) {
                ChangesetCacheManager.getInstance().runDownloadTask(ChangesetHeaderDownloadTask.buildTaskForChangesets(GuiHelper.getWindowAncestorFor(actionEvent), this.model.getSelectedChangesets()));
            }
        }

        protected void updateEnabledState() {
            this.setEnabled(this.model.hasSelectedChangesets() && !Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class CloseSelectedChangesetsAction
    extends AbstractAction
    implements ListSelectionListener {
        private final ChangesetCacheManagerModel model;

        CloseSelectedChangesetsAction(ChangesetCacheManagerModel changesetCacheManagerModel) {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            new ImageProvider("closechangeset").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Close the selected changesets", new Object[0]));
            this.model = changesetCacheManagerModel;
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Main.worker.submit(new CloseChangesetTask(this.model.getSelectedChangesets()));
        }

        protected void updateEnabledState() {
            List<Changeset> list = this.model.getSelectedChangesets();
            JosmUserIdentityManager josmUserIdentityManager = JosmUserIdentityManager.getInstance();
            for (Changeset changeset : list) {
                if (!changeset.isOpen()) continue;
                if (josmUserIdentityManager.isPartiallyIdentified() && changeset.getUser() != null && changeset.getUser().getName().equals(josmUserIdentityManager.getUserName())) {
                    this.setEnabled(true);
                    return;
                }
                if (!josmUserIdentityManager.isFullyIdentified() || changeset.getUser() == null || changeset.getUser().getId() != (long)josmUserIdentityManager.getUserId()) continue;
                this.setEnabled(true);
                return;
            }
            this.setEnabled(false);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class RemoveFromCacheAction
    extends AbstractAction
    implements ListSelectionListener {
        private final ChangesetCacheManagerModel model;

        RemoveFromCacheAction(ChangesetCacheManagerModel changesetCacheManagerModel) {
            this.putValue("Name", I18n.tr("Remove from cache", new Object[0]));
            new ImageProvider("dialogs", "delete").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Remove the selected changesets from the local cache", new Object[0]));
            this.model = changesetCacheManagerModel;
            this.updateEnabledState();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ChangesetCache.getInstance().remove(this.model.getSelectedChangesets());
        }

        protected void updateEnabledState() {
            this.setEnabled(this.model.hasSelectedChangesets());
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }
    }

    static class QueryAction
    extends AbstractAction {
        QueryAction() {
            this.putValue("Name", I18n.tr("Query", new Object[0]));
            new ImageProvider("dialogs", "search").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Launch the dialog for querying changesets", new Object[0]));
            this.setEnabled(!Main.isOffline(OnlineResource.OSM_API));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Window window = GuiHelper.getWindowAncestorFor(actionEvent);
            if (!GraphicsEnvironment.isHeadless()) {
                ChangesetQueryDialog changesetQueryDialog = new ChangesetQueryDialog(window);
                changesetQueryDialog.initForUserInput();
                changesetQueryDialog.setVisible(true);
                if (changesetQueryDialog.isCanceled()) {
                    return;
                }
                try {
                    ChangesetQuery changesetQuery = changesetQueryDialog.getChangesetQuery();
                    if (changesetQuery != null) {
                        ChangesetCacheManager.getInstance().runDownloadTask(new ChangesetQueryTask(window, changesetQuery));
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    JOptionPane.showMessageDialog(window, illegalStateException.getMessage(), I18n.tr("Error", new Object[0]), 0);
                }
            }
        }
    }

    static class CancelAction
    extends AbstractAction {
        CancelAction() {
            this.putValue("Name", I18n.tr("Close", new Object[0]));
            new ImageProvider("cancel").getResource().attachImageIcon(this);
            this.putValue("ShortDescription", I18n.tr("Close the dialog", new Object[0]));
        }

        public void cancelAndClose() {
            ChangesetCacheManager.destroyInstance();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.cancelAndClose();
        }
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            new CancelAction().cancelAndClose();
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (ChangesetCacheManager.this.needsSplitPaneAdjustment) {
                ChangesetCacheManager.this.spContent.setDividerLocation(0.5);
                ChangesetCacheManager.this.needsSplitPaneAdjustment = false;
            }
        }
    }
}

