/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.actions;

import java.awt.event.ActionEvent;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.dialogs.relation.IRelationEditor;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTable;
import org.openstreetmap.josm.gui.dialogs.relation.MemberTableModel;
import org.openstreetmap.josm.gui.dialogs.relation.actions.SavingAction;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.tagging.TagEditorModel;
import org.openstreetmap.josm.gui.tagging.ac.AutoCompletingTextField;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class CancelAction
extends SavingAction {
    public CancelAction(MemberTable memberTable, MemberTableModel memberTableModel, TagEditorModel tagEditorModel, OsmDataLayer osmDataLayer, IRelationEditor iRelationEditor, AutoCompletingTextField autoCompletingTextField) {
        super(memberTable, memberTableModel, tagEditorModel, osmDataLayer, iRelationEditor, autoCompletingTextField);
        this.putValue("ShortDescription", I18n.tr("Cancel the updates and close the dialog", new Object[0]));
        new ImageProvider("cancel").getResource().attachImageIcon(this);
        this.putValue("Name", I18n.tr("Cancel", new Object[0]));
        if (iRelationEditor instanceof RootPaneContainer) {
            JRootPane jRootPane = ((RootPaneContainer)((Object)iRelationEditor)).getRootPane();
            jRootPane.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
            jRootPane.getActionMap().put("ESCAPE", this);
        }
        this.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.memberTable.stopHighlighting();
        Relation relation = this.editor.getRelationSnapshot();
        if (!(this.memberTableModel.hasSameMembersAs(relation) && !this.tagModel.isDirty() || relation == null && this.tagModel.getTags().isEmpty())) {
            int n = this.confirmClosingByCancel();
            if (n == 0) {
                Main.pref.put("relation.editor.generic.lastrole", this.tfRole.getText());
                if (!this.applyChanges()) {
                    return;
                }
            } else if (n == 2 || n == -1) {
                return;
            }
        }
        this.hideEditor();
    }

    protected int confirmClosingByCancel() {
        HelpAwareOptionPane.ButtonSpec[] buttonSpecArray = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Yes, save the changes and close", new Object[0]), ImageProvider.get("ok"), I18n.tr("Click to save the changes and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("No, discard the changes and close", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to discard the changes and close this relation editor", new Object[0]), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel, continue editing", new Object[0]), ImageProvider.get("cancel"), I18n.tr("Click to return to the relation editor and to resume relation editing", new Object[0]), null)};
        return HelpAwareOptionPane.showOptionDialog(Main.parent, I18n.tr("<html>The relation has been changed.<br><br>Do you want to save your changes?</html>", new Object[0]), I18n.tr("Unsaved changes", new Object[0]), 2, null, buttonSpecArray, buttonSpecArray[0], "/Dialog/RelationEditor#DiscardChanges");
    }
}

