/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.util.GuiHelper;

public class MainLayerManager
extends LayerManager {
    private Layer activeLayer;
    private OsmDataLayer editLayer;
    private final List<ActiveLayerChangeListener> activeLayerChangeListeners = new CopyOnWriteArrayList<ActiveLayerChangeListener>();
    private final List<LayerAvailabilityListener> layerAvailabilityListeners = new CopyOnWriteArrayList<LayerAvailabilityListener>();

    @Deprecated
    public synchronized void addActiveLayerChangeListener(ActiveLayerChangeListener activeLayerChangeListener, boolean bl) {
        if (bl) {
            this.addAndFireActiveLayerChangeListener(activeLayerChangeListener);
        } else {
            this.addActiveLayerChangeListener(activeLayerChangeListener);
        }
    }

    public synchronized void addActiveLayerChangeListener(ActiveLayerChangeListener activeLayerChangeListener) {
        if (this.activeLayerChangeListeners.contains(activeLayerChangeListener)) {
            throw new IllegalArgumentException("Attempted to add listener that was already in list: " + activeLayerChangeListener);
        }
        this.activeLayerChangeListeners.add(activeLayerChangeListener);
    }

    public synchronized void addAndFireActiveLayerChangeListener(ActiveLayerChangeListener activeLayerChangeListener) {
        this.addActiveLayerChangeListener(activeLayerChangeListener);
        activeLayerChangeListener.activeOrEditLayerChanged(new ActiveLayerChangeEvent(this, null, null));
    }

    public synchronized void removeActiveLayerChangeListener(ActiveLayerChangeListener activeLayerChangeListener) {
        if (!this.activeLayerChangeListeners.contains(activeLayerChangeListener)) {
            throw new IllegalArgumentException("Attempted to remove listener that was not in list: " + activeLayerChangeListener);
        }
        this.activeLayerChangeListeners.remove(activeLayerChangeListener);
    }

    public synchronized void addLayerAvailabilityListener(LayerAvailabilityListener layerAvailabilityListener) {
        if (!this.layerAvailabilityListeners.add(layerAvailabilityListener)) {
            throw new IllegalArgumentException("Attempted to add listener that was already in list: " + layerAvailabilityListener);
        }
    }

    public synchronized void removeLayerAvailabilityListener(LayerAvailabilityListener layerAvailabilityListener) {
        if (!this.layerAvailabilityListeners.remove(layerAvailabilityListener)) {
            throw new IllegalArgumentException("Attempted to remove listener that was not in list: " + layerAvailabilityListener);
        }
    }

    public void setActiveLayer(final Layer layer) {
        GuiHelper.runInEDTAndWaitWithException(new Runnable(){

            @Override
            public void run() {
                MainLayerManager.this.realSetActiveLayer(layer);
            }
        });
    }

    protected synchronized void realSetActiveLayer(Layer layer) {
        this.checkContainsLayer(layer);
        this.setActiveLayer(layer, false);
    }

    private void setActiveLayer(Layer layer, boolean bl) {
        ActiveLayerChangeEvent activeLayerChangeEvent = new ActiveLayerChangeEvent(this, this.editLayer, this.activeLayer);
        this.activeLayer = layer;
        if (this.activeLayer instanceof OsmDataLayer) {
            this.editLayer = (OsmDataLayer)this.activeLayer;
        } else if (bl) {
            this.editLayer = null;
        }
        this.fireActiveLayerChange(activeLayerChangeEvent);
    }

    private void fireActiveLayerChange(ActiveLayerChangeEvent activeLayerChangeEvent) {
        GuiHelper.assertCallFromEdt();
        if (activeLayerChangeEvent.getPreviousActiveLayer() != this.activeLayer || activeLayerChangeEvent.getPreviousEditLayer() != this.editLayer) {
            for (ActiveLayerChangeListener activeLayerChangeListener : this.activeLayerChangeListeners) {
                activeLayerChangeListener.activeOrEditLayerChanged(activeLayerChangeEvent);
            }
        }
    }

    @Override
    protected synchronized void realAddLayer(Layer layer) {
        if (this.getLayers().isEmpty()) {
            LayerAvailabilityEvent layerAvailabilityEvent = new LayerAvailabilityEvent(this, true);
            for (LayerAvailabilityListener layerAvailabilityListener : this.layerAvailabilityListeners) {
                layerAvailabilityListener.beforeFirstLayerAdded(layerAvailabilityEvent);
            }
        }
        super.realAddLayer(layer);
        if (layer instanceof OsmDataLayer || this.activeLayer == null) {
            this.setActiveLayer(layer);
        }
    }

    @Override
    protected Collection<Layer> realRemoveSingleLayer(Layer layer) {
        Object object;
        if (layer == this.activeLayer || layer == this.editLayer) {
            object = this.suggestNextActiveLayer(layer);
            this.setActiveLayer((Layer)object, true);
        }
        object = super.realRemoveSingleLayer(layer);
        if (this.getLayers().isEmpty()) {
            LayerAvailabilityEvent layerAvailabilityEvent = new LayerAvailabilityEvent(this, false);
            for (LayerAvailabilityListener layerAvailabilityListener : this.layerAvailabilityListeners) {
                layerAvailabilityListener.afterLastLayerRemoved(layerAvailabilityEvent);
            }
        }
        return object;
    }

    private Layer suggestNextActiveLayer(Layer layer) {
        ArrayList<Layer> arrayList = new ArrayList<Layer>(this.getLayers());
        arrayList.remove(layer);
        for (Layer layer2 : arrayList) {
            if (!(layer2 instanceof OsmDataLayer)) continue;
            return layer2;
        }
        if (!arrayList.isEmpty()) {
            return (Layer)arrayList.get(0);
        }
        return null;
    }

    public synchronized Layer getActiveLayer() {
        return this.activeLayer;
    }

    public synchronized OsmDataLayer getEditLayer() {
        return this.editLayer;
    }

    public synchronized DataSet getEditDataSet() {
        if (this.editLayer != null) {
            return this.editLayer.data;
        }
        return null;
    }

    public synchronized List<Layer> getVisibleLayersInZOrder() {
        ArrayList<Layer> arrayList = new ArrayList<Layer>();
        boolean bl = false;
        List<Layer> list = this.getLayers();
        ListIterator<Layer> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            Layer layer = listIterator.previous();
            if (!layer.isVisible()) continue;
            if (layer == this.activeLayer && layer instanceof OsmDataLayer) {
                bl = true;
                continue;
            }
            if (bl && !(layer instanceof OsmDataLayer)) {
                arrayList.add(this.activeLayer);
                bl = false;
            }
            arrayList.add(layer);
        }
        if (bl) {
            arrayList.add(this.activeLayer);
        }
        return arrayList;
    }

    @Override
    public void resetState() {
        super.resetState();
        this.activeLayerChangeListeners.clear();
        this.layerAvailabilityListeners.clear();
    }

    public static interface LayerAvailabilityListener {
        public void beforeFirstLayerAdded(LayerAvailabilityEvent var1);

        public void afterLastLayerRemoved(LayerAvailabilityEvent var1);
    }

    public class LayerAvailabilityEvent
    extends LayerManager.LayerManagerEvent {
        private final boolean hasLayers;

        LayerAvailabilityEvent(LayerManager layerManager, boolean bl) {
            super(layerManager);
            this.hasLayers = bl;
        }

        public boolean hasLayers() {
            return this.hasLayers;
        }
    }

    public class ActiveLayerChangeEvent
    extends LayerManager.LayerManagerEvent {
        private final OsmDataLayer previousEditLayer;
        private final Layer previousActiveLayer;

        ActiveLayerChangeEvent(MainLayerManager mainLayerManager2, OsmDataLayer osmDataLayer, Layer layer) {
            super(mainLayerManager2);
            this.previousEditLayer = osmDataLayer;
            this.previousActiveLayer = layer;
        }

        public OsmDataLayer getPreviousEditLayer() {
            return this.previousEditLayer;
        }

        public Layer getPreviousActiveLayer() {
            return this.previousActiveLayer;
        }

        public DataSet getPreviousEditDataSet() {
            if (this.previousEditLayer != null) {
                return this.previousEditLayer.data;
            }
            return null;
        }

        @Override
        public MainLayerManager getSource() {
            return (MainLayerManager)super.getSource();
        }
    }

    public static interface ActiveLayerChangeListener {
        public void activeOrEditLayerChanged(ActiveLayerChangeEvent var1);
    }
}

