/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.markerlayer.AudioMarker;
import org.openstreetmap.josm.gui.layer.markerlayer.MarkerLayer;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.tools.AudioUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.template_engine.TemplateEngineDataProvider;

public class ImportAudioAction
extends AbstractAction {
    private final transient GpxLayer layer;

    public ImportAudioAction(GpxLayer gpxLayer) {
        super(I18n.tr("Import Audio", new Object[0]), ImageProvider.get("importaudio"));
        this.layer = gpxLayer;
        this.putValue("help", HelpUtil.ht("/Action/ImportAudio"));
    }

    private static void warnCantImportIntoServerLayer(GpxLayer gpxLayer) {
        String string = I18n.tr("<html>The data in the GPX layer ''{0}'' has been downloaded from the server.<br>Because its way points do not include a timestamp we cannot correlate them with audio data.</html>", gpxLayer.getName());
        HelpAwareOptionPane.showOptionDialog(Main.parent, string, I18n.tr("Import not possible", new Object[0]), 2, HelpUtil.ht("/Action/ImportAudio#CantImportIntoGpxLayerFromServer"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.layer.data.fromServer) {
            ImportAudioAction.warnCantImportIntoServerLayer(this.layer);
            return;
        }
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || Utils.hasExtension(file, "wav");
            }

            @Override
            public String getDescription() {
                return I18n.tr("Wave Audio files (*.wav)", new Object[0]);
            }
        };
        AbstractFileChooser abstractFileChooser = DiskAccessAction.createAndOpenFileChooser(true, true, null, fileFilter, 0, "markers.lastaudiodirectory");
        if (abstractFileChooser != null) {
            File[] fileArray = abstractFileChooser.getSelectedFiles();
            if (fileArray.length > 1) {
                Arrays.sort(fileArray, new Comparator<File>(){

                    @Override
                    public int compare(File file, File file2) {
                        return file.lastModified() <= file2.lastModified() ? -1 : 1;
                    }
                });
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (File file : fileArray) {
                if (stringBuilder.length() == 0) {
                    stringBuilder.append(" (");
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(file.getName());
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append(')');
            }
            MarkerLayer markerLayer = new MarkerLayer(new GpxData(), I18n.tr("Audio markers from {0}", this.layer.getName()) + stringBuilder, this.layer.getAssociatedFile(), this.layer);
            double d = (double)fileArray[0].lastModified() / 1000.0 - AudioUtil.getCalibratedDuration(fileArray[0]);
            Markers markers = new Markers();
            for (File file : fileArray) {
                this.importAudio(file, markerLayer, d, markers);
            }
            Main.getLayerManager().addLayer(markerLayer);
            Main.map.repaint();
        }
    }

    private void importAudio(File file, MarkerLayer markerLayer, double d, Markers markers) {
        WayPoint wayPoint;
        WayPoint wayPoint2;
        URL uRL = Utils.fileToURL(file);
        boolean bl = this.layer.data.tracks != null && !this.layer.data.tracks.isEmpty();
        boolean bl2 = this.layer.data.waypoints != null && !this.layer.data.waypoints.isEmpty();
        ArrayList<WayPoint> arrayList = new ArrayList<WayPoint>();
        boolean bl3 = false;
        boolean bl4 = false;
        double d2 = Main.pref.getDouble("marker.audiofromuntimedwaypoints.distance", 0.001);
        WayPoint wayPoint3 = null;
        double d3 = -1.0;
        if (bl) {
            for (GpxTrack object2 : this.layer.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : object2.getSegments()) {
                    Iterator<WayPoint> iterator = gpxTrackSegment.getWayPoints().iterator();
                    if (iterator.hasNext()) {
                        WayPoint wayPoint4 = iterator.next();
                        d3 = wayPoint4.time;
                    }
                    if (!(d3 >= 0.0)) continue;
                    break;
                }
                if (!(d3 >= 0.0)) continue;
                break;
            }
        }
        if (d3 < 0.0) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No GPX track available in layer to associate audio with.", new Object[0]), I18n.tr("Error", new Object[0]), 0);
            return;
        }
        if (Main.pref.getBoolean("marker.audiofromexplicitwaypoints", true) && bl2) {
            for (WayPoint wayPoint5 : this.layer.data.waypoints) {
                if (wayPoint5.time > d3) {
                    arrayList.add(wayPoint5);
                    continue;
                }
                if (!(wayPoint5.time > 0.0)) continue;
                bl3 = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromuntimedwaypoints", true) && bl2) {
            for (WayPoint wayPoint6 : this.layer.data.waypoints) {
                if (arrayList.contains(wayPoint6)) continue;
                WayPoint wayPoint7 = this.layer.data.nearestPointOnTrack(wayPoint6.getEastNorth(), d2);
                if (wayPoint7 != null) {
                    WayPoint wayPoint8 = new WayPoint(wayPoint6.getCoor());
                    wayPoint8.time = wayPoint7.time;
                    if (wayPoint6.attr.containsKey("name")) {
                        wayPoint8.put("name", wayPoint6.getString("name"));
                    }
                    arrayList.add(wayPoint8);
                    continue;
                }
                bl4 = true;
            }
        }
        if (Main.pref.getBoolean("marker.audiofromnamedtrackpoints", false) && this.layer.data.tracks != null && !this.layer.data.tracks.isEmpty()) {
            for (GpxTrack gpxTrack : this.layer.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    for (WayPoint wayPoint9 : gpxTrackSegment.getWayPoints()) {
                        if (!wayPoint9.attr.containsKey("name") && !wayPoint9.attr.containsKey("desc")) continue;
                        arrayList.add(wayPoint9);
                    }
                }
            }
        }
        if (Main.pref.getBoolean("marker.audiofromwavtimestamps", false) && bl) {
            double d4 = (double)file.lastModified() / 1000.0;
            double d5 = AudioUtil.getCalibratedDuration(file);
            double d6 = d4 - d5;
            d6 = d + (d6 - d) / Main.pref.getDouble("audio.calibration", 1.0);
            wayPoint2 = null;
            wayPoint = null;
            block7: for (GpxTrack gpxTrack : this.layer.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    for (WayPoint wayPoint10 : gpxTrackSegment.getWayPoints()) {
                        if (d6 < wayPoint10.time) {
                            wayPoint = wayPoint10;
                            break;
                        }
                        wayPoint2 = wayPoint10;
                    }
                    if (wayPoint == null) continue;
                    continue block7;
                }
            }
            if (wayPoint2 == null || wayPoint == null) {
                bl3 = true;
            } else {
                wayPoint3 = new WayPoint(wayPoint2.getCoor().interpolate(wayPoint.getCoor(), (d6 - wayPoint2.time) / (wayPoint.time - wayPoint2.time)));
                wayPoint3.time = d6;
                Object object = file.getName();
                int n = ((String)object).lastIndexOf(46);
                if (n > 0) {
                    object = ((String)object).substring(0, n);
                }
                wayPoint3.put("name", object);
                arrayList.add(wayPoint3);
            }
        }
        if ((Main.pref.getBoolean("marker.audiofromstart") || arrayList.isEmpty()) && bl) {
            boolean bl5 = false;
            for (GpxTrack gpxTrack : this.layer.data.tracks) {
                for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                    Iterator<WayPoint> iterator = gpxTrackSegment.getWayPoints().iterator();
                    if (iterator.hasNext()) {
                        wayPoint2 = iterator.next();
                        wayPoint = new WayPoint(wayPoint2.getCoor());
                        wayPoint.put("name", "start");
                        wayPoint.time = wayPoint2.time;
                        arrayList.add(wayPoint);
                        bl5 = true;
                    }
                    if (!bl5) continue;
                    break;
                }
                if (!bl5) continue;
                break;
            }
        }
        Collections.sort(arrayList, new Comparator<WayPoint>(){

            @Override
            public int compare(WayPoint wayPoint, WayPoint wayPoint2) {
                return wayPoint.time <= wayPoint2.time ? -1 : 1;
            }
        });
        d3 = -1.0;
        for (WayPoint wayPoint11 : arrayList) {
            if (d3 < 0.0) {
                d3 = wayPoint11.time;
            }
            double d7 = wayPoint11.time - d3;
            AudioMarker audioMarker = new AudioMarker(wayPoint11.getCoor(), (TemplateEngineDataProvider)wayPoint11, uRL, markerLayer, wayPoint11.time, d7);
            if (wayPoint11 == wayPoint3) {
                audioMarker.timeFromAudio = true;
            }
            markerLayer.data.add(audioMarker);
        }
        if (bl3 && !markers.timedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints with timestamps from before the start of the track or after the end were omitted or moved to the start.", new Object[0]));
            markers.timedMarkersOmitted = bl3;
        }
        if (bl4 && !markers.untimedMarkersOmitted) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("Some waypoints which were too far from the track to sensibly estimate their time were omitted.", new Object[0]));
            markers.untimedMarkersOmitted = bl4;
        }
    }

    private static class Markers {
        public boolean timedMarkersOmitted;
        public boolean untimedMarkersOmitted;

        private Markers() {
        }
    }
}

