/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;

@NodeChild(value="child", type=RubyNode.class)
public abstract class ToStrNode
extends RubyNode {
    @Node.Child
    private CallDispatchHeadNode toStrNode;

    public ToStrNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
        this.toStrNode = DispatchHeadNodeFactory.createMethodCall(context);
    }

    public abstract DynamicObject executeToStr(VirtualFrame var1, Object var2);

    @Specialization(guards={"isRubyString(string)"})
    public DynamicObject coerceRubyString(DynamicObject string) {
        return string;
    }

    @Specialization(guards={"!isRubyString(object)"})
    public DynamicObject coerceObject(VirtualFrame frame, Object object, @Cached(value="create()") BranchProfile errorProfile) {
        Object coerced;
        try {
            coerced = this.toStrNode.call(frame, object, "to_str", null, new Object[0]);
        }
        catch (RaiseException e) {
            if (Layouts.BASIC_OBJECT.getLogicalClass(e.getException()) == this.coreLibrary().getNoMethodErrorClass()) {
                errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorNoImplicitConversion(object, "String", this));
            }
            throw e;
        }
        if (RubyGuards.isRubyString(coerced)) {
            return (DynamicObject)coerced;
        }
        errorProfile.enter();
        throw new RaiseException(this.coreExceptions().typeErrorBadCoercion(object, "String", "to_str", coerced, this));
    }
}

