/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.BreakException;
import org.jruby.truffle.language.control.NextException;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.control.RedoException;
import org.jruby.truffle.language.control.RetryException;
import org.jruby.truffle.language.control.ReturnException;
import org.jruby.truffle.language.control.ReturnID;

public class CatchForLambdaNode
extends RubyNode {
    private final ReturnID returnID;
    @Node.Child
    private RubyNode body;
    private final ConditionProfile matchingReturnProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile retryProfile = BranchProfile.create();
    private final BranchProfile redoProfile = BranchProfile.create();
    private final BranchProfile nextProfile = BranchProfile.create();
    private final BranchProfile breakProfile = BranchProfile.create();

    public CatchForLambdaNode(RubyContext context, SourceSection sourceSection, ReturnID returnID, RubyNode body) {
        super(context, sourceSection);
        this.returnID = returnID;
        this.body = body;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        while (true) {
            try {
                return this.body.execute(frame);
            }
            catch (ReturnException e) {
                if (this.matchingReturnProfile.profile(e.getReturnID() == this.returnID)) {
                    return e.getValue();
                }
                throw e;
            }
            catch (RetryException e) {
                this.retryProfile.enter();
                throw new RaiseException(this.coreExceptions().syntaxErrorInvalidRetry(this));
            }
            catch (RedoException e) {
                this.redoProfile.enter();
                this.getContext().getSafepointManager().poll(this);
                continue;
            }
            catch (NextException e) {
                this.nextProfile.enter();
                return e.getResult();
            }
            catch (BreakException e) {
                this.breakProfile.enter();
                return e.getResult();
            }
            break;
        }
    }
}

