/*
 * Decompiled with CFR 0.152.
 */
package org.encog.ml.data.sparse;

import java.io.Serializable;
import org.encog.ml.data.MLData;
import org.encog.ml.data.MLDataError;
import org.encog.util.EngineArray;
import org.encog.util.kmeans.Centroid;

public class SparseMLData
implements MLData,
Serializable,
Cloneable {
    private int[] index;
    private double[] data;

    public SparseMLData(double[] d) {
        this(d.length);
        System.arraycopy(d, 0, this.data, 0, d.length);
        for (int i = 0; i < d.length; ++i) {
            this.index[i] = i;
        }
    }

    public SparseMLData(double[] d, int[] i) {
        this(d.length);
        System.arraycopy(d, 0, this.data, 0, d.length);
        EngineArray.arrayCopy(d, this.data);
        EngineArray.arrayCopy(i, this.index);
    }

    public SparseMLData(int size) {
        this.data = new double[size];
        this.index = new int[size];
    }

    public SparseMLData(MLData d) {
        this(d.size());
        if (d instanceof SparseMLData) {
            SparseMLData source = (SparseMLData)d;
            EngineArray.arrayCopy(source.getSparseData(), this.data);
            EngineArray.arrayCopy(source.getSparseIndex(), this.index);
        } else {
            EngineArray.arrayCopy(d.getData(), this.data);
        }
    }

    public int findIndex(int index) {
        for (int i = 0; i < this.index.length; ++i) {
            if (this.index[i] != index) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void add(int index, double value) {
        int i = this.findIndex(index);
        if (i == -1) {
            throw new MLDataError("Can't find sparse index: " + index);
        }
        int n = index;
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = 0.0;
        }
    }

    @Override
    public MLData clone() {
        return new SparseMLData(this);
    }

    @Override
    public double[] getData() {
        throw new MLDataError("Can't directly access the data array of a SparseMLData object");
    }

    @Override
    public double getData(int index) {
        int i = this.findIndex(index);
        if (i == -1) {
            throw new MLDataError("Can't find sparse index: " + index);
        }
        return this.data[i];
    }

    @Override
    public void setData(double[] theData) {
        throw new MLDataError("Can't directly access the data array of a SparseMLData object");
    }

    @Override
    public void setData(int index, double d) {
        int i = this.findIndex(index);
        if (i == -1) {
            throw new MLDataError("Can't find sparse index: " + index);
        }
        this.data[i] = d;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("[");
        builder.append(this.getClass().getSimpleName());
        builder.append(":");
        for (int i = 0; i < this.data.length; ++i) {
            if (i != 0) {
                builder.append(',');
            }
            builder.append(this.index[i]);
            builder.append(':');
            builder.append(this.data[i]);
        }
        builder.append("]");
        return builder.toString();
    }

    public int[] getSparseIndex() {
        return this.index;
    }

    public double[] getSparseData() {
        return this.data;
    }

    @Override
    public Centroid<MLData> createCentroid() {
        return null;
    }
}

