/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.neat.training;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.encog.neural.neat.NEATPopulation;
import org.encog.neural.neat.training.NEATInnovation;

public class NEATInnovationList
implements Serializable {
    private static final long serialVersionUID = 1L;
    private NEATPopulation population;
    private Map<String, NEATInnovation> list = new HashMap<String, NEATInnovation>();

    public NEATInnovationList() {
    }

    public static String produceKeyNeuron(long id) {
        StringBuilder result = new StringBuilder();
        result.append("n:");
        result.append(id);
        return result.toString();
    }

    public static String produceKeyNeuronSplit(long fromID, long toID) {
        StringBuilder result = new StringBuilder();
        result.append("ns:");
        result.append(fromID);
        result.append(":");
        result.append(toID);
        return result.toString();
    }

    public static String produceKeyLink(long fromID, long toID) {
        StringBuilder result = new StringBuilder();
        result.append("l:");
        result.append(fromID);
        result.append(":");
        result.append(toID);
        return result.toString();
    }

    public NEATInnovationList(NEATPopulation population) {
        int i;
        this.population = population;
        this.findInnovation(this.population.assignGeneID());
        for (i = 0; i < population.getInputCount(); ++i) {
            this.findInnovation(this.population.assignGeneID());
        }
        for (i = 0; i < population.getOutputCount(); ++i) {
            this.findInnovation(this.population.assignGeneID());
        }
        for (long fromID = 0L; fromID < (long)(this.population.getInputCount() + 1); ++fromID) {
            for (long toID = 0L; toID < (long)this.population.getOutputCount(); ++toID) {
                this.findInnovation(fromID, toID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NEATInnovation findInnovationSplit(long fromID, long toID) {
        String key = NEATInnovationList.produceKeyNeuronSplit(fromID, toID);
        Map<String, NEATInnovation> map = this.list;
        synchronized (map) {
            if (this.list.containsKey(key)) {
                return this.list.get(key);
            }
            long neuronID = this.population.assignGeneID();
            NEATInnovation innovation = new NEATInnovation();
            innovation.setInnovationID(this.population.assignInnovationID());
            innovation.setNeuronID(neuronID);
            this.list.put(key, innovation);
            this.findInnovation(fromID, neuronID);
            this.findInnovation(neuronID, toID);
            return innovation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NEATInnovation findInnovation(long neuronID) {
        String key = NEATInnovationList.produceKeyNeuron(neuronID);
        Map<String, NEATInnovation> map = this.list;
        synchronized (map) {
            if (this.list.containsKey(key)) {
                return this.list.get(key);
            }
            NEATInnovation innovation = new NEATInnovation();
            innovation.setInnovationID(this.population.assignInnovationID());
            innovation.setNeuronID(neuronID);
            this.list.put(key, innovation);
            return innovation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NEATInnovation findInnovation(long fromID, long toID) {
        String key = NEATInnovationList.produceKeyLink(fromID, toID);
        Map<String, NEATInnovation> map = this.list;
        synchronized (map) {
            if (this.list.containsKey(key)) {
                return this.list.get(key);
            }
            NEATInnovation innovation = new NEATInnovation();
            innovation.setInnovationID(this.population.assignInnovationID());
            innovation.setNeuronID(-1L);
            this.list.put(key, innovation);
            return innovation;
        }
    }

    public void setPopulation(NEATPopulation population) {
        this.population = population;
    }

    public Map<String, NEATInnovation> getInnovations() {
        return this.list;
    }
}

