/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.profiling.presets;

import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.application.jvm.Jvm;
import com.sun.tools.visualvm.application.jvm.JvmFactory;
import com.sun.tools.visualvm.application.type.ApplicationTypeFactory;
import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import com.sun.tools.visualvm.profiling.presets.PresetSelector;
import com.sun.tools.visualvm.profiling.presets.ProfilerPreset;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.prefs.Preferences;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import org.netbeans.api.options.OptionsDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class ProfilerPresets {
    private static final String JAR_SUFFIX = ".jar";
    private static final String OPTIONS_HANDLE = "ProfilerOptions";
    private static final String PROP_PRESET_HEADER = "prof_preset_header";
    private static ProfilerPresets INSTANCE;
    private Preferences prefs;
    private List<ProfilerPreset> presets = new ArrayList<ProfilerPreset>();
    private ProfilerPreset presetToSelect;
    private ProfilerPreset presetToCreate;
    private final Set<WeakReference<PresetSelector>> selectors = new HashSet<WeakReference<PresetSelector>>();

    public static synchronized ProfilerPresets getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProfilerPresets();
        }
        return INSTANCE;
    }

    public void editPresets(ProfilerPreset preset) {
        this.presetToSelect = preset;
        OptionsDisplayer.getDefault().open(OPTIONS_HANDLE);
    }

    ProfilerPreset presetToSelect() {
        ProfilerPreset toSelect = this.presetToSelect;
        this.presetToSelect = null;
        return toSelect;
    }

    public void savePreset(ProfilerPreset preset) {
        this.presetToCreate = preset;
        OptionsDisplayer.getDefault().open(OPTIONS_HANDLE);
    }

    ProfilerPreset presetToCreate() {
        ProfilerPreset toCreate = this.presetToCreate;
        this.presetToCreate = null;
        return toCreate;
    }

    void optionsSubmitted(final ProfilerPreset selected) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Iterator selectorsI = ProfilerPresets.this.selectors.iterator();
                while (selectorsI.hasNext()) {
                    WeakReference selectorR = (WeakReference)selectorsI.next();
                    PresetSelector selector = (PresetSelector)selectorR.get();
                    if (selector == null) {
                        selectorsI.remove();
                        continue;
                    }
                    if (SwingUtilities.getRoot(selector) == null) {
                        selectorsI.remove();
                        continue;
                    }
                    selector.presetsChanged(selected);
                }
            }
        });
    }

    public PresetSelector createSelector(PresetSelector refSelector, Runnable presetSync) {
        return this.createSelector(null, refSelector, presetSync);
    }

    public PresetSelector createSelector(Application application, PresetSelector refSelector, Runnable presetSync) {
        String mainClass = null;
        if (application != null) {
            mainClass = ProfilerPresets.getMainClass(application);
            if (mainClass == null || mainClass.isEmpty()) {
                mainClass = ApplicationTypeFactory.getApplicationTypeFor((Application)application).getName();
            }
            if (mainClass == null || mainClass.isEmpty()) {
                mainClass = DataSourceDescriptorFactory.getDescriptor((DataSource)application).getName();
            }
        }
        ProfilerPreset toSelect = null;
        if (mainClass != null && !mainClass.isEmpty()) {
            String mainClassL = mainClass.toLowerCase();
            for (int i = 0; i < this.presets.size(); ++i) {
                ProfilerPreset preset = this.presets.get(i);
                String selector = preset.getSelector();
                if (selector == null || selector.isEmpty() || !mainClass.equals(selector) && !mainClassL.contains(selector.toLowerCase())) continue;
                toSelect = preset;
                break;
            }
        }
        ProfilerPreset defPreset = ProfilerPresets.createDefaultPreset(application);
        ProfilerPreset custPreset = null;
        PresetSelector selector = new PresetSelector(refSelector, defPreset, custPreset, toSelect, presetSync, mainClass);
        this.selectors.add(new WeakReference<PresetSelector>(selector));
        return selector;
    }

    public ProfilerPreset[] getPresets(Application application) {
        ProfilerPreset[] presetsArr = new ProfilerPreset[this.presets.size() + 1];
        int index = 0;
        presetsArr[index++] = ProfilerPresets.createDefaultPreset(application);
        for (ProfilerPreset preset : this.presets) {
            presetsArr[index++] = preset;
        }
        return presetsArr;
    }

    private void loadPresets() {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                final List loadedPresets = ProfilerPresets.this.doLoadPresets();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerPresets.this.presets.clear();
                        ProfilerPresets.this.presets.addAll(loadedPresets);
                    }
                });
            }
        });
    }

    void savePresets(final PresetsModel toSave) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProfilerPresets.this.presets.clear();
                Enumeration en = toSave.elements();
                while (en.hasMoreElements()) {
                    ProfilerPresets.this.presets.add((ProfilerPreset)en.nextElement());
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        ProfilerPresets.this.doSavePresets(toSave);
                    }
                });
            }
        });
    }

    PresetsModel getPresets() {
        PresetsModel model = new PresetsModel();
        for (ProfilerPreset preset : this.presets) {
            model.addElement(preset);
        }
        return model;
    }

    private static ProfilerPreset createDefaultPreset(Application application) {
        ProfilerPreset defaultPreset = new ProfilerPreset(NbBundle.getMessage(ProfilerPresets.class, (String)"MSG_Default"), "");
        defaultPreset.setFilterS(ProfilerPresets.getDefaultFiltersS());
        defaultPreset.setRootsP(ProfilerPresets.getDefaultRootsP(application));
        defaultPreset.setFilterP(ProfilerPresets.getDefaultFiltersP(defaultPreset.getRootsP()));
        return defaultPreset;
    }

    private static String getMainClass(Application application) {
        Jvm jvm = JvmFactory.getJVMFor((Application)application);
        String mainClass = jvm.getMainClass();
        if (mainClass == null || mainClass.trim().length() == 0) {
            mainClass = "";
        } else if (mainClass.endsWith(JAR_SUFFIX)) {
            File jarFile;
            String args;
            int index;
            String userdir;
            Properties sysProp;
            mainClass = "";
            if (jvm.isGetSystemPropertiesSupported() && (sysProp = jvm.getSystemProperties()) != null && (userdir = sysProp.getProperty("user.dir")) != null && (index = (args = jvm.getCommandLine()).indexOf(JAR_SUFFIX)) != -1 && (jarFile = new File(userdir, args.substring(0, index + JAR_SUFFIX.length()))).exists()) {
                try {
                    JarFile jf = new JarFile(jarFile);
                    String mainClassName = jf.getManifest().getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                    assert (mainClassName != null);
                    mainClass = mainClassName.replace('\\', '/').replace('/', '.');
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        return mainClass;
    }

    private static String getDefaultFiltersS() {
        return Utilities.isMac() ? "java.*, javax.*,\nsun.*, sunw.*, com.sun.*,\ncom.apple.*, apple.awt.*, apple.laf.*" : "java.*, javax.*,\nsun.*, sunw.*, com.sun.*";
    }

    private static String getDefaultRootsP(Application application) {
        if (application == null) {
            return NbBundle.getMessage(ProfilerPresets.class, (String)"HINT_Define_roots");
        }
        String mainClass = ProfilerPresets.getMainClass(application);
        if ("".equals(mainClass)) {
            return NbBundle.getMessage(ProfilerPresets.class, (String)"HINT_Define_roots");
        }
        int dotIndex = mainClass.lastIndexOf(".");
        if (dotIndex == -1) {
            return mainClass;
        }
        return mainClass.substring(0, dotIndex + 1) + "**";
    }

    private static String getDefaultFiltersP(String defaultRoots) {
        if (defaultRoots.isEmpty()) {
            return !Utilities.isMac() ? "sun.*, sunw.*, com.sun.*" : "sun.*, sunw.*, com.sun.*,\ncom.apple.*, apple.awt.*, apple.laf.*";
        }
        return !Utilities.isMac() ? "java.*, javax.*,\nsun.*, sunw.*, com.sun.*" : "java.*, javax.*,\nsun.*, sunw.*, com.sun.*,\ncom.apple.*, apple.awt.*, apple.laf.*";
    }

    private List<ProfilerPreset> doLoadPresets() {
        Preferences p = this.prefs();
        ArrayList<ProfilerPreset> loadedPresets = new ArrayList<ProfilerPreset>();
        int i = 0;
        String prefix = i + "_";
        while (p.get(prefix + PROP_PRESET_HEADER, null) != null) {
            loadedPresets.add(new ProfilerPreset(p, prefix));
            prefix = ++i + "_";
        }
        return loadedPresets;
    }

    private void doSavePresets(PresetsModel toSave) {
        Preferences p = this.prefs();
        try {
            p.clear();
        }
        catch (Exception e) {
            // empty catch block
        }
        int count = toSave.size();
        for (int i = 0; i < count; ++i) {
            String prefix = i + "_";
            p.put(prefix + PROP_PRESET_HEADER, "");
            ProfilerPreset preset = (ProfilerPreset)toSave.get(i);
            preset.toPreferences(p, prefix);
        }
    }

    private synchronized Preferences prefs() {
        if (this.prefs == null) {
            this.prefs = NbPreferences.forModule(ProfilerPresets.class);
        }
        return this.prefs;
    }

    private ProfilerPresets() {
        this.loadPresets();
    }

    static class PresetsModel
    extends DefaultListModel {
        PresetsModel() {
        }

        void addPreset(ProfilerPreset preset) {
            this.addElement(preset);
        }

        void removePreset(int preset) {
            this.removeElementAt(preset);
        }

        void movePresetUp(int preset) {
            Object o = this.elementAt(preset);
            this.remove(preset);
            this.add(preset - 1, o);
        }

        void movePresetDown(int preset) {
            Object o = this.elementAt(preset);
            this.remove(preset);
            this.add(preset + 1, o);
        }

        public void fireItemChanged(int itemIndex) {
            this.fireContentsChanged(this, itemIndex, itemIndex);
        }
    }
}

