/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.actions;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.view.dnd.TopComponentDraggable;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public final class MoveModeAction
extends AbstractAction
implements PropertyChangeListener {
    private final ModeImpl mode;

    public MoveModeAction() {
        this((ModeImpl)null);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
    }

    public MoveModeAction(ModeImpl modeImpl) {
        this.putValue("Name", NbBundle.getMessage(ActionUtils.class, (String)"CTL_MoveModeAction"));
        this.mode = modeImpl;
        if (SwingUtilities.isEventDispatchThread()) {
            this.updateEnabled();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MoveModeAction.this.updateEnabled();
                }
            });
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.updateEnabled();
        if (!this.isEnabled()) {
            return;
        }
        ModeImpl modeImpl = this.getModeToWorkWith();
        if (null == modeImpl) {
            return;
        }
        WindowManagerImpl.getInstance().userStartedKeyboardDragAndDrop(new TopComponentDraggable(modeImpl));
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            this.updateEnabled();
        }
    }

    private void updateEnabled() {
        ModeImpl modeImpl = this.getModeToWorkWith();
        if (null == modeImpl || modeImpl.getKind() == 1 || modeImpl.getState() == 1 || null == modeImpl.getSelectedTopComponent() || WindowManagerImpl.getInstance().getCurrentMaximizedMode() != null) {
            this.setEnabled(false);
            return;
        }
        TopComponent topComponent = modeImpl.getSelectedTopComponent();
        if (null == topComponent) {
            this.setEnabled(false);
            return;
        }
        this.setEnabled(true);
    }

    private ModeImpl getModeToWorkWith() {
        if (null != this.mode) {
            return this.mode;
        }
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (null == topComponent) {
            return null;
        }
        return (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponent);
    }

    @Override
    public void putValue(String string, Object object) {
        if ("AcceleratorKey".equals(string)) {
            ActionUtils.putSharedAccelerator("MoveMode", object);
        } else {
            super.putValue(string, object);
        }
    }

    @Override
    public Object getValue(String string) {
        if ("AcceleratorKey".equals(string)) {
            return ActionUtils.getSharedAccelerator("MoveMode");
        }
        return super.getValue(string);
    }
}

