/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem currentFocusItem;
    ToolItem[] tabItemList;
    ImageList imageList;
    boolean hasChildFocus;
    static Callback menuItemSelectedFunc = new Callback(ToolBar.class, "MenuItemSelectedProc", 2);

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        this.style = (n & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int n2 = (n & 0x200) != 0 ? 1 : 0;
        OS.gtk_orientable_set_orientation(this.handle, n2);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int n) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_toolbar_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 0x800000) != 0) {
            byte[] byArray = Converter.wcsToMbcs(null, "swt-toolbar-flat", true);
            OS.gtk_widget_set_name(this.handle, byArray);
        }
        if (OS.GTK3) {
            long l = OS.gtk_widget_get_style_context(this.handle);
            OS.gtk_style_context_invalidate(l);
        }
        OS.gtk_toolbar_set_icon_size(this.handle, OS.GTK3 ? 2 : 3);
        if (OS.GTK3) {
            this.setFontDescription(this.defaultFont().handle);
        }
    }

    @Override
    int applyThemeBackground() {
        return -1;
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        this.checkWidget();
        if (n != -1 && n < 0) {
            n = 0;
        }
        if (n2 != -1 && n2 < 0) {
            n2 = 0;
        }
        OS.gtk_toolbar_set_show_arrow(this.handle, false);
        Point point = this.computeNativeSize(this.handle, n, n2, bl);
        if ((this.style & 0x40) != 0) {
            OS.gtk_toolbar_set_show_arrow(this.handle, true);
        }
        return point;
    }

    @Override
    Widget computeTabGroup() {
        int n;
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            for (n = 0; n < toolItemArray.length && toolItemArray[n].control == null; ++n) {
            }
            if (n == toolItemArray.length) {
                return super.computeTabGroup();
            }
        }
        if ((n = this.indexOf(this.currentFocusItem)) == -1) {
            n = toolItemArray.length - 1;
        }
        while (n >= 0) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.isTabGroup()) {
                return toolItem;
            }
            --n;
        }
        return super.computeTabGroup();
    }

    @Override
    Widget[] computeTabList() {
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            int n;
            for (n = 0; n < toolItemArray.length && toolItemArray[n].control == null; ++n) {
            }
            if (n == toolItemArray.length) {
                return super.computeTabList();
            }
        }
        Widget[] widgetArray = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return widgetArray;
        }
        ToolItem[] toolItemArray2 = this.tabList != null ? this._getTabItemList() : toolItemArray;
        for (int i = 0; i < toolItemArray2.length; ++i) {
            ToolItem toolItem = toolItemArray2[i];
            Widget[] widgetArray2 = toolItem.computeTabList();
            if (widgetArray2.length == 0) continue;
            Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
            System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
            System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
            widgetArray = widgetArray3;
        }
        if (widgetArray.length == 0) {
            widgetArray = new Widget[]{this};
        }
        return widgetArray;
    }

    @Override
    long eventHandle() {
        return this.fixedHandle;
    }

    @Override
    long enterExitHandle() {
        return this.handle;
    }

    @Override
    void fixChildren(Shell shell, Shell shell2, Decorations decorations, Decorations decorations2, Menu[] menuArray) {
        super.fixChildren(shell, shell2, decorations, decorations2, menuArray);
        ToolItem[] toolItemArray = this.getItems();
        if (this.toolTipText == null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem.toolTipText == null) continue;
                toolItem.setToolTipText(shell2, null);
                toolItem.setToolTipText(shell, toolItem.toolTipText);
            }
        }
    }

    @Override
    boolean forceFocus(long l) {
        int n = 0;
        if ((this.style & 0x8000000) != 0) {
            n = 1;
        }
        long l2 = this.handle;
        if (this.currentFocusItem != null) {
            l2 = this.currentFocusItem.handle;
        }
        if (OS.gtk_widget_child_focus(l2, n)) {
            return true;
        }
        return super.forceFocus(l);
    }

    public ToolItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[n];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            if (!toolItemArray[i].getBounds().contains(point)) continue;
            return toolItemArray[i];
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return 0;
        }
        int n = OS.g_list_length(l);
        OS.g_list_free(l);
        return n;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        long l = OS.gtk_container_get_children(this.handle);
        if (l == 0L) {
            return new ToolItem[0];
        }
        int n = OS.g_list_length(l);
        ToolItem[] toolItemArray = new ToolItem[n];
        long l2 = l;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l3 = OS.g_list_data(l);
            Widget widget = this.display.getWidget(l3);
            if (widget != null) {
                toolItemArray[n2++] = (ToolItem)widget;
            }
            l = OS.g_list_next(l);
        }
        OS.g_list_free(l2);
        if (n2 != toolItemArray.length) {
            ToolItem[] toolItemArray2 = new ToolItem[n2];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, n2);
            toolItemArray = toolItemArray2;
        }
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int n = 0;
        for (int i = 0; i < this.tabItemList.length; ++i) {
            if (this.tabItemList[i].isDisposed()) continue;
            ++n;
        }
        if (n == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] toolItemArray = new ToolItem[n];
        int n2 = 0;
        for (int i = 0; i < this.tabItemList.length; ++i) {
            if (this.tabItemList[i].isDisposed()) continue;
            toolItemArray[n2++] = this.tabItemList[i];
        }
        this.tabItemList = toolItemArray;
        return this.tabItemList;
    }

    @Override
    long gtk_key_press_event(long l, long l2) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long l3 = super.gtk_key_press_event(l, l2);
        return l3;
    }

    @Override
    long gtk_focus(long l, long l2) {
        return 0L;
    }

    @Override
    boolean hasFocus() {
        if (this.hasChildFocus) {
            return true;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            if (toolItem != toolItemArray[i]) continue;
            return i;
        }
        return -1;
    }

    static long MenuItemSelectedProc(long l, long l2) {
        Display display = Display.getCurrent();
        ToolItem toolItem = (ToolItem)display.getWidget(l2);
        if (toolItem != null) {
            return toolItem.getParent().menuItemSelected(l, toolItem);
        }
        return 0L;
    }

    long menuItemSelected(long l, ToolItem toolItem) {
        Event event = new Event();
        switch (toolItem.style) {
            case 4: {
                event.detail = 4;
                GtkAllocation gtkAllocation = new GtkAllocation();
                OS.gtk_widget_get_allocation(l, gtkAllocation);
                event.x = gtkAllocation.x;
                if ((this.style & 0x8000000) != 0) {
                    event.x = this.getClientWidth() - gtkAllocation.width - event.x;
                }
                event.y = gtkAllocation.y + gtkAllocation.height;
                break;
            }
            case 16: {
                if ((this.style & 0x400000) != 0) break;
                toolItem.selectRadio();
                break;
            }
            case 32: {
                boolean bl = toolItem.getSelection();
                toolItem.setSelection(!bl);
            }
        }
        toolItem.sendSelectionEvent(13, event, false);
        return 0L;
    }

    @Override
    boolean mnemonicHit(char c) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            long l = toolItemArray[i].labelHandle;
            if (l == 0L || !this.mnemonicHit(l, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char c) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            long l = toolItemArray[i].labelHandle;
            if (l == 0L || !this.mnemonicMatch(l, c)) continue;
            return true;
        }
        return false;
    }

    void relayout() {
        int n;
        ToolItem[] toolItemArray = this.getItems();
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < toolItemArray.length; ++n) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem == null) continue;
            toolItem.resizeControl();
            bl |= toolItem.text != null && toolItem.text.length() > 0;
            bl2 |= toolItem.image != null;
        }
        n = 0;
        if (bl && bl2) {
            n = (this.style & 0x20000) != 0 ? 3 : 2;
        } else if (bl) {
            n = 1;
        } else if (bl2) {
            n = 0;
        }
        OS.gtk_toolbar_set_style(this.handle, n);
    }

    @Override
    void releaseChildren(boolean bl) {
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem == null || toolItem.isDisposed()) continue;
            toolItem.release(false);
        }
        super.releaseChildren(bl);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            ToolItem toolItem = toolItemArray[i];
            if (toolItem.control != control) continue;
            toolItem.setControl(null);
        }
    }

    @Override
    void reskinChildren(int n) {
        ToolItem[] toolItemArray = this._getItems();
        if (toolItemArray != null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem == null) continue;
                toolItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    @Override
    int setBounds(int n, int n2, int n3, int n4, boolean bl, boolean bl2) {
        OS.gtk_toolbar_set_show_arrow(this.handle, false);
        int n5 = super.setBounds(n, n2, n3, n4, bl, bl2);
        if ((n5 & 0x100) != 0) {
            this.relayout();
        }
        if ((this.style & 0x40) != 0) {
            OS.gtk_toolbar_set_show_arrow(this.handle, true);
        }
        return n5;
    }

    @Override
    void setFontDescription(long l) {
        super.setFontDescription(l);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setFontDescription(l);
        }
        this.relayout();
    }

    @Override
    void setForegroundColor(GdkColor gdkColor) {
        super.setForegroundColor(gdkColor);
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setForegroundColor(gdkColor);
        }
    }

    @Override
    void setOrientation(boolean bl) {
        super.setOrientation(bl);
        ToolItem[] toolItemArray = this._getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            toolItemArray[i].setOrientation(bl);
        }
    }

    void setTabItemList(ToolItem[] toolItemArray) {
        this.checkWidget();
        if (toolItemArray != null) {
            for (int i = 0; i < toolItemArray.length; ++i) {
                ToolItem toolItem = toolItemArray[i];
                if (toolItem == null) {
                    this.error(5);
                }
                if (toolItem.isDisposed()) {
                    this.error(5);
                }
                if (toolItem.parent == this) continue;
                this.error(32);
            }
            ToolItem[] toolItemArray2 = new ToolItem[toolItemArray.length];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, toolItemArray.length);
            toolItemArray = toolItemArray2;
        }
        this.tabItemList = toolItemArray;
    }

    @Override
    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        Shell shell = this._getShell();
        ToolItem[] toolItemArray = this.getItems();
        for (int i = 0; i < toolItemArray.length; ++i) {
            String string2 = string != null ? null : toolItemArray[i].toolTipText;
            shell.setToolTipText(toolItemArray[i].handle, string2);
        }
    }

    static {
        if (menuItemSelectedFunc.getAddress() == 0L) {
            SWT.error(3);
        }
    }
}

