/*
 * Decompiled with CFR 0.152.
 */
package org.grails.web.mapping;

import grails.core.GrailsApplication;
import grails.plugins.VersionComparator;
import grails.util.GrailsStringUtils;
import grails.validation.ConstrainedProperty;
import grails.web.mapping.UrlMapping;
import grails.web.mapping.UrlMappingData;
import grails.web.mapping.UrlMappingInfo;
import grails.web.mapping.exceptions.UrlMappingException;
import groovy.lang.Closure;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.grails.web.mapping.AbstractUrlMapping;
import org.grails.web.mapping.DefaultUrlMappingInfo;
import org.grails.web.servlet.mvc.GrailsWebRequest;
import org.grails.web.servlet.mvc.exceptions.ControllerExecutionException;
import org.grails.web.util.WebUtils;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;
import org.springframework.validation.MapBindingResult;
import org.springframework.web.context.request.RequestContextHolder;

public class RegexUrlMapping
extends AbstractUrlMapping {
    public static final String FORMAT_PARAMETER = "format";
    private Pattern[] patterns;
    private Map<Integer, List<Pattern>> patternByTokenCount = new HashMap<Integer, List<Pattern>>();
    private UrlMappingData urlData;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final Log LOG = LogFactory.getLog(RegexUrlMapping.class);
    public static final Pattern DOUBLE_WILDCARD_PATTERN = Pattern.compile("\\(\\*\\*?\\)\\??");
    public static final Pattern OPTIONAL_EXTENSION_WILDCARD_PATTERN = Pattern.compile("[^/]+\\(\\.\\(\\*\\)\\)");

    public RegexUrlMapping(UrlMappingData data, URI uri, ConstrainedProperty[] constraints, GrailsApplication grailsApplication) {
        super(uri, constraints, grailsApplication);
        this.parse(data, constraints);
    }

    public RegexUrlMapping(UrlMappingData data, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, String httpMethod, String version, ConstrainedProperty[] constraints, GrailsApplication grailsApplication) {
        this(null, data, controllerName, actionName, namespace, pluginName, viewName, httpMethod, version, constraints, grailsApplication);
    }

    public RegexUrlMapping(RegexUrlMapping regexUrlMapping, HttpMethod httpMethod) {
        this(regexUrlMapping.urlData, regexUrlMapping.controllerName, regexUrlMapping.actionName, regexUrlMapping.namespace, regexUrlMapping.pluginName, regexUrlMapping.viewName, httpMethod.toString(), regexUrlMapping.version, regexUrlMapping.constraints, regexUrlMapping.grailsApplication);
    }

    public RegexUrlMapping(Object redirectInfo, UrlMappingData data, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, String httpMethod, String version, ConstrainedProperty[] constraints, GrailsApplication grailsApplication) {
        super(redirectInfo, controllerName, actionName, namespace, pluginName, viewName, constraints != null ? constraints : new ConstrainedProperty[]{}, grailsApplication);
        if (httpMethod != null) {
            this.httpMethod = httpMethod;
        }
        if (version != null) {
            this.version = version;
        }
        this.parse(data, constraints);
    }

    @Deprecated
    public RegexUrlMapping(UrlMappingData data, URI uri, ConstrainedProperty[] constraints, ServletContext servletContext) {
        this(data, uri, constraints, WebUtils.findApplication((ServletContext)servletContext));
    }

    @Deprecated
    public RegexUrlMapping(UrlMappingData data, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, String httpMethod, String version, ConstrainedProperty[] constraints, ServletContext servletContext) {
        this(data, controllerName, actionName, namespace, pluginName, viewName, httpMethod, version, constraints, WebUtils.findApplication((ServletContext)servletContext));
    }

    @Deprecated
    public RegexUrlMapping(Object redirectInfo, UrlMappingData data, Object controllerName, Object actionName, Object namespace, Object pluginName, Object viewName, String httpMethod, String version, ConstrainedProperty[] constraints, ServletContext servletContext) {
        this(redirectInfo, data, controllerName, actionName, namespace, pluginName, viewName, httpMethod, version, constraints, WebUtils.findApplication((ServletContext)servletContext));
    }

    private void parse(UrlMappingData data, ConstrainedProperty[] constraints) {
        Assert.notNull((Object)data, (String)"Argument [data] cannot be null");
        String[] urls = data.getLogicalUrls();
        this.urlData = data;
        this.patterns = new Pattern[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            Pattern pattern;
            String url = urls[i];
            Integer slashCount = StringUtils.countOccurrencesOf((String)url, (String)"/");
            List<Pattern> tokenCountPatterns = this.patternByTokenCount.get(slashCount);
            if (tokenCountPatterns == null) {
                tokenCountPatterns = new ArrayList<Pattern>();
                this.patternByTokenCount.put(slashCount, tokenCountPatterns);
            }
            if ((pattern = this.convertToRegex(url)) == null) {
                throw new IllegalStateException("Cannot use null pattern in regular expression mapping for url [" + data.getUrlPattern() + "]");
            }
            tokenCountPatterns.add(pattern);
            this.patterns[i] = pattern;
        }
        if (constraints != null) {
            String[] tokens = data.getTokens();
            int pos = 0;
            int currentToken = 0;
            int tokensLength = tokens.length - 1;
            int constraintUpperBound = constraints.length;
            if (data.hasOptionalExtension()) {
                constraints[--constraintUpperBound].setNullable(true);
            }
            for (int i = 0; i < constraintUpperBound; ++i) {
                ConstrainedProperty constraint = constraints[i];
                if (currentToken > tokensLength) break;
                String token = tokens[currentToken];
                int shiftLength = 3;
                pos = token.indexOf("(*)", pos);
                while (pos == -1) {
                    boolean isLastToken;
                    boolean bl = isLastToken = currentToken == tokensLength - 1;
                    if (currentToken >= tokensLength) break;
                    token = tokens[++currentToken];
                    if (isLastToken) {
                        if (token.startsWith("(*)?")) {
                            constraint.setNullable(true);
                        }
                        if (!token.endsWith("(.(*))?")) continue;
                        constraints[constraints.length - 1].setNullable(true);
                        continue;
                    }
                    pos = token.indexOf("(*)", pos);
                }
                if (pos != -1 && pos + shiftLength < token.length() && token.charAt(pos + shiftLength) == '?') {
                    constraint.setNullable(true);
                }
                if (token.indexOf("(*)", pos += shiftLength) != -1) continue;
                ++currentToken;
                pos = 0;
            }
        }
    }

    protected Pattern convertToRegex(String url) {
        Pattern regex;
        String pattern = null;
        try {
            pattern = url.replace(".", "\\.");
            pattern = pattern.replace("+", "\\+");
            int lastSlash = pattern.lastIndexOf(47);
            String urlRoot = lastSlash > -1 ? pattern.substring(0, lastSlash) : pattern;
            String urlEnd = lastSlash > -1 ? pattern.substring(lastSlash, pattern.length()) : "";
            pattern = "^" + urlRoot.replace("(\\.(*))", "(\\.[^/]+)?").replaceAll("([^\\*])\\*([^\\*])", "$1[^/]+?$2").replaceAll("([^\\*])\\*$", "$1[^/]+?").replaceAll("\\*\\*", ".*");
            pattern = "/(*)(\\.(*))".equals(urlEnd) ? pattern + "/([^/]+)\\.([^/.]+)?" : pattern + urlEnd.replace("(\\.(*))", "(\\.[^/]+)?").replaceAll("([^\\*])\\*([^\\*])", "$1[^/]+?$2").replaceAll("([^\\*])\\*$", "$1[^/]+?").replaceAll("\\*\\*", ".*").replaceAll("\\(\\[\\^\\/\\]\\+\\)\\\\\\.", "([^/.]+?)\\\\.").replaceAll("\\(\\[\\^\\/\\]\\+\\)\\?\\\\\\.", "([^/.]+?)\\?\\\\.");
            pattern = pattern + "/??$";
            regex = Pattern.compile(pattern);
        }
        catch (PatternSyntaxException pse) {
            throw new UrlMappingException("Error evaluating mapping for pattern [" + pattern + "] from Grails URL mappings: " + pse.getMessage(), pse);
        }
        return regex;
    }

    @Override
    public UrlMappingInfo match(String uri) {
        for (Pattern pattern : this.patterns) {
            UrlMappingInfo urlInfo;
            Matcher m = pattern.matcher(uri);
            if (!m.matches() || (urlInfo = this.createUrlMappingInfo(uri, m)) == null) continue;
            return urlInfo;
        }
        return null;
    }

    @Override
    public String createURL(Map paramValues, String encoding) {
        return this.createURLInternal(paramValues, encoding, true);
    }

    private String createURLInternal(Map paramValues, String encoding, boolean includeContextPath) {
        GrailsWebRequest webRequest;
        if (encoding == null) {
            encoding = "utf-8";
        }
        String contextPath = "";
        if (includeContextPath && (webRequest = (GrailsWebRequest)RequestContextHolder.getRequestAttributes()) != null) {
            contextPath = webRequest.getAttributes().getApplicationUri((ServletRequest)webRequest.getCurrentRequest());
        }
        if (paramValues == null) {
            paramValues = Collections.EMPTY_MAP;
        }
        StringBuilder uri = new StringBuilder(contextPath);
        HashSet<String> usedParams = new HashSet<String>();
        String[] tokens = this.urlData.getTokens();
        int paramIndex = 0;
        for (int i = 0; i < tokens.length; ++i) {
            Object value;
            String propName;
            ConstrainedProperty prop;
            Matcher m;
            String token = tokens[i];
            if (i == tokens.length - 1 && this.urlData.hasOptionalExtension()) {
                token = token + "(.(*))";
            }
            if ((m = OPTIONAL_EXTENSION_WILDCARD_PATTERN.matcher(token)).find()) {
                boolean tokenSet = false;
                if (token.startsWith("(*)")) {
                    prop = this.constraints[paramIndex++];
                    propName = prop.getPropertyName();
                    value = paramValues.get(propName);
                    usedParams.add(propName);
                    if (value != null) {
                        token = token.replaceFirst(DOUBLE_WILDCARD_PATTERN.pattern(), value.toString());
                        tokenSet = true;
                    } else {
                        token = token.replaceFirst(DOUBLE_WILDCARD_PATTERN.pattern(), "");
                    }
                } else {
                    tokenSet = true;
                }
                if (tokenSet) {
                    uri.append("/");
                }
                prop = this.constraints[paramIndex++];
                propName = prop.getPropertyName();
                value = paramValues.get(propName);
                usedParams.add(propName);
                if (value != null) {
                    String ext = "." + value;
                    uri.append(token.replace("(.(*))?", ext).replace("(.(*))", ext));
                    continue;
                }
                uri.append(token.replace("(.(*))?", "").replace("(.(*))", ""));
                continue;
            }
            if (token.endsWith("?")) {
                token = token.substring(0, token.length() - 1);
            }
            if ((m = DOUBLE_WILDCARD_PATTERN.matcher(token)).find()) {
                StringBuffer buf = new StringBuffer();
                do {
                    prop = this.constraints[paramIndex++];
                    propName = prop.getPropertyName();
                    value = paramValues.get(propName);
                    usedParams.add(propName);
                    if (value == null && !prop.isNullable()) {
                        throw new UrlMappingException("Unable to create URL for mapping [" + this + "] and parameters [" + paramValues + "]. Parameter [" + prop.getPropertyName() + "] is required, but was not specified!");
                    }
                    if (value == null) {
                        m.appendReplacement(buf, "");
                        continue;
                    }
                    m.appendReplacement(buf, Matcher.quoteReplacement(value.toString()));
                } while (m.find());
                m.appendTail(buf);
                try {
                    String v = buf.toString();
                    if (v.indexOf("/") > -1 && "(**)".equals(token)) {
                        String[] segs;
                        if (v.startsWith("/")) {
                            v = v.substring("/".length());
                        }
                        for (String segment : segs = v.split("/")) {
                            uri.append("/").append(this.encode(segment, encoding));
                        }
                        continue;
                    }
                    if (v.length() <= 0) break;
                    uri.append("/").append(this.encode(v, encoding));
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    throw new ControllerExecutionException("Error creating URL for parameters [" + paramValues + "], problem encoding URL part [" + buf + "]: " + e.getMessage(), (Throwable)e);
                }
            }
            uri.append("/").append(token);
        }
        this.populateParameterList(paramValues, encoding, uri, usedParams);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Created reverse URL mapping [" + uri.toString() + "] for parameters [" + paramValues + "]"));
        }
        return uri.toString();
    }

    protected String encode(String s, String encoding) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, encoding).replaceAll("\\+", "%20");
    }

    @Override
    public String createURL(Map paramValues, String encoding, String fragment) {
        String url = this.createURL(paramValues, encoding);
        return this.createUrlWithFragment(url, fragment, encoding);
    }

    @Override
    public String createURL(String controller, String action, Map paramValues, String encoding) {
        return this.createURL(controller, action, null, null, paramValues, encoding);
    }

    @Override
    public String createURL(String controller, String action, String pluginName, Map parameterValues, String encoding) {
        return this.createURL(controller, action, null, pluginName, parameterValues, encoding);
    }

    @Override
    public String createURL(String controller, String action, String namespace, String pluginName, Map paramValues, String encoding) {
        return this.createURLInternal(controller, action, namespace, pluginName, paramValues, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createURLInternal(String controller, String action, String namespace, String pluginName, Map paramValues, String encoding, boolean includeContextPath) {
        if (paramValues == null) {
            paramValues = new HashMap<String, String>();
        }
        boolean hasController = !GrailsStringUtils.isBlank((String)controller);
        boolean hasAction = !GrailsStringUtils.isBlank((String)action);
        boolean hasPlugin = !GrailsStringUtils.isBlank((String)pluginName);
        boolean hasNamespace = !GrailsStringUtils.isBlank((String)namespace);
        try {
            if (hasController) {
                paramValues.put("controller", controller);
            }
            if (hasAction) {
                paramValues.put("action", action);
            }
            if (hasPlugin) {
                paramValues.put("plugin", pluginName);
            }
            if (hasNamespace) {
                paramValues.put("namespace", namespace);
            }
            String string = this.createURLInternal(paramValues, encoding, includeContextPath);
            return string;
        }
        finally {
            if (hasController) {
                paramValues.remove("controller");
            }
            if (hasAction) {
                paramValues.remove("action");
            }
            if (hasPlugin) {
                paramValues.remove("plugin");
            }
        }
    }

    @Override
    public String createRelativeURL(String controller, String action, Map paramValues, String encoding) {
        return this.createRelativeURL(controller, action, null, null, paramValues, encoding);
    }

    @Override
    public String createRelativeURL(String controller, String action, String pluginName, Map paramValues, String encoding) {
        return this.createRelativeURL(controller, action, null, pluginName, paramValues, encoding);
    }

    @Override
    public String createRelativeURL(String controller, String action, String namespace, String pluginName, Map paramValues, String encoding) {
        return this.createURLInternal(controller, action, namespace, pluginName, paramValues, encoding, false);
    }

    @Override
    public String createRelativeURL(String controller, String action, Map paramValues, String encoding, String fragment) {
        return this.createRelativeURL(controller, action, null, null, paramValues, encoding, fragment);
    }

    @Override
    public String createRelativeURL(String controller, String action, String namespace, String pluginName, Map paramValues, String encoding, String fragment) {
        String url = this.createURLInternal(controller, action, namespace, pluginName, paramValues, encoding, false);
        return this.createUrlWithFragment(url, fragment, encoding);
    }

    @Override
    public String createURL(String controller, String action, Map paramValues, String encoding, String fragment) {
        return this.createURL(controller, action, null, null, paramValues, encoding, fragment);
    }

    @Override
    public String createURL(String controller, String action, String namespace, String pluginName, Map paramValues, String encoding, String fragment) {
        String url = this.createURL(controller, action, namespace, pluginName, paramValues, encoding);
        return this.createUrlWithFragment(url, fragment, encoding);
    }

    private String createUrlWithFragment(String url, String fragment, String encoding) {
        if (fragment != null) {
            if (encoding == null) {
                encoding = DEFAULT_ENCODING;
            }
            try {
                return url + '#' + URLEncoder.encode(fragment, encoding);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ControllerExecutionException("Error creating URL  [" + url + "], problem encoding URL fragment [" + fragment + "]: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return url;
    }

    private void populateParameterList(Map paramValues, String encoding, StringBuilder uri, Set usedParams) {
        boolean addedParams = false;
        usedParams.add("controller");
        usedParams.add("action");
        usedParams.add("namespace");
        usedParams.add("plugin");
        if (encoding == null) {
            encoding = DEFAULT_ENCODING;
        }
        for (Object o1 : paramValues.keySet()) {
            Object o;
            Object[] multiValues;
            String name = o1.toString();
            if (usedParams.contains(name)) continue;
            if (!addedParams) {
                uri.append('?');
                addedParams = true;
            } else {
                uri.append('&');
            }
            Object value = paramValues.get(name);
            if (value != null && value instanceof Collection) {
                multiValues = (Object[])value;
                Iterator j = multiValues.iterator();
                while (j.hasNext()) {
                    o = j.next();
                    this.appendValueToURI(encoding, uri, name, o);
                    if (!j.hasNext()) continue;
                    uri.append('&');
                }
                continue;
            }
            if (value != null && value.getClass().isArray()) {
                multiValues = (Object[])value;
                for (int j = 0; j < multiValues.length; ++j) {
                    o = multiValues[j];
                    this.appendValueToURI(encoding, uri, name, o);
                    if (j + 1 >= multiValues.length) continue;
                    uri.append('&');
                }
                continue;
            }
            this.appendValueToURI(encoding, uri, name, value);
        }
    }

    private void appendValueToURI(String encoding, StringBuilder uri, String name, Object value) {
        try {
            uri.append(URLEncoder.encode(name, encoding)).append('=').append(URLEncoder.encode(value != null ? value.toString() : "", encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new ControllerExecutionException("Error redirecting request for url [" + name + ":" + value + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public UrlMappingData getUrlData() {
        return this.urlData;
    }

    private UrlMappingInfo createUrlMappingInfo(String uri, Matcher m) {
        boolean hasOptionalExtension = this.urlData.hasOptionalExtension();
        HashMap<String, String> params = new HashMap<String, String>();
        MapBindingResult errors = new MapBindingResult(params, "urlMapping");
        int groupCount = m.groupCount();
        String lastGroup = null;
        for (int i = 0; i < groupCount; ++i) {
            lastGroup = m.group(i + 1);
            if (i == groupCount - 1 && hasOptionalExtension) {
                ConstrainedProperty cp = this.constraints[this.constraints.length - 1];
                cp.validate((Object)this, (Object)lastGroup, (Errors)errors);
                if (errors.hasErrors()) {
                    return null;
                }
                String propertyName = cp.getPropertyName();
                if (lastGroup != null && FORMAT_PARAMETER.equals(propertyName) && lastGroup.startsWith(".")) {
                    lastGroup = lastGroup.substring(1);
                }
                params.put(propertyName, lastGroup);
                break;
            }
            if (lastGroup == null) continue;
            int j = lastGroup.indexOf(63);
            if (j > -1) {
                lastGroup = lastGroup.substring(0, j);
            }
            if (this.constraints.length <= i) continue;
            ConstrainedProperty cp = this.constraints[i];
            cp.validate((Object)this, (Object)lastGroup, (Errors)errors);
            if (errors.hasErrors()) {
                return null;
            }
            String propertyName = cp.getPropertyName();
            if (FORMAT_PARAMETER.equals(propertyName) && lastGroup.startsWith(".")) {
                lastGroup = lastGroup.substring(1);
            }
            params.put(propertyName, lastGroup);
        }
        for (Object key : this.parameterValues.keySet()) {
            params.put((String)key, (String)this.parameterValues.get(key));
        }
        if (this.controllerName == null) {
            this.controllerName = this.createRuntimeConstraintEvaluator("controller", this.constraints);
        }
        if (this.actionName == null) {
            this.actionName = this.createRuntimeConstraintEvaluator("action", this.constraints);
        }
        if (this.namespace == null) {
            this.namespace = this.createRuntimeConstraintEvaluator("namespace", this.constraints);
        }
        if (this.viewName == null) {
            this.viewName = this.createRuntimeConstraintEvaluator("view", this.constraints);
        }
        if (this.redirectInfo == null) {
            this.redirectInfo = this.createRuntimeConstraintEvaluator("redirect", this.constraints);
        }
        DefaultUrlMappingInfo info = this.forwardURI != null && this.controllerName == null ? new DefaultUrlMappingInfo(this.forwardURI, this.getHttpMethod(), this.urlData, this.grailsApplication) : (this.viewName != null && this.controllerName == null ? new DefaultUrlMappingInfo(this.viewName, params, this.urlData, this.grailsApplication) : new DefaultUrlMappingInfo(this.redirectInfo, this.controllerName, this.actionName, this.namespace, this.pluginName, this.getViewName(), this.getHttpMethod(), this.getVersion(), params, this.urlData, this.grailsApplication));
        if (this.parseRequest) {
            info.setParsingRequest(this.parseRequest);
        }
        return info;
    }

    private Object createRuntimeConstraintEvaluator(final String name, ConstrainedProperty[] constraints) {
        if (constraints == null) {
            return null;
        }
        for (ConstrainedProperty constraint : constraints) {
            if (!constraint.getPropertyName().equals(name)) continue;
            return new Closure(this){
                private static final long serialVersionUID = -2404119898659287216L;

                public Object call(Object ... objects) {
                    GrailsWebRequest webRequest = (GrailsWebRequest)RequestContextHolder.currentRequestAttributes();
                    return webRequest.getParams().get((Object)name);
                }
            };
        }
        return null;
    }

    public String[] getLogicalMappings() {
        return this.urlData.getLogicalUrls();
    }

    public int compareTo(Object o) {
        String thatVersion;
        String[] otherTokens;
        int otherTokensLength;
        boolean otherHasWildCards;
        if (!(o instanceof UrlMapping)) {
            throw new IllegalArgumentException("Cannot compare with Object [" + o + "]. It is not an instance of UrlMapping!");
        }
        if (this.equals(o)) {
            return 0;
        }
        UrlMapping other = (UrlMapping)o;
        int thisStaticTokenCount = this.getStaticTokenCount(this);
        int otherStaticTokenCount = this.getStaticTokenCount(other);
        int otherSingleWildcardCount = this.getSingleWildcardCount(other);
        int thisSingleWildcardCount = this.getSingleWildcardCount(this);
        int otherDoubleWildcardCount = this.getDoubleWildcardCount(other);
        int thisDoubleWildcardCount = this.getDoubleWildcardCount(this);
        boolean hasWildCards = thisDoubleWildcardCount > 0 || thisSingleWildcardCount > 0;
        boolean bl = otherHasWildCards = otherDoubleWildcardCount > 0 || otherSingleWildcardCount > 0;
        if (thisStaticTokenCount == 0 && thisSingleWildcardCount == 0 && thisDoubleWildcardCount == 0) {
            return 1;
        }
        if (otherStaticTokenCount == 0 && otherSingleWildcardCount == 0 && otherDoubleWildcardCount == 0) {
            return -1;
        }
        if (otherStaticTokenCount == 0 && thisStaticTokenCount > 0) {
            return 1;
        }
        if (thisStaticTokenCount == 0 && otherStaticTokenCount > 0) {
            return -1;
        }
        int thisStaticAndWildcardTokenCount = this.getStaticAndWildcardTokenCount(this);
        int otherStaticAndWildcardTokenCount = this.getStaticAndWildcardTokenCount(other);
        if (otherStaticAndWildcardTokenCount == 0 && thisStaticAndWildcardTokenCount > 0) {
            return 1;
        }
        if (thisStaticAndWildcardTokenCount == 0 && otherStaticAndWildcardTokenCount > 0) {
            return -1;
        }
        int staticDiff = thisStaticTokenCount - otherStaticTokenCount;
        if (staticDiff < 0 && !otherHasWildCards) {
            return staticDiff;
        }
        if (staticDiff > 0 && !hasWildCards) {
            return staticDiff;
        }
        String[] thisTokens = this.getUrlData().getTokens();
        int thisTokensLength = thisTokens.length;
        int greaterLength = thisTokensLength > (otherTokensLength = (otherTokens = other.getUrlData().getTokens()).length) ? thisTokensLength : otherTokensLength;
        for (int i = 0; i < greaterLength; ++i) {
            boolean otherTokenIsWildcard;
            boolean thisHasMoreTokens = i < thisTokensLength;
            boolean otherHasMoreTokens = i < otherTokensLength;
            boolean thisTokenIsWildcard = !thisHasMoreTokens || this.isSingleWildcard(thisTokens[i]);
            boolean bl2 = otherTokenIsWildcard = !otherHasMoreTokens || this.isSingleWildcard(otherTokens[i]);
            if (thisTokenIsWildcard && !otherTokenIsWildcard) {
                return -1;
            }
            if (thisTokenIsWildcard || !otherTokenIsWildcard) continue;
            return 1;
        }
        int doubleWildcardDiff = otherDoubleWildcardCount - thisDoubleWildcardCount;
        if (doubleWildcardDiff != 0) {
            return doubleWildcardDiff;
        }
        int singleWildcardDiff = otherSingleWildcardCount - thisSingleWildcardCount;
        if (singleWildcardDiff != 0) {
            return singleWildcardDiff;
        }
        int constraintDiff = this.getAppliedConstraintsCount(this) - this.getAppliedConstraintsCount(other);
        if (constraintDiff != 0) {
            return constraintDiff;
        }
        int allDiff = thisStaticTokenCount - otherStaticTokenCount + (thisSingleWildcardCount - otherSingleWildcardCount) + (thisDoubleWildcardCount - otherDoubleWildcardCount);
        if (allDiff != 0) {
            return allDiff;
        }
        String thisVersion = this.getVersion();
        if (thisVersion.equals(thatVersion = other.getVersion())) {
            return 0;
        }
        if (thisVersion.equals("*") && !thatVersion.equals("*")) {
            return -1;
        }
        if (!thisVersion.equals("*") && thatVersion.equals("*")) {
            return 1;
        }
        return new VersionComparator().compare(thisVersion, thatVersion);
    }

    private int getAppliedConstraintsCount(UrlMapping mapping) {
        int count = 0;
        for (ConstrainedProperty prop : mapping.getConstraints()) {
            count += prop.getAppliedConstraints().size();
        }
        return count;
    }

    private int getSingleWildcardCount(UrlMapping mapping) {
        String[] tokens = mapping.getUrlData().getTokens();
        int count = 0;
        for (String token : tokens) {
            if (!this.isSingleWildcard(token)) continue;
            ++count;
        }
        return count;
    }

    private int getDoubleWildcardCount(UrlMapping mapping) {
        String[] tokens = mapping.getUrlData().getTokens();
        int count = 0;
        for (String token : tokens) {
            if (!this.isDoubleWildcard(token)) continue;
            ++count;
        }
        return count;
    }

    private int getStaticTokenCount(UrlMapping mapping) {
        String[] tokens = mapping.getUrlData().getTokens();
        int count = 0;
        for (String token : tokens) {
            if (this.isSingleWildcard(token) || "".equals(token)) continue;
            ++count;
        }
        return count;
    }

    private boolean isSingleWildcard(String token) {
        return token.contains("*") || token.contains("(*)");
    }

    private boolean isDoubleWildcard(String token) {
        return token.contains("**") || token.contains("(**)");
    }

    private int getStaticAndWildcardTokenCount(UrlMapping mapping) {
        String[] tokens = mapping.getUrlData().getTokens();
        int count = 0;
        for (String token : tokens) {
            if ("".equals(token = token.replace("(.(*))", "").replace("(**)", "").replace("(*)", ""))) continue;
            ++count;
        }
        return count;
    }

    public String toString() {
        return this.urlData.getUrlPattern();
    }
}

