/*
 * Decompiled with CFR 0.152.
 */
package java.awt.print;

import java.awt.print.Paper;

public class PageFormat
implements Cloneable {
    public static final int LANDSCAPE = 0;
    public static final int PORTRAIT = 1;
    public static final int REVERSE_LANDSCAPE = 2;
    private Paper mPaper = new Paper();
    private int mOrientation = 1;

    public Object clone() {
        PageFormat newPage;
        try {
            newPage = (PageFormat)super.clone();
            newPage.mPaper = (Paper)this.mPaper.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            newPage = null;
        }
        return newPage;
    }

    public double getWidth() {
        int orientation = this.getOrientation();
        double width = orientation == 1 ? this.mPaper.getWidth() : this.mPaper.getHeight();
        return width;
    }

    public double getHeight() {
        int orientation = this.getOrientation();
        double height = orientation == 1 ? this.mPaper.getHeight() : this.mPaper.getWidth();
        return height;
    }

    public double getImageableX() {
        double x;
        switch (this.getOrientation()) {
            case 0: {
                x = this.mPaper.getHeight() - (this.mPaper.getImageableY() + this.mPaper.getImageableHeight());
                break;
            }
            case 1: {
                x = this.mPaper.getImageableX();
                break;
            }
            case 2: {
                x = this.mPaper.getImageableY();
                break;
            }
            default: {
                throw new InternalError("unrecognized orientation");
            }
        }
        return x;
    }

    public double getImageableY() {
        double y;
        switch (this.getOrientation()) {
            case 0: {
                y = this.mPaper.getImageableX();
                break;
            }
            case 1: {
                y = this.mPaper.getImageableY();
                break;
            }
            case 2: {
                y = this.mPaper.getWidth() - (this.mPaper.getImageableX() + this.mPaper.getImageableWidth());
                break;
            }
            default: {
                throw new InternalError("unrecognized orientation");
            }
        }
        return y;
    }

    public double getImageableWidth() {
        double width = this.getOrientation() == 1 ? this.mPaper.getImageableWidth() : this.mPaper.getImageableHeight();
        return width;
    }

    public double getImageableHeight() {
        double height = this.getOrientation() == 1 ? this.mPaper.getImageableHeight() : this.mPaper.getImageableWidth();
        return height;
    }

    public Paper getPaper() {
        return (Paper)this.mPaper.clone();
    }

    public void setPaper(Paper paper) {
        this.mPaper = (Paper)paper.clone();
    }

    public void setOrientation(int orientation) throws IllegalArgumentException {
        if (0 > orientation || orientation > 2) {
            throw new IllegalArgumentException();
        }
        this.mOrientation = orientation;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public double[] getMatrix() {
        double[] matrix = new double[6];
        switch (this.mOrientation) {
            case 0: {
                matrix[0] = 0.0;
                matrix[1] = -1.0;
                matrix[2] = 1.0;
                matrix[3] = 0.0;
                matrix[4] = 0.0;
                matrix[5] = this.mPaper.getHeight();
                break;
            }
            case 1: {
                matrix[0] = 1.0;
                matrix[1] = 0.0;
                matrix[2] = 0.0;
                matrix[3] = 1.0;
                matrix[4] = 0.0;
                matrix[5] = 0.0;
                break;
            }
            case 2: {
                matrix[0] = 0.0;
                matrix[1] = 1.0;
                matrix[2] = -1.0;
                matrix[3] = 0.0;
                matrix[4] = this.mPaper.getWidth();
                matrix[5] = 0.0;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return matrix;
    }
}

