<?php

namespace Drupal\form_test\Form;

use Drupal\Core\Form\FormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form builder for \Drupal\Core\Form\FormState::cleanValues() test.
 */
class FormTestFormStateValuesCleanAdvancedForm extends FormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'form_test_form_state_clean_values_advanced_form';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    // Build an example form containing a managed file and a submit form element.
    $form['image'] = array(
      '#type' => 'managed_file',
      '#title' => t('Image'),
      '#upload_location' => 'public://',
      '#default_value' => 0,
    );
    $form['submit'] = array(
      '#type' => 'submit',
      '#value' => t('Submit'),
    );
    return $form;
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $form_state->cleanValues();
    print t('You WIN!');
    exit;
  }

}
