/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextPane;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.EditPane;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.browser.VFSBrowser;
import org.gjt.sp.jedit.buffer.BufferUndoListener;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.bufferio.BufferAutosaveRequest;
import org.gjt.sp.jedit.bufferio.MarkersSaveRequest;
import org.gjt.sp.jedit.bufferset.BufferSet;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.syntax.ModeProvider;
import org.gjt.sp.jedit.syntax.ParserRuleSet;
import org.gjt.sp.jedit.syntax.TokenHandler;
import org.gjt.sp.jedit.syntax.TokenMarker;
import org.gjt.sp.jedit.visitors.JEditVisitorAdapter;
import org.gjt.sp.jedit.visitors.SaveCaretInfoVisitor;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.IntegerArray;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;
import org.gjt.sp.util.ThreadUtilities;

public class Buffer
extends JEditBuffer {
    public static final String BACKED_UP = "Buffer__backedUp";
    public static final String CARET = "Buffer__caret";
    public static final String CARET_POSITIONED = "Buffer__caretPositioned";
    public static final String SELECTION = "Buffer__selection";
    public static final String SCROLL_VERT = "Buffer__scrollVert";
    public static final String SCROLL_HORIZ = "Buffer__scrollHoriz";
    public static final String ENCODING_AUTODETECT = "encodingAutodetect";
    public static final String TRAILING_EOL = "trailingEOL";
    public static final String GZIPPED = "gzipped";
    public static final int FILE_NOT_CHANGED = 0;
    public static final int FILE_CHANGED = 1;
    public static final int FILE_DELETED = 2;
    Buffer prev;
    Buffer next;
    private static final int CLOSED = 0;
    private static final int NEW_FILE = 3;
    private static final int UNTITLED = 4;
    private static final int AUTOSAVE_DIRTY = 5;
    private static final int AUTORELOAD = 6;
    private static final int AUTORELOAD_DIALOG = 7;
    private static final int TEMPORARY = 10;
    private static final int MARKERS_CHANGED = 12;
    private int flags;
    private int longLineLimit;
    private TokenMarker textTokenMarker = jEdit.getMode("text").getTokenMarker();
    private boolean autoreloadOverridden;
    private String path;
    private String symlinkPath;
    private String name;
    private String directory;
    private File file;
    private File autosaveFile;
    private long modTime;
    private byte[] md5hash;
    private int initialLength;
    private boolean longBufferMode;
    private final Vector<Marker> markers = new Vector();
    private Socket waitSocket;
    private List<BufferUndoListener> undoListeners;

    public void reload(View view) {
        Object[] objectArray;
        int n;
        if (this.getFlag(4)) {
            return;
        }
        if (this.isDirty() && (n = GUIUtilities.confirm(view, "changedreload", objectArray = new String[]{this.path}, 0, 2)) != 0) {
            return;
        }
        view.visit(new SaveCaretInfoVisitor());
        this.load(view, true);
    }

    public boolean load(final View view, final boolean bl) {
        Object object;
        boolean bl2;
        if (this.isPerformingIO()) {
            GUIUtilities.error(view, "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        this.setLoading(true);
        if (!this.getFlag(10)) {
            EditBus.send(new BufferUpdate(this, view, BufferUpdate.LOAD_STARTED));
        }
        if (bl || !this.getFlag(3)) {
            if (this.file != null) {
                this.modTime = this.file.lastModified();
            }
            if (!bl && this.autosaveFile != null && this.autosaveFile.exists()) {
                bl2 = this.recoverAutosave(view);
            } else {
                if (this.autosaveFile != null) {
                    this.autosaveFile.delete();
                }
                bl2 = false;
            }
            if (!bl2) {
                object = VFSManager.getVFSForPath(this.path);
                if (!this.checkFileForLoad(view, (VFS)object, this.path)) {
                    this.setLoading(false);
                    return false;
                }
                if (!(!bl && this.getFlag(3) || ((VFS)object).load(view, this, this.path))) {
                    this.setLoading(false);
                    return false;
                }
            }
        } else {
            bl2 = false;
        }
        object = new Runnable(){

            @Override
            public void run() {
                String string = Buffer.this.getStringProperty("BufferIORequest__newPath");
                Segment segment = (Segment)Buffer.this.getProperty("BufferIORequest__loadData");
                IntegerArray integerArray = (IntegerArray)Buffer.this.getProperty("BufferIORequest__endOffsets");
                Buffer.this.loadText(segment, integerArray);
                Buffer.this.unsetProperty("BufferIORequest__loadData");
                Buffer.this.unsetProperty("BufferIORequest__endOffsets");
                Buffer.this.unsetProperty("BufferIORequest__newPath");
                Buffer.this.undoMgr.clear();
                Buffer.this.undoMgr.setLimit(jEdit.getIntegerProperty("buffer.undoCount", 100));
                if (!Buffer.this.getFlag(10)) {
                    Buffer.this.finishLoading();
                }
                Buffer.this.setLoading(false);
                if (bl) {
                    Buffer.this.setDirty(false);
                }
                if (!bl2 && string != null) {
                    Buffer.this.setPath(string);
                }
                if (bl2) {
                    Buffer.super.setDirty(true);
                }
                if (!Buffer.this.getFlag(10)) {
                    Buffer.this.fireBufferLoaded();
                    EditBus.send(new BufferUpdate(Buffer.this, view, BufferUpdate.LOADED));
                }
            }
        };
        if (this.getFlag(10)) {
            object.run();
        } else {
            AwtRunnableQueue.INSTANCE.runAfterIoTasks((Runnable)object);
        }
        return true;
    }

    public boolean insertFile(View view, String string) {
        if (this.isPerformingIO()) {
            GUIUtilities.error(view, "buffer-multiple-io", null);
            return false;
        }
        this.setBooleanProperty("BufferIORequest__error", false);
        string = MiscUtilities.constructPath(this.path, string);
        Buffer buffer = jEdit.getBuffer(string);
        if (buffer != null) {
            view.getTextArea().setSelectedText(buffer.getText(0, buffer.getLength()));
            return true;
        }
        VFS vFS = VFSManager.getVFSForPath(string);
        return vFS.insert(view, this, string);
    }

    public void autosave() {
        if (this.autosaveFile == null || !this.getFlag(5) || !this.isDirty() || this.isPerformingIO() || !this.autosaveFile.getParentFile().exists()) {
            return;
        }
        this.setFlag(5, false);
        ThreadUtilities.runInBackground(new BufferAutosaveRequest(null, this, null, VFSManager.getFileVFS(), this.autosaveFile.getPath()));
    }

    public boolean saveAs(View view, boolean bl) {
        String[] stringArray;
        JComponent jComponent;
        VFSBrowser vFSBrowser;
        String string = this.path;
        if (jEdit.getBooleanProperty("saveAsUsesFSB") && (vFSBrowser = (VFSBrowser)(jComponent = (stringArray = view.getDockableWindowManager()).getDockable("vfs.browser"))) != null) {
            string = vFSBrowser.getDirectory() + "/";
        }
        if ((stringArray = GUIUtilities.showVFSFileDialog(view, string, 1, false)) == null) {
            return false;
        }
        boolean bl2 = this.save(view, stringArray[0], bl);
        if (bl2) {
            this.setReadOnly(false);
        }
        return bl2;
    }

    public boolean save(View view, String string) {
        return this.save(view, string, true, false);
    }

    public boolean save(View view, String string, boolean bl) {
        return this.save(view, string, bl, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean save(final View var1_1, String var2_2, boolean var3_3, boolean var4_4) {
        block31: {
            block32: {
                block34: {
                    block33: {
                        if (this.isPerformingIO()) {
                            GUIUtilities.error(var1_1, "buffer-multiple-io", null);
                            return false;
                        }
                        this.setBooleanProperty("BufferIORequest__error", false);
                        if (var2_2 == null && this.getFlag(3)) {
                            return this.saveAs(var1_1, var3_3);
                        }
                        if (var2_2 == null && this.file != null && (var5_5 = this.file.lastModified()) != this.modTime && (this.getAutoReload() || this.getAutoReloadDialog()) && (var8_8 = GUIUtilities.confirm(var1_1, "filechanged-save", var7_7 = new Object[]{this.path}, 0, 2)) != 0) {
                            return false;
                        }
                        EditBus.send(new BufferUpdate(this, var1_1, BufferUpdate.SAVING));
                        this.setPerformingIO(true);
                        var5_6 = this.path;
                        var6_10 = this.symlinkPath;
                        var7_7 = var2_2 == null ? this.path : var2_2;
                        var8_9 = VFSManager.getVFSForPath((String)var7_7);
                        if (!Buffer.checkFileForSave(var1_1, var8_9, (String)var7_7)) {
                            this.setPerformingIO(false);
                            return false;
                        }
                        var9_11 = var8_9.createVFSSession((String)var7_7, var1_1);
                        if (var9_11 == null) {
                            this.setPerformingIO(false);
                            return false;
                        }
                        this.unsetProperty("overwriteReadonly");
                        this.unsetProperty("forbidTwoStageSave");
                        var10_12 = var8_9._getFile(var9_11, (String)var7_7, var1_1);
                        if (var10_12 == null) break block31;
                        v0 = var11_15 = (var8_9.getCapabilities() & 16) != 0;
                        if (var10_12.isWriteable()) break block32;
                        Log.log(7, this, "Buffer saving : File " + var10_12 + " is readOnly");
                        if (!var11_15) ** GOTO lbl69
                        Log.log(1, this, "Buffer saving : VFS can rename files");
                        var12_16 = var8_9._canonPath(var9_11, (String)var7_7, var1_1);
                        if (!MiscUtilities.isURL(var12_16)) {
                            var12_16 = MiscUtilities.resolveSymlinks(var12_16);
                        }
                        if ((var12_16 = var8_9.getTwoStageSaveName(var12_16)) != null) break block33;
                        Log.log(1, this, "Buffer saving : two stage save impossible because path is null");
                        VFSManager.error(var1_1, (String)var7_7, "ioerror.save-readonly-twostagefail", null);
                        this.setPerformingIO(false);
                        var13_20 = false;
                        try {
                            var8_9._endVFSSession(var9_11, var1_1);
                        }
                        catch (IOException var14_24) {
                            VFSManager.error(var1_1, (String)var7_7, "ioerror", new String[]{var14_24.toString()});
                            this.setPerformingIO(false);
                            return false;
                        }
                        return var13_20;
                    }
                    var13_21 = GUIUtilities.confirm(var1_1, "vfs.overwrite-readonly", new Object[]{var7_7}, 0, 2);
                    if (var13_21 == 0) {
                        Log.log(7, this, "Buffer saving : two stage save will be used to save buffer");
                        this.setBooleanProperty("overwriteReadonly", true);
                        break block34;
                    }
                    Log.log(1, this, "Buffer not saved");
                    this.setPerformingIO(false);
                    var14_25 = false;
                    try {
                        var8_9._endVFSSession(var9_11, var1_1);
                    }
                    catch (IOException var15_27) {
                        VFSManager.error(var1_1, (String)var7_7, "ioerror", new String[]{var15_27.toString()});
                        this.setPerformingIO(false);
                        return false;
                    }
                    return var14_25;
                }
                break block31;
lbl69:
                // 1 sources

                Log.log(7, this, "Buffer saving : file is readonly and vfs cannot do two stage save");
                VFSManager.error(var1_1, (String)var7_7, "ioerror.write-error-readonly", null);
                this.setPerformingIO(false);
                var12_17 = false;
                try {
                    var8_9._endVFSSession(var9_11, var1_1);
                }
                catch (IOException var13_22) {
                    VFSManager.error(var1_1, (String)var7_7, "ioerror", new String[]{var13_22.toString()});
                    this.setPerformingIO(false);
                    return false;
                }
                return var12_17;
            }
            var12_18 = var8_9._canonPath(var9_11, (String)var7_7, var1_1);
            if (!MiscUtilities.isURL(var12_18)) {
                var12_18 = MiscUtilities.resolveSymlinks(var12_18);
            }
            var12_18 = var8_9.getTwoStageSaveName(var12_18);
            if (!jEdit.getBooleanProperty("twoStageSave") || var11_15 && var12_18 != null) break block31;
            var13_23 = GUIUtilities.confirm(var1_1, "vfs.twostageimpossible", new Object[]{var7_7}, 0, 2);
            if (var13_23 == 0) {
                Log.log(7, this, "Buffer saving : two stage save cannot be used");
                this.setBooleanProperty("forbidTwoStageSave", true);
                break block31;
            }
            Log.log(1, this, "Buffer not saved");
            this.setPerformingIO(false);
            var14_26 = false;
            try {
                var8_9._endVFSSession(var9_11, var1_1);
            }
            catch (IOException var15_28) {
                VFSManager.error(var1_1, (String)var7_7, "ioerror", new String[]{var15_28.toString()});
                this.setPerformingIO(false);
                return false;
            }
            return var14_26;
        }
        try {
            var8_9._endVFSSession(var9_11, var1_1);
        }
        catch (IOException var10_13) {
            VFSManager.error(var1_1, (String)var7_7, "ioerror", new String[]{var10_13.toString()});
            this.setPerformingIO(false);
            return false;
        }
        catch (IOException var10_14) {
            try {
                VFSManager.error(var1_1, (String)var7_7, "ioerror", new String[]{var10_14.toString()});
                this.setPerformingIO(false);
                var11_15 = false;
            }
            catch (Throwable var16_29) {
                try {
                    var8_9._endVFSSession(var9_11, var1_1);
                }
                catch (IOException var17_30) {
                    VFSManager.error(var1_1, (String)var7_7, "ioerror", new String[]{var17_30.toString()});
                    this.setPerformingIO(false);
                    return false;
                }
                throw var16_29;
            }
            try {
                var8_9._endVFSSession(var9_11, var1_1);
            }
            catch (IOException var12_19) {
                VFSManager.error(var1_1, (String)var7_7, "ioerror", new String[]{var12_19.toString()});
                this.setPerformingIO(false);
                return false;
            }
            return var11_15;
        }
        if (!var8_9.save(var1_1, this, (String)var7_7)) {
            this.setPerformingIO(false);
            return false;
        }
        AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable((String)var7_7, var3_3){
            final /* synthetic */ String val$newPath;
            final /* synthetic */ boolean val$rename;
            {
                this.val$newPath = string3;
                this.val$rename = bl;
            }

            @Override
            public void run() {
                Buffer.this.setPerformingIO(false);
                Buffer.this.setProperty("overwriteReadonly", null);
                Buffer.this.finishSaving(var1_1, var5_6, var6_10, this.val$newPath, this.val$rename, Buffer.this.getBooleanProperty("BufferIORequest__error"));
                Buffer.this.updateMarkersFile(var1_1);
            }
        });
        return true;
    }

    public int checkFileStatus(View view) {
        if (!this.isPerformingIO() && this.file != null && !this.getFlag(3)) {
            boolean bl;
            boolean bl2 = bl = this.file.exists() && !this.file.canWrite();
            if (bl != this.isFileReadOnly()) {
                this.setFileReadOnly(bl);
                EditBus.send(new BufferUpdate(this, null, BufferUpdate.DIRTY_CHANGED));
            }
            long l = this.modTime;
            long l2 = this.file.lastModified();
            if (l2 != l) {
                this.modTime = l2;
                if (!this.file.exists()) {
                    this.setFlag(3, true);
                    this.setDirty(true);
                    return 2;
                }
                return 1;
            }
        }
        return 0;
    }

    public long getLastModified() {
        return this.modTime;
    }

    public void setLastModified(long l) {
        this.modTime = l;
    }

    public boolean getAutoReload() {
        return this.getFlag(6);
    }

    public void setAutoReload(boolean bl) {
        this.setFlag(6, bl);
        this.autoreloadOverridden = this.isAutoreloadPropertyOverriden();
    }

    public boolean getAutoReloadDialog() {
        return this.getFlag(7);
    }

    public void setAutoReloadDialog(boolean bl) {
        this.setFlag(7, bl);
        this.autoreloadOverridden = this.isAutoreloadPropertyOverriden();
    }

    public VFS getVFS() {
        return VFSManager.getVFSForPath(this.path);
    }

    public File getAutosaveFile() {
        return this.autosaveFile;
    }

    public void removeAutosaveFile() {
        if (this.autosaveFile != null) {
            this.autosaveFile.delete();
            this.setFlag(5, true);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public String getPath(Boolean bl) {
        return bl != false ? MiscUtilities.abbreviateView(this.path) : this.getPath();
    }

    public String getSymlinkPath() {
        return this.symlinkPath;
    }

    public String getDirectory() {
        return this.directory;
    }

    public boolean isClosed() {
        return this.getFlag(0);
    }

    public boolean isLoaded() {
        return !this.isLoading();
    }

    public boolean isNewFile() {
        return this.getFlag(3);
    }

    public void setNewFile(boolean bl) {
        this.setFlag(3, bl);
        if (!bl) {
            this.setFlag(4, false);
        }
    }

    public boolean isUntitled() {
        return this.getFlag(4);
    }

    @Override
    public void setDirty(boolean bl) {
        boolean bl2 = this.isDirty();
        if (this.isUntitled() && jEdit.getBooleanProperty("suppressNotSavedConfirmUntitled")) {
            bl = false;
        }
        if (bl && this.getLength() == this.initialLength && jEdit.getBooleanProperty("useMD5forDirtyCalculation")) {
            bl = !Arrays.equals(this.calculateHash(), this.md5hash);
        }
        super.setDirty(bl);
        boolean bl3 = this.isEditable();
        if (bl) {
            if (bl3) {
                this.setFlag(5, true);
            }
        } else {
            this.setFlag(5, false);
            if (this.autosaveFile != null) {
                this.autosaveFile.delete();
            }
        }
        if (bl != bl2 && bl3) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.DIRTY_CHANGED));
        }
    }

    public boolean isTemporary() {
        return this.getFlag(10);
    }

    public Icon getIcon() {
        if (this.isDirty()) {
            return GUIUtilities.loadIcon("dirty.gif");
        }
        if (this.isReadOnly()) {
            return GUIUtilities.loadIcon("readonly.gif");
        }
        if (this.getFlag(3)) {
            return GUIUtilities.loadIcon("new.gif");
        }
        return GUIUtilities.loadIcon("normal.gif");
    }

    @Override
    public void propertiesChanged() {
        super.propertiesChanged();
        this.longLineLimit = jEdit.getIntegerProperty("longLineLimit", 4000);
        String string = this.getStringProperty("largefilemode");
        boolean bl = this.longBufferMode = "limited".equals(string) || "nohighlight".equals(string);
        if (!this.autoreloadOverridden) {
            this.setAutoReloadDialog(jEdit.getBooleanProperty("autoReloadDialog"));
            this.setAutoReload(jEdit.getBooleanProperty("autoReload"));
        }
        if (!this.isTemporary()) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.PROPERTIES_CHANGED));
        }
    }

    @Override
    public Object getDefaultProperty(String string) {
        Object object;
        if (this.mode != null) {
            Object object2 = this.mode.getProperty(string);
            if (object2 == null) {
                return null;
            }
            this.setDefaultProperty(string, object2);
            return object2;
        }
        String string2 = jEdit.getProperty("buffer." + string);
        if (string2 == null) {
            return null;
        }
        try {
            object = new Integer(string2);
        }
        catch (NumberFormatException numberFormatException) {
            object = string2;
        }
        return object;
    }

    public void toggleWordWrap(View view) {
        String string = this.getStringProperty("wrap");
        if (string.equals("none")) {
            String string2 = this.getStringProperty("largefilemode");
            string = "limited".equals(string2) || "nohighlight".equals(string2) ? "hard" : "soft";
        } else if (string.equals("soft")) {
            string = "hard";
        } else if (string.equals("hard")) {
            string = "none";
        }
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.wrap-changed", new String[]{string}));
        this.setProperty("wrap", string);
        this.propertiesChanged();
    }

    public void toggleAutoIndent(View view) {
        String string = this.getStringProperty("autoIndent");
        if (string.equals("none")) {
            string = "simple";
        } else if (string.equals("simple")) {
            string = "full";
        } else if (string.equals("full")) {
            string = "none";
        }
        this.setProperty("autoIndent", string);
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.autoindent-changed", new String[]{string}));
    }

    public void toggleLineSeparator(View view) {
        String string = null;
        String string2 = this.getStringProperty("lineSeparator");
        if ("\n".equals(string2)) {
            string = "windows";
            string2 = "\r\n";
        } else if ("\r\n".equals(string2)) {
            string = "mac";
            string2 = "\r";
        } else if ("\r".equals(string2)) {
            string = "unix";
            string2 = "\n";
        }
        view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.linesep-changed", new String[]{jEdit.getProperty("lineSep." + string)}));
        this.setProperty("lineSeparator", string2);
        this.setDirty(true);
        this.propertiesChanged();
    }

    @Override
    public String getContextSensitiveProperty(int n, String string) {
        ParserRuleSet parserRuleSet;
        Object object = super.getContextSensitiveProperty(n, string);
        if (object == null && (object = jEdit.getMode((parserRuleSet = this.getRuleSetAtOffset(n)).getModeName()).getProperty(string)) == null) {
            object = this.mode.getProperty(string);
        }
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public void setMode() {
        Object object;
        Mode mode = null;
        String string = this.getStringProperty("mode");
        if (string != null) {
            this.unsetProperty("mode");
            mode = ModeProvider.instance.getMode(string);
        }
        if (mode == null) {
            object = this.getLineText(0);
            mode = ModeProvider.instance.getModeForFile(this.getVFS().getFilePath(this.path), null, (String)object);
        }
        if (mode != null) {
            int n = jEdit.getIntegerProperty("largeBufferSize", 4000000);
            if (!this.getFlag(10) && this.getLength() > n && n > 0) {
                mode.loadIfNecessary();
                boolean bl = mode.getBooleanProperty("contextInsensitive");
                String string2 = jEdit.getProperty("largefilemode", "ask");
                if ("ask".equals(string2)) {
                    if (!bl) {
                        JTextPane jTextPane = new JTextPane();
                        jTextPane.setEditable(false);
                        jTextPane.setText(jEdit.getProperty("largeBufferDialog.message"));
                        int n2 = JOptionPane.showOptionDialog(jEdit.getActiveView(), jTextPane, jEdit.getProperty("largeBufferDialog.title", new String[]{this.name}), -1, 2, null, new String[]{jEdit.getProperty("largeBufferDialog.fullSyntax"), jEdit.getProperty("largeBufferDialog.contextInsensitive"), jEdit.getProperty("largeBufferDialog.defaultMode")}, jEdit.getProperty("largeBufferDialog.contextInsensitive"));
                        switch (n2) {
                            case 0: {
                                this.setProperty("largefilemode", "full");
                                this.setMode(mode);
                                return;
                            }
                            case 1: {
                                this.setProperty("largefilemode", "limited");
                                this.setMode(mode, true);
                                return;
                            }
                            case 2: {
                                this.setProperty("largefilemode", "nohighlight");
                                mode = Buffer.getDefaultMode();
                                this.setMode(mode);
                                return;
                            }
                        }
                    }
                } else if ("full".equals(string2)) {
                    this.setProperty("largefilemode", "full");
                    this.setMode(mode);
                } else if ("limited".equals(string2)) {
                    this.setProperty("largefilemode", "limited");
                    this.setMode(mode, true);
                } else if ("nohighlight".equals(string2)) {
                    this.setProperty("largefilemode", "nohighlight");
                    mode = Buffer.getDefaultMode();
                    this.setMode(mode);
                }
            }
            this.setMode(mode);
            return;
        }
        object = Buffer.getDefaultMode();
        if (object != null) {
            this.setMode((Mode)object);
        }
    }

    private static Mode getDefaultMode() {
        Mode mode = jEdit.getMode(jEdit.getProperty("buffer.defaultMode"));
        if (mode == null) {
            mode = jEdit.getMode("text");
        }
        return mode;
    }

    @Deprecated
    public File getFile() {
        return this.file;
    }

    public Vector<Marker> getMarkers() {
        return this.markers;
    }

    public String getMarkerStatusPrompt(String string) {
        return jEdit.getProperty("view.status." + string, new String[]{this.getMarkerNameString()});
    }

    public String getMarkerNameString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Marker marker : this.markers) {
            if (marker.getShortcut() == '\u0000') continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(marker.getShortcut());
        }
        if (stringBuilder.length() == 0) {
            return jEdit.getProperty("view.status.no-markers");
        }
        return stringBuilder.toString();
    }

    public void addOrRemoveMarker(char c, int n) {
        int n2 = this.getLineOfOffset(n);
        if (this.getMarkerAtLine(n2) != null) {
            this.removeMarker(n2);
        } else {
            this.addMarker(c, n);
        }
    }

    public void addMarker(char c, int n) {
        Marker marker = new Marker(this, c, n);
        boolean bl = false;
        if (this.isLoaded()) {
            Marker marker2;
            int n2;
            this.setFlag(12, true);
            marker.createPosition();
            for (n2 = 0; n2 < this.markers.size(); ++n2) {
                marker2 = this.markers.get(n2);
                if (c != '\u0000' && marker2.getShortcut() == c) {
                    marker2.setShortcut('\u0000');
                }
                if (marker2.getPosition() != n) continue;
                this.markers.removeElementAt(n2);
                --n2;
            }
            for (n2 = 0; n2 < this.markers.size(); ++n2) {
                marker2 = this.markers.get(n2);
                if (marker2.getPosition() <= n) continue;
                this.markers.insertElementAt(marker, n2);
                bl = true;
                break;
            }
        }
        if (!bl) {
            this.markers.addElement(marker);
        }
        if (this.isLoaded() && !this.getFlag(10)) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
        }
    }

    public Marker getMarkerInRange(int n, int n2) {
        for (Marker marker : this.markers) {
            int n3 = marker.getPosition();
            if (n3 < n || n3 >= n2) continue;
            return marker;
        }
        return null;
    }

    public Marker getMarkerAtLine(int n) {
        for (Marker marker : this.markers) {
            if (this.getLineOfOffset(marker.getPosition()) != n) continue;
            return marker;
        }
        return null;
    }

    public void removeMarker(int n) {
        for (int i = 0; i < this.markers.size(); ++i) {
            Marker marker = this.markers.get(i);
            if (this.getLineOfOffset(marker.getPosition()) != n) continue;
            this.setFlag(12, true);
            marker.removePosition();
            this.markers.removeElementAt(i);
            --i;
        }
        EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
    }

    public void removeAllMarkers() {
        this.setFlag(12, true);
        for (Marker marker : this.markers) {
            marker.removePosition();
        }
        this.markers.removeAllElements();
        if (this.isLoaded()) {
            EditBus.send(new BufferUpdate(this, null, BufferUpdate.MARKERS_CHANGED));
        }
    }

    public Marker getMarker(char c) {
        for (Marker marker : this.markers) {
            if (marker.getShortcut() != c) continue;
            return marker;
        }
        return null;
    }

    public static String getMarkersPath(VFS vFS, String string) {
        return vFS.getParentOfPath(string) + '.' + vFS.getFileName(string) + ".marks";
    }

    public boolean updateMarkersFile(View view) {
        if (!this.markersChanged()) {
            return true;
        }
        VFS vFS = VFSManager.getVFSForPath(this.getPath());
        if ((vFS.getCapabilities() & 2) == 0 || !vFS.isMarkersFileSupported()) {
            VFSManager.error(view, this.path, "vfs.not-supported.save", new String[]{"markers file"});
            return false;
        }
        Object object = vFS.createVFSSession(this.path, view);
        if (object == null) {
            return false;
        }
        ThreadUtilities.runInBackground(new MarkersSaveRequest(view, this, object, vFS, this.path));
        return true;
    }

    public boolean markersChanged() {
        return this.getFlag(12);
    }

    public void setMarkersChanged(boolean bl) {
        this.setFlag(12, bl);
    }

    public void setWaitSocket(Socket socket) {
        this.waitSocket = socket;
    }

    public Buffer getNext() {
        return this.next;
    }

    public Buffer getPrev() {
        return this.prev;
    }

    public int getIndex() {
        int n = 0;
        Buffer buffer = this.prev;
        while (buffer != null) {
            ++n;
            buffer = buffer.prev;
        }
        return n;
    }

    public String toString() {
        return this.name + " (" + MiscUtilities.abbreviateView(this.directory) + ')';
    }

    public void addBufferUndoListener(BufferUndoListener bufferUndoListener) {
        this.undoListeners.add(bufferUndoListener);
    }

    public void removeBufferUndoListener(BufferUndoListener bufferUndoListener) {
        this.undoListeners.remove(bufferUndoListener);
    }

    Buffer(String string, boolean bl, boolean bl2, Map map) {
        super(map);
        this.setFlag(10, bl2);
        this.setPath(string);
        this.setFlag(4, bl);
        this.setFlag(3, bl);
        this.setFlag(6, jEdit.getBooleanProperty("autoReload"));
        this.setFlag(7, jEdit.getBooleanProperty("autoReloadDialog"));
        this.undoListeners = new Vector<BufferUndoListener>();
    }

    void commitTemporary() {
        this.setFlag(10, false);
        this.finishLoading();
    }

    void close() {
        this.setFlag(0, true);
        if (this.autosaveFile != null) {
            this.autosaveFile.delete();
        }
        if (this.waitSocket != null) {
            try {
                this.waitSocket.getOutputStream().write(0);
                this.waitSocket.getOutputStream().flush();
                this.waitSocket.getInputStream().close();
                this.waitSocket.getOutputStream().close();
                this.waitSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected TokenMarker.LineContext markTokens(Segment segment, TokenMarker.LineContext lineContext, TokenHandler tokenHandler) {
        TokenMarker.LineContext lineContext2 = this.longBufferMode && this.longLineLimit != 0 && this.longLineLimit < segment.length() ? this.textTokenMarker.markTokens(lineContext, tokenHandler, segment) : this.tokenMarker.markTokens(lineContext, tokenHandler, segment);
        return lineContext2;
    }

    @Override
    protected void fireBeginUndo() {
        for (BufferUndoListener bufferUndoListener : this.undoListeners) {
            try {
                bufferUndoListener.beginUndo(this);
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer undo event to " + bufferUndoListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    @Override
    protected void fireEndUndo() {
        for (BufferUndoListener bufferUndoListener : this.undoListeners) {
            try {
                bufferUndoListener.endUndo(this);
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer undo event to " + bufferUndoListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    @Override
    protected void fireBeginRedo() {
        for (BufferUndoListener bufferUndoListener : this.undoListeners) {
            try {
                bufferUndoListener.beginRedo(this);
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer begin redo event to " + bufferUndoListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    @Override
    protected void fireEndRedo() {
        for (BufferUndoListener bufferUndoListener : this.undoListeners) {
            try {
                bufferUndoListener.endRedo(this);
            }
            catch (Throwable throwable) {
                Log.log(9, this, "Exception while sending buffer end redo event to " + bufferUndoListener + " :");
                Log.log(9, this, throwable);
            }
        }
    }

    private void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= 1 << n) : (this.flags &= ~(1 << n));
    }

    private boolean getFlag(int n) {
        int n2 = 1 << n;
        return (this.flags & n2) == n2;
    }

    private boolean isAutoreloadPropertyOverriden() {
        return this.getFlag(6) != jEdit.getBooleanProperty("autoReload") || this.getFlag(7) != jEdit.getBooleanProperty("autoReloadDialog");
    }

    private void setPath(final String string) {
        jEdit.visit(new JEditVisitorAdapter(){

            @Override
            public void visit(EditPane editPane) {
                editPane.bufferRenamed(Buffer.this.path, string);
            }
        });
        this.path = string;
        VFS vFS = VFSManager.getVFSForPath(string);
        if ((vFS.getCapabilities() & 2) == 0) {
            this.setFileReadOnly(true);
        }
        this.name = vFS.getFileName(string);
        this.directory = vFS.getParentOfPath(string);
        if (vFS instanceof FileVFS) {
            this.file = new File(string);
            this.symlinkPath = MiscUtilities.resolveSymlinks(string);
            if (this.autosaveFile != null) {
                this.autosaveFile.delete();
            }
            this.autosaveFile = new File(this.file.getParent(), '#' + this.name + '#');
        } else {
            this.file = null;
            this.autosaveFile = null;
            this.symlinkPath = string;
        }
    }

    private boolean recoverAutosave(final View view) {
        if (!this.autosaveFile.canRead()) {
            return false;
        }
        GUIUtilities.hideSplashScreen();
        final Object[] objectArray = new Object[]{this.autosaveFile.getPath()};
        int n = GUIUtilities.confirm(view, "autosave-found", objectArray, 0, 2);
        if (n == 0) {
            VFSManager.getFileVFS().load(view, this, this.autosaveFile.getPath());
            AwtRunnableQueue.INSTANCE.runAfterIoTasks(new Runnable(){

                @Override
                public void run() {
                    GUIUtilities.message(view, "autosave-loaded", objectArray);
                }
            });
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean checkFileForLoad(View view, VFS vFS, String string) {
        if ((vFS.getCapabilities() & 0x40) != 0) {
            Object object;
            block22: {
                VFSFile vFSFile;
                block21: {
                    block20: {
                        object = vFS.createVFSSession(string, view);
                        if (object == null) {
                            return false;
                        }
                        vFSFile = vFS._getFile(object, string, view);
                        if (vFSFile != null) break block20;
                        this.setNewFile(true);
                        boolean bl = true;
                        try {
                            vFS._endVFSSession(object, view);
                        }
                        catch (IOException iOException) {
                            VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                            return false;
                        }
                        return bl;
                    }
                    if (vFSFile.isReadable()) break block21;
                    VFSManager.error(view, string, "ioerror.no-read", null);
                    this.setNewFile(false);
                    boolean bl = false;
                    try {
                        vFS._endVFSSession(object, view);
                    }
                    catch (IOException iOException) {
                        VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                        return false;
                    }
                    return bl;
                }
                this.setFileReadOnly(!vFSFile.isWriteable());
                if (vFSFile.getType() == 0) break block22;
                VFSManager.error(view, string, "ioerror.open-directory", null);
                this.setNewFile(false);
                boolean bl = false;
                try {
                    vFS._endVFSSession(object, view);
                }
                catch (IOException iOException) {
                    VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                    return false;
                }
                return bl;
            }
            try {
                vFS._endVFSSession(object, view);
            }
            catch (IOException iOException) {
                VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                return false;
            }
            catch (IOException iOException) {
                boolean bl;
                try {
                    VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        vFS._endVFSSession(object, view);
                    }
                    catch (IOException iOException2) {
                        VFSManager.error(view, string, "ioerror", new String[]{iOException2.toString()});
                        return false;
                    }
                    throw throwable;
                }
                try {
                    vFS._endVFSSession(object, view);
                }
                catch (IOException iOException3) {
                    VFSManager.error(view, string, "ioerror", new String[]{iOException3.toString()});
                    return false;
                }
                return bl;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static boolean checkFileForSave(View view, VFS vFS, String string) {
        if ((vFS.getCapabilities() & 0x40) != 0) {
            Object object;
            block18: {
                VFSFile vFSFile;
                block17: {
                    object = vFS.createVFSSession(string, view);
                    if (object == null) {
                        return false;
                    }
                    vFSFile = vFS._getFile(object, string, view);
                    if (vFSFile != null) break block17;
                    boolean bl = true;
                    try {
                        vFS._endVFSSession(object, view);
                    }
                    catch (IOException iOException) {
                        VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                        return false;
                    }
                    return bl;
                }
                if (vFSFile.getType() == 0) break block18;
                VFSManager.error(view, string, "ioerror.save-directory", null);
                boolean bl = false;
                try {
                    vFS._endVFSSession(object, view);
                }
                catch (IOException iOException) {
                    VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                    return false;
                }
                return bl;
            }
            try {
                vFS._endVFSSession(object, view);
            }
            catch (IOException iOException) {
                VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                return false;
            }
            catch (IOException iOException) {
                boolean bl;
                try {
                    VFSManager.error(view, string, "ioerror", new String[]{iOException.toString()});
                    bl = false;
                }
                catch (Throwable throwable) {
                    try {
                        vFS._endVFSSession(object, view);
                    }
                    catch (IOException iOException2) {
                        VFSManager.error(view, string, "ioerror", new String[]{iOException2.toString()});
                        return false;
                    }
                    throw throwable;
                }
                try {
                    vFS._endVFSSession(object, view);
                }
                catch (IOException iOException3) {
                    VFSManager.error(view, string, "ioerror", new String[]{iOException3.toString()});
                    return false;
                }
                return bl;
            }
        }
        return true;
    }

    private byte[] calculateHash() {
        byte[] byArray = new byte[1];
        if (!jEdit.getBooleanProperty("useMD5forDirtyCalculation")) {
            return byArray;
        }
        return StandardUtilities.md5(this.getSegment(0, this.getLength()));
    }

    private void updateHash() {
        this.initialLength = this.getLength();
        this.md5hash = this.calculateHash();
    }

    private void finishLoading() {
        this.updateHash();
        this.parseBufferLocalProperties();
        FoldHandler foldHandler = this.getFoldHandler();
        this.setMode();
        if (this.getFoldHandler() == foldHandler) {
            this.invalidateFoldLevels();
            this.fireFoldHandlerChanged();
        }
        for (Marker marker : this.markers) {
            marker.removePosition();
            int n = marker.getPosition();
            if (n > this.getLength()) {
                marker.setPosition(this.getLength());
            } else if (n < 0) {
                marker.setPosition(0);
            }
            marker.createPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishSaving(View view, String string, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        if (!bl2 && !string3.equals(string)) {
            object = jEdit.getBuffer(string3);
            if (bl) {
                if (object != null && !((Buffer)object).getPath().equals(string)) {
                    ((Buffer)object).setDirty(false);
                    jEdit.closeBuffer(view, (Buffer)object);
                }
                this.setPath(string3);
                jEdit.visit(new JEditVisitorAdapter(){

                    @Override
                    public void visit(EditPane editPane) {
                        BufferSet bufferSet = editPane.getBufferSet();
                        if (bufferSet.indexOf(Buffer.this) != -1) {
                            bufferSet.sort();
                        }
                    }
                });
            } else if (object != null && !((Buffer)object).getPath().equals(string)) {
                ((Buffer)object).load(view, true);
            }
        }
        if (bl) {
            if (this.file != null) {
                this.modTime = this.file.lastModified();
            }
            if (!bl2) {
                try {
                    this.writeLock();
                    if (this.autosaveFile != null) {
                        this.autosaveFile.delete();
                    }
                    this.setFlag(5, false);
                    this.setFileReadOnly(false);
                    this.setFlag(3, false);
                    this.setFlag(4, false);
                    super.setDirty(false);
                    if (jEdit.getBooleanProperty("resetUndoOnSave")) {
                        this.undoMgr.clear();
                    }
                }
                finally {
                    this.writeUnlock();
                }
                this.parseBufferLocalProperties();
                if (!this.getPath().equals(string)) {
                    if (!this.isTemporary()) {
                        jEdit.updatePosition(string2, this);
                    }
                    this.setMode();
                } else {
                    object = this.getStringProperty("mode");
                    if (object != null && !((String)object).equals(this.getMode().getName())) {
                        this.setMode();
                    }
                }
                this.updateHash();
                if (!this.isTemporary()) {
                    EditBus.send(new BufferUpdate(this, view, BufferUpdate.DIRTY_CHANGED));
                    EditBus.send(new BufferUpdate(this, view, BufferUpdate.SAVED));
                }
            }
        }
    }
}

