/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import javajs.util.A4;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.Quat;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.c.STR;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class AminoMonomer
extends AlphaMonomer {
    private static final byte CA = 0;
    private static final byte O = 1;
    private static final byte N = 2;
    private static final byte C = 3;
    private static final byte OT = 4;
    static final byte[] interestingAminoAtomIDs = new byte[]{2, -5, 1, 3, -65};
    boolean nhChecked = false;
    private static final float beta = 0.29670596f;
    private P3 ptTemp;

    protected AminoMonomer() {
    }

    static Monomer validateAndAllocate(Chain chain, String group3, int seqcode, int firstAtomIndex, int lastAtomIndex, int[] specialAtomIndexes, Atom[] atoms) {
        byte[] offsets = AminoMonomer.scanForOffsets(firstAtomIndex, specialAtomIndexes, interestingAminoAtomIDs);
        if (offsets == null) {
            return null;
        }
        AminoMonomer.checkOptional(offsets, (byte)1, firstAtomIndex, specialAtomIndexes[5]);
        if (atoms[firstAtomIndex].isHetero() && !AminoMonomer.isBondedCorrectly(firstAtomIndex, offsets, atoms)) {
            return null;
        }
        return new AminoMonomer().set2(chain, group3, seqcode, firstAtomIndex, lastAtomIndex, offsets);
    }

    private static boolean isBondedCorrectlyRange(int offset1, int offset2, int firstAtomIndex, byte[] offsets, Atom[] atoms) {
        int atomIndex1 = firstAtomIndex + (offsets[offset1] & 0xFF);
        int atomIndex2 = firstAtomIndex + (offsets[offset2] & 0xFF);
        return atomIndex1 != atomIndex2 && atoms[atomIndex1].isBonded(atoms[atomIndex2]);
    }

    private static boolean isBondedCorrectly(int firstAtomIndex, byte[] offsets, Atom[] atoms) {
        return AminoMonomer.isBondedCorrectlyRange(2, 0, firstAtomIndex, offsets, atoms) && AminoMonomer.isBondedCorrectlyRange(0, 3, firstAtomIndex, offsets, atoms) && (!AminoMonomer.have(offsets, (byte)1) || AminoMonomer.isBondedCorrectlyRange(3, 1, firstAtomIndex, offsets, atoms));
    }

    boolean isAminoMonomer() {
        return true;
    }

    public Atom getNitrogenAtom() {
        return this.getAtomFromOffsetIndex(2);
    }

    Atom getCarbonylCarbonAtom() {
        return this.getAtomFromOffsetIndex(3);
    }

    public Atom getCarbonylOxygenAtom() {
        return this.getWingAtom();
    }

    @Override
    Atom getInitiatorAtom() {
        return this.getNitrogenAtom();
    }

    @Override
    Atom getTerminatorAtom() {
        return this.getAtomFromOffsetIndex(AminoMonomer.have(this.offsets, (byte)4) ? 4 : 3);
    }

    boolean hasOAtom() {
        return AminoMonomer.have(this.offsets, (byte)1);
    }

    @Override
    boolean isConnectedAfter(Monomer possiblyPreviousMonomer) {
        if (possiblyPreviousMonomer == null) {
            return true;
        }
        AminoMonomer other = (AminoMonomer)possiblyPreviousMonomer;
        return other.getCarbonylCarbonAtom().isBonded(this.getNitrogenAtom());
    }

    @Override
    void findNearestAtomIndex(int x, int y, Atom[] closest, short madBegin, short madEnd) {
        Atom alpha;
        int radiusEnd;
        Atom competitor = closest[0];
        Atom nitrogen = this.getNitrogenAtom();
        int marBegin = madBegin / 2;
        if (marBegin < 1200) {
            marBegin = 1200;
        }
        if (nitrogen.sZ == 0) {
            return;
        }
        int radiusBegin = (int)this.scaleToScreen(nitrogen.sZ, marBegin);
        if (radiusBegin < 4) {
            radiusBegin = 4;
        }
        Atom ccarbon = this.getCarbonylCarbonAtom();
        int marEnd = madEnd / 2;
        if (marEnd < 1200) {
            marEnd = 1200;
        }
        if ((radiusEnd = (int)this.scaleToScreen(nitrogen.sZ, marEnd)) < 4) {
            radiusEnd = 4;
        }
        if (this.isCursorOnTopOf(alpha = this.getLeadAtom(), x, y, (radiusBegin + radiusEnd) / 2, competitor) || this.isCursorOnTopOf(nitrogen, x, y, radiusBegin, competitor) || this.isCursorOnTopOf(ccarbon, x, y, radiusEnd, competitor)) {
            closest[0] = alpha;
        }
    }

    public void resetHydrogenPoint() {
        this.nhChecked = false;
        this.nitrogenHydrogenPoint = null;
    }

    P3 getNitrogenHydrogenPoint() {
        if (this.nitrogenHydrogenPoint == null && !this.nhChecked) {
            this.nhChecked = true;
            this.nitrogenHydrogenPoint = this.getExplicitNH();
        }
        return this.nitrogenHydrogenPoint;
    }

    public Atom getExplicitNH() {
        Atom nitrogen = this.getNitrogenAtom();
        Atom h = null;
        Bond[] bonds = nitrogen.bonds;
        if (bonds != null) {
            for (int i = 0; i < bonds.length; ++i) {
                h = bonds[i].getOtherAtom(nitrogen);
                if (h.getElementNumber() != 1) continue;
                return h;
            }
        }
        return null;
    }

    public boolean getNHPoint(P3 aminoHydrogenPoint, V3 vNH, boolean jmolHPoint, boolean dsspIgnoreHydrogens) {
        if (this.monomerIndex <= 0 || this.groupID == 15) {
            return false;
        }
        Atom nitrogenPoint = this.getNitrogenAtom();
        P3 nhPoint = this.getNitrogenHydrogenPoint();
        if (nhPoint != null && !dsspIgnoreHydrogens) {
            vNH.sub2((T3)nhPoint, (T3)nitrogenPoint);
            aminoHydrogenPoint.setT((T3)nhPoint);
            return true;
        }
        AminoMonomer prev = (AminoMonomer)this.bioPolymer.monomers[this.monomerIndex - 1];
        if (jmolHPoint) {
            vNH.sub2((T3)nitrogenPoint, (T3)this.getLeadAtom());
            vNH.normalize();
            V3 v = V3.newVsub((T3)nitrogenPoint, (T3)prev.getCarbonylCarbonAtom());
            v.normalize();
            vNH.add((T3)v);
        } else {
            Atom oxygen = prev.getCarbonylOxygenAtom();
            if (oxygen == null) {
                return false;
            }
            vNH.sub2((T3)prev.getCarbonylCarbonAtom(), (T3)oxygen);
        }
        vNH.normalize();
        aminoHydrogenPoint.add2((T3)nitrogenPoint, (T3)vNH);
        this.nitrogenHydrogenPoint = P3.newP((T3)aminoHydrogenPoint);
        if (Logger.debugging) {
            Logger.debug((String)("draw ID \"pta" + this.monomerIndex + "_" + nitrogenPoint.i + "\" " + Escape.eP((T3)nitrogenPoint) + Escape.eP((T3)aminoHydrogenPoint) + " # " + nitrogenPoint));
        }
        return true;
    }

    @Override
    P3 getQuaternionFrameCenter(char qType) {
        if (this.monomerIndex < 0) {
            return null;
        }
        switch (qType) {
            default: {
                return this.getQuaternionFrameCenterAlpha(qType);
            }
            case 'n': {
                return this.getNitrogenAtom();
            }
            case 'P': 
            case 'p': {
                return this.getCarbonylCarbonAtom();
            }
            case 'q': 
        }
        if (this.monomerIndex == this.bioPolymer.monomerCount - 1) {
            return null;
        }
        AminoMonomer mNext = (AminoMonomer)this.bioPolymer.monomers[this.monomerIndex + 1];
        P3 pt = new P3();
        pt.ave((T3)this.getCarbonylCarbonAtom(), (T3)mNext.getNitrogenAtom());
        return pt;
    }

    @Override
    public Quat getQuaternion(char qType) {
        if (this.monomerIndex < 0) {
            return null;
        }
        Atom ptC = this.getCarbonylCarbonAtom();
        Atom ptCa = this.getLeadAtom();
        V3 vA = new V3();
        V3 vB = new V3();
        V3 vC = null;
        switch (qType) {
            case 'a': 
            case 'n': {
                if (this.monomerIndex == 0 || this.groupID == 15) {
                    return null;
                }
                vC = new V3();
                if (this.ptTemp == null) {
                    this.ptTemp = new P3();
                }
                this.getNHPoint(this.ptTemp, vC, true, false);
                vB.sub2((T3)ptCa, (T3)this.getNitrogenAtom());
                vB.cross((T3)vC, (T3)vB);
                new M3().setAA(A4.newVA((V3)vB, (float)-0.29670596f)).rotate((T3)vC);
                vA.cross((T3)vB, (T3)vC);
                break;
            }
            case 'b': {
                return this.getQuaternionAlpha('b');
            }
            case 'c': {
                vA.sub2((T3)ptC, (T3)ptCa);
                vB.sub2((T3)this.getNitrogenAtom(), (T3)ptCa);
                break;
            }
            case 'p': 
            case 'x': {
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1) {
                    return null;
                }
                vA.sub2((T3)ptCa, (T3)ptC);
                vB.sub2((T3)((AminoMonomer)this.bioPolymer.monomers[this.monomerIndex + 1]).getNitrogenAtom(), (T3)ptC);
                break;
            }
            case 'q': {
                if (this.monomerIndex == this.bioPolymer.monomerCount - 1) {
                    return null;
                }
                AminoMonomer mNext = (AminoMonomer)this.bioPolymer.monomers[this.monomerIndex + 1];
                vB.sub2((T3)mNext.getLeadAtom(), (T3)mNext.getNitrogenAtom());
                vA.sub2((T3)ptCa, (T3)ptC);
                break;
            }
            default: {
                return null;
            }
        }
        return Quat.getQuaternionFrameV((V3)vA, (V3)vB, (V3)vC, (boolean)false);
    }

    @Override
    public String getStructureId() {
        if (this.proteinStructure == null || this.proteinStructure.structureID == null) {
            return "";
        }
        return this.proteinStructure.structureID;
    }

    public String getProteinStructureTag() {
        if (this.proteinStructure == null || this.proteinStructure.structureID == null) {
            return null;
        }
        String tag = "%3N %3ID";
        tag = PT.formatStringI((String)tag, (String)"N", (int)this.proteinStructure.serialID);
        tag = PT.formatStringS((String)tag, (String)"ID", (String)this.proteinStructure.structureID);
        if (this.proteinStructure.type == STR.SHEET) {
            tag = tag + PT.formatStringI((String)"%2SC", (String)"SC", (int)this.proteinStructure.strandCount);
        }
        return tag;
    }

    public BS getBSSideChain() {
        BS bs = new BS();
        this.setAtomBits(bs);
        this.clear(bs, this.getLeadAtom(), true);
        this.clear(bs, this.getCarbonylCarbonAtom(), false);
        this.clear(bs, this.getCarbonylOxygenAtom(), false);
        this.clear(bs, this.getNitrogenAtom(), true);
        return bs;
    }

    private void clear(BS bs, Atom a, boolean andH) {
        if (a == null) {
            return;
        }
        bs.clear(a.i);
        if (!andH) {
            return;
        }
        Bond[] b = a.bonds;
        int j = b.length;
        while (--j >= 0) {
            Atom h = b[j].getOtherAtom(a);
            if (h.getElementNumber() != 1) continue;
            bs.clear(h.i);
        }
    }
}

