/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.OTFont;
import jogamp.graph.font.typecast.ot.OTFontCollection;
import jogamp.graph.font.typecast.ot.table.BaseTable;
import jogamp.graph.font.typecast.ot.table.CffTable;
import jogamp.graph.font.typecast.ot.table.CmapTable;
import jogamp.graph.font.typecast.ot.table.CvtTable;
import jogamp.graph.font.typecast.ot.table.DirectoryEntry;
import jogamp.graph.font.typecast.ot.table.DsigTable;
import jogamp.graph.font.typecast.ot.table.FpgmTable;
import jogamp.graph.font.typecast.ot.table.GaspTable;
import jogamp.graph.font.typecast.ot.table.GlyfTable;
import jogamp.graph.font.typecast.ot.table.GposTable;
import jogamp.graph.font.typecast.ot.table.GsubTable;
import jogamp.graph.font.typecast.ot.table.HdmxTable;
import jogamp.graph.font.typecast.ot.table.HeadTable;
import jogamp.graph.font.typecast.ot.table.HheaTable;
import jogamp.graph.font.typecast.ot.table.HmtxTable;
import jogamp.graph.font.typecast.ot.table.KernTable;
import jogamp.graph.font.typecast.ot.table.LocaTable;
import jogamp.graph.font.typecast.ot.table.LtshTable;
import jogamp.graph.font.typecast.ot.table.MaxpTable;
import jogamp.graph.font.typecast.ot.table.NameTable;
import jogamp.graph.font.typecast.ot.table.Os2Table;
import jogamp.graph.font.typecast.ot.table.PcltTable;
import jogamp.graph.font.typecast.ot.table.PostTable;
import jogamp.graph.font.typecast.ot.table.PrepTable;
import jogamp.graph.font.typecast.ot.table.Table;
import jogamp.graph.font.typecast.ot.table.VdmxTable;
import jogamp.graph.font.typecast.ot.table.VheaTable;
import jogamp.graph.font.typecast.ot.table.VmtxTable;

public class TableFactory {
    public static Table create(OTFontCollection oTFontCollection, OTFont oTFont, DirectoryEntry directoryEntry, DataInputStream dataInputStream) throws IOException {
        Table table = null;
        if (oTFontCollection != null && (table = oTFontCollection.getTable(directoryEntry)) != null) {
            return table;
        }
        switch (directoryEntry.getTag()) {
            case 1111577413: {
                table = new BaseTable(directoryEntry, dataInputStream);
                break;
            }
            case 1128678944: {
                table = new CffTable(directoryEntry, dataInputStream);
                break;
            }
            case 1146308935: {
                table = new DsigTable(directoryEntry, dataInputStream);
                break;
            }
            case 0x45424454: {
                break;
            }
            case 1161972803: {
                break;
            }
            case 1161974595: {
                break;
            }
            case 1195656518: {
                break;
            }
            case 1196445523: {
                table = new GposTable(directoryEntry, dataInputStream);
                break;
            }
            case 1196643650: {
                table = new GsubTable(directoryEntry, dataInputStream);
                break;
            }
            case 1246975046: {
                break;
            }
            case 1280594760: {
                table = new LtshTable(directoryEntry, dataInputStream);
                break;
            }
            case 1296909912: {
                break;
            }
            case 1296913220: {
                break;
            }
            case 1330851634: {
                table = new Os2Table(directoryEntry, dataInputStream);
                break;
            }
            case 1346587732: {
                table = new PcltTable(directoryEntry, dataInputStream);
                break;
            }
            case 1447316824: {
                table = new VdmxTable(directoryEntry, dataInputStream);
                break;
            }
            case 1668112752: {
                table = new CmapTable(directoryEntry, dataInputStream);
                break;
            }
            case 1668707360: {
                table = new CvtTable(directoryEntry, dataInputStream);
                break;
            }
            case 1718642541: {
                table = new FpgmTable(directoryEntry, dataInputStream);
                break;
            }
            case 1719034226: {
                break;
            }
            case 1734439792: {
                table = new GaspTable(directoryEntry, dataInputStream);
                break;
            }
            case 1735162214: {
                table = new GlyfTable(directoryEntry, dataInputStream, oTFont.getMaxpTable(), oTFont.getLocaTable());
                break;
            }
            case 1751412088: {
                table = new HdmxTable(directoryEntry, dataInputStream, oTFont.getMaxpTable());
                break;
            }
            case 1751474532: {
                table = new HeadTable(directoryEntry, dataInputStream);
                break;
            }
            case 1751672161: {
                table = new HheaTable(directoryEntry, dataInputStream);
                break;
            }
            case 1752003704: {
                table = new HmtxTable(directoryEntry, dataInputStream, oTFont.getHheaTable(), oTFont.getMaxpTable());
                break;
            }
            case 1801810542: {
                table = new KernTable(directoryEntry, dataInputStream);
                break;
            }
            case 1819239265: {
                table = new LocaTable(directoryEntry, dataInputStream, oTFont.getHeadTable(), oTFont.getMaxpTable());
                break;
            }
            case 1835104368: {
                table = new MaxpTable(directoryEntry, dataInputStream);
                break;
            }
            case 1851878757: {
                table = new NameTable(directoryEntry, dataInputStream);
                break;
            }
            case 1886545264: {
                table = new PrepTable(directoryEntry, dataInputStream);
                break;
            }
            case 1886352244: {
                table = new PostTable(directoryEntry, dataInputStream);
                break;
            }
            case 1986553185: {
                table = new VheaTable(directoryEntry, dataInputStream);
                break;
            }
            case 1986884728: {
                table = new VmtxTable(directoryEntry, dataInputStream, oTFont.getVheaTable(), oTFont.getMaxpTable());
            }
        }
        if (oTFontCollection != null && table != null) {
            oTFontCollection.addTable(table);
        }
        return table;
    }
}

