/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.progress;

import java.util.concurrent.atomic.AtomicLong;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.logging.events.OperationIdentifier;
import org.gradle.internal.logging.progress.ProgressLogger;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.internal.progress.BuildOperationDetails;
import org.gradle.internal.progress.BuildOperationExecutor;
import org.gradle.internal.progress.BuildOperationInternal;
import org.gradle.internal.progress.InternalBuildListener;
import org.gradle.internal.progress.OperationResult;
import org.gradle.internal.progress.OperationStartEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildOperationExecutor
implements BuildOperationExecutor {
    private final InternalBuildListener listener;
    private final TimeProvider timeProvider;
    private final ProgressLoggerFactory progressLoggerFactory;
    private final AtomicLong nextId = new AtomicLong();
    private final ThreadLocal<OperationDetails> currentOperation = new ThreadLocal();

    public DefaultBuildOperationExecutor(InternalBuildListener listener, TimeProvider timeProvider, ProgressLoggerFactory progressLoggerFactory) {
        this.listener = listener;
        this.timeProvider = timeProvider;
        this.progressLoggerFactory = progressLoggerFactory;
    }

    @Override
    public Object getCurrentOperationId() {
        OperationDetails current = this.currentOperation.get();
        if (current == null) {
            throw new IllegalStateException("No operation is currently running.");
        }
        return current.id;
    }

    @Override
    public void run(String displayName, Runnable action) {
        this.run(BuildOperationDetails.displayName(displayName).build(), Factories.toFactory((Runnable)action));
    }

    @Override
    public void run(BuildOperationDetails operationDetails, Runnable action) {
        this.run(operationDetails, Factories.toFactory((Runnable)action));
    }

    @Override
    public <T> T run(String displayName, Factory<T> factory) {
        return this.run(BuildOperationDetails.displayName(displayName).build(), factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T run(BuildOperationDetails operationDetails, Factory<T> factory) {
        OperationDetails parent = this.currentOperation.get();
        OperationIdentifier parentId = parent == null ? null : parent.id;
        OperationIdentifier id = new OperationIdentifier(this.nextId.getAndIncrement());
        this.currentOperation.set(new OperationDetails(parent, id));
        try {
            long startTime = this.timeProvider.getCurrentTime();
            BuildOperationInternal operation = new BuildOperationInternal(id, parentId, operationDetails.getDisplayName());
            this.listener.started(operation, new OperationStartEvent(startTime));
            Object result = null;
            Throwable failure = null;
            try {
                ProgressLogger progressLogger;
                if (operationDetails.getProgressDisplayName() != null) {
                    progressLogger = this.progressLoggerFactory.newOperation(DefaultBuildOperationExecutor.class);
                    progressLogger.setDescription(operationDetails.getDisplayName());
                    progressLogger.setShortDescription(operationDetails.getProgressDisplayName());
                    progressLogger.started();
                } else {
                    progressLogger = null;
                }
                try {
                    result = factory.create();
                }
                finally {
                    if (progressLogger != null) {
                        progressLogger.completed();
                    }
                }
            }
            catch (Throwable t) {
                failure = t;
            }
            long endTime = this.timeProvider.getCurrentTime();
            this.listener.finished(operation, new OperationResult(startTime, endTime, failure));
            if (failure != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)failure);
            }
            Object object = result;
            return (T)object;
        }
        finally {
            this.currentOperation.set(parent);
        }
    }

    private static class OperationDetails {
        final OperationDetails parent;
        final OperationIdentifier id;

        public OperationDetails(OperationDetails parent, OperationIdentifier id) {
            this.parent = parent;
            this.id = id;
        }
    }
}

