/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.projectmodule;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.artifacts.DefaultModuleIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.CompositeBuildContext;
import org.gradle.initialization.ReportedException;
import org.gradle.internal.component.local.model.LocalComponentMetaData;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompositeBuildContext
implements CompositeBuildContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCompositeBuildContext.class);
    private final Multimap<ModuleIdentifier, ProjectComponentIdentifier> replacementProjects = ArrayListMultimap.create();
    private final Map<ProjectComponentIdentifier, RegisteredProject> projectMetadata = Maps.newHashMap();

    public ProjectComponentIdentifier getReplacementProject(ModuleComponentSelector selector) {
        ModuleIdentifier candidateId = DefaultModuleIdentifier.newId(selector.getGroup(), selector.getModule());
        Collection providingProjects = this.replacementProjects.get((Object)candidateId);
        if (providingProjects.isEmpty()) {
            LOGGER.info("Found no composite build substitute for module '" + candidateId + "'.");
            return null;
        }
        if (providingProjects.size() == 1) {
            ProjectComponentIdentifier match = (ProjectComponentIdentifier)providingProjects.iterator().next();
            LOGGER.info("Found project '" + match + "' as substitute for module '" + candidateId + "'.");
            return match;
        }
        TreeSet sortedProjects = Sets.newTreeSet((Iterable)CollectionUtils.collect((Iterable)providingProjects, (Transformer)new Transformer<String, ProjectComponentIdentifier>(){

            public String transform(ProjectComponentIdentifier projectComponentIdentifier) {
                return projectComponentIdentifier.getProjectPath();
            }
        }));
        String failureMessage = String.format("Module version '%s' is not unique in composite: can be provided by projects %s.", selector.getDisplayName(), sortedProjects);
        throw new ModuleVersionResolveException((ComponentSelector)selector, failureMessage);
    }

    public LocalComponentMetaData getProject(ProjectComponentIdentifier project) {
        RegisteredProject registeredProject = this.projectMetadata.get(project);
        return registeredProject == null ? null : registeredProject.metaData;
    }

    public File getProjectDirectory(ProjectComponentIdentifier project) {
        RegisteredProject registeredProject = this.projectMetadata.get(project);
        if (registeredProject == null) {
            throw new IllegalStateException(String.format("Requested %s which was never registered", project));
        }
        return registeredProject.projectDirectory;
    }

    public void register(ModuleIdentifier moduleId, ProjectComponentIdentifier project, LocalComponentMetaData localComponentMetaData, File projectDirectory) {
        LOGGER.info("Registering project '" + project + "' in composite build. Will substitute for module '" + moduleId + "'.");
        this.replacementProjects.put((Object)moduleId, (Object)project);
        if (this.projectMetadata.containsKey(project)) {
            String failureMessage = String.format("Project path '%s' is not unique in composite.", project.getProjectPath());
            throw new ReportedException((Throwable)new GradleException(failureMessage));
        }
        this.projectMetadata.put(project, new RegisteredProject(localComponentMetaData, projectDirectory));
    }

    private static class RegisteredProject {
        LocalComponentMetaData metaData;
        File projectDirectory;

        public RegisteredProject(LocalComponentMetaData metaData, File projectDirectory) {
            this.metaData = metaData;
            this.projectDirectory = projectDirectory;
        }
    }
}

