/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.loaded;

import java.lang.reflect.Modifier;
import org.springsource.loaded.Constants;

public abstract class AbstractMember
implements Constants {
    protected final int modifiers;
    protected final String name;
    protected final String descriptor;
    protected int id = -1;
    protected final String signature;
    private final boolean isPrivate;

    protected AbstractMember(int modifiers, String name, String descriptor, String signature) {
        this.modifiers = modifiers;
        this.name = name;
        this.descriptor = descriptor;
        this.signature = signature;
        this.isPrivate = Modifier.isPrivate(modifiers);
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescriptor() {
        return this.descriptor;
    }

    public String getGenericSignature() {
        return this.signature;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final int getId() {
        if (this.id == -1) {
            throw new IllegalStateException("id not yet allocated");
        }
        return this.id;
    }

    public final void setId(int id) {
        this.id = id;
    }

    public final boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    public final boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    public final boolean isPrivate() {
        return this.isPrivate;
    }

    public final boolean isProtected() {
        return Modifier.isProtected(this.getModifiers());
    }

    public final boolean isPublic() {
        return Modifier.isPublic(this.getModifiers());
    }

    public boolean isPrivateOrStaticOrFinal() {
        return (this.modifiers & 0x1A) != 0;
    }
}

