/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListNotesCommand
extends GitCommand<List<Note>> {
    private String notesRef = "refs/notes/commits";

    protected ListNotesCommand(Repository repo) {
        super(repo);
    }

    @Override
    public List<Note> call() throws GitAPIException {
        this.checkCallable();
        ArrayList<Note> notes = new ArrayList<Note>();
        RevWalk walk = new RevWalk(this.repo);
        NoteMap map = NoteMap.newEmptyMap();
        try {
            Ref ref = this.repo.getRef(this.notesRef);
            if (ref != null) {
                RevCommit notesCommit = walk.parseCommit(ref.getObjectId());
                map = NoteMap.read(walk.getObjectReader(), notesCommit);
            }
            Iterator<Note> i = map.iterator();
            while (i.hasNext()) {
                notes.add(i.next());
            }
        }
        catch (IOException e) {
            throw new JGitInternalException(e.getMessage(), e);
        }
        finally {
            walk.release();
        }
        return notes;
    }

    public ListNotesCommand setNotesRef(String notesRef) {
        this.checkCallable();
        this.notesRef = notesRef;
        return this;
    }
}

